#ifdef __GNUG__
#pragma implementation
#endif
#include "DSet.h" 
#include "Environ.h" 


Pix TOrderedObjectSet::seek(const TOrderedObject& item) const
{
  Pix i;
  for (i = first(); i != 0 && !(TOrderedObjectEQ((*this)(i), item)); next(i));
  return i;
}

int TOrderedObjectSet::owns(Pix idx) const
{
  if (idx == 0) return 0;
  for (Pix i = first(); i; next(i)) if (i == idx) return 1;
  return 0;
}

void TOrderedObjectSet::clear()
{
  Pix i = first(); 
  while (i != 0)
  {
    del((*this)(i));
    i = first();
  }
}

int TOrderedObjectSet::contains (const TOrderedObject& item) 
{
  return seek(item) != 0;
}

int TOrderedObjectSet::operator <= (const TOrderedObjectSet& b) 
{
  if (fNObjects > b.fNObjects) return 0;
  if (fNObjects == 0) return 1;
  for (Pix i = first(); i; next(i)) if (b.seek((*this)(i)) == 0) return 0;
  return 1;
}

int TOrderedObjectSet::operator == (const TOrderedObjectSet& b) 
{
  int n = fNObjects;
  if (n != b.fNObjects) return 0;
  if (n == 0) return 1;
  Pix i = first();
  Pix j = b.first();
  while (n-- > 0)
  {
    if ((b.seek((*this)(i)) == 0) || (seek(b(j)) == 0)) return 0;
    next(i);
    b.next(j);
  }
  return 1;
}

int TOrderedObjectSet::operator != (const TOrderedObjectSet& b) 
{
  return !(*this == b);
}

void TOrderedObjectSet::operator |= (TOrderedObjectSet& b)
{
  if (&b != this)
    for (Pix i = b.first(); i; b.next(i)) add(b(i));
}

void TOrderedObjectSet::operator -= (TOrderedObjectSet& b)
{
  if (&b == this)
    clear();
  else
    for (Pix i = b.first(); i; b.next(i)) del(b(i));
}


void TOrderedObjectSet::operator &= (TOrderedObjectSet& b)
{
  if (&b != this)
  {
    Pix i = first();
    Pix n = i;
    while (i != 0)
    {
      next(n);
      if (b.seek((*this)(i)) == 0) del((*this)(i));
      i = n;
    }
  }
}

void TOrderedObjectSet::error(char* msg) const
{
  gPrintScreen(msg);
  BreakToSourceDebugger_();
}
