#ifndef _TOrderedObjectSet_h
#ifdef __GNUG__
#pragma interface
#endif
#define _TOrderedObjectSet_h 1

#include "Globals.h"
#include "TObjects.h"

class TOrderedObjectSet
{
protected:

  int                   fNObjects;

public:
  inline virtual              ~TOrderedObjectSet();

  int                   length() const ;                // current number of items
  int                   empty() const ;

  virtual Pix           add(TOrderedObject& item) = 0;      // add item; return Pix
  virtual void          del(const TOrderedObject& item) = 0;      // delete item;
  virtual int                   contains(const TOrderedObject& item);     // is item in set?

  virtual void          clear();                 // delete all items

  virtual Pix           first() const = 0;             // Pix of first item or 0
  virtual void          next(Pix& i) const = 0;        // advance to next or 0
  virtual TOrderedObject&          operator () (Pix i) const = 0; // access item at i
  virtual TOrderedObject&          get_object (Pix i) const = 0; // access item at i

  virtual int           owns(Pix i) const ;             // is i a valid Pix  ?
	Pix           seek(const TOrderedObject& item) const;         // Pix of item

  virtual void                  subset_add( Pix p, byte setIndex ) = 0;
  virtual void                  subset_delete( Pix p, byte setIndex ) = 0;
  virtual byte                  subset_contains( Pix p, byte setIndex ) const = 0;

	void                  operator |= (TOrderedObjectSet& b); // add all items in b
	void                  operator -= (TOrderedObjectSet& b); // delete items also in b
	void                  operator &= (TOrderedObjectSet& b); // delete items not in b

	int                   operator == (const TOrderedObjectSet& b);
  int                   operator != (const TOrderedObjectSet& b);
  int                   operator <= (const TOrderedObjectSet& b); 

  virtual void                  error(char* msg) const;
  virtual int                   OK() const  = 0;               // rep invariant
};

inline TOrderedObjectSet::~TOrderedObjectSet() {}

inline int TOrderedObjectSet::length() const
{
  return fNObjects;
}

inline int TOrderedObjectSet::empty() const
{
  return fNObjects == 0;
}

typedef TOrderedObjectSet Set;

#endif
