#include "Encode.h"

#include <math.h>
#include <string.h>

void SRLE_Encoder::add_value(float v)
{
  if (!_use_floats && _started) 
    _fvalue = (float)_lvalue;
  _use_floats = 1;
  
  if (!_started) 
    {
      _count  = 1;
      _fvalue = v;
      _started++;    
    }
  else 
    {
      if (fabs(v - _fvalue) < _accuracy)
	  _count++;
      else
	{
	  flush(0);
	  _fvalue = v;
	  _count = 1;
	}
    }
}

void SRLE_Encoder::add_value(long v)
{
  if (_use_floats) 
    add_value((float)v);
  else 
    {
      if (!_started) 
	{
	  _count  = 1;
	  _lvalue = v;
	  _started++;
	}
      else {
	if (v == _lvalue)
	  _count++;
	else
	  {
	    flush(0);
	    _lvalue = v;
	    _count = 1;
	  }
      }
    }
}

void SRLE_Encoder::flush(int end)
{
  char buf[256];
  if (_count == 1)
    sprintf(buf, _use_floats? "%g" : "%ld", _use_floats? _fvalue : _lvalue);
  else
    {
      if (_use_floats)
	sprintf(buf, "%d:%g",  _count, _fvalue);
      else
	sprintf(buf, "%d:%ld", _count, _lvalue);
    }
  if (!end)
    strcat(buf, ",");

  output_func f = outfun();
  (*f)(function_parms(), buf);
}

#ifdef __TRY_ME__

#include <stream.h>

void of(void* v, const char* p)
{
  printf("added: %s\n", p);
}

main ()
{
  SRLE_Encoder encoder(of);
  
  float f;

  while (!cin.eof())
    {
      cin >> f;
      encoder << f;
    }

  encoder.flush();
}

#endif
