//----------------------------------------------------------------------------------------;
//	Globals.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __GLobals__
#define __GLobals__

#ifdef unix
#ifdef HAS_X
#include <X11/X.h>
#include <X11/Xlib.h>
#endif
#include "purify.h"
#endif

#ifdef USE_MPI
#include <mpi.h>
#endif

#ifdef CYGWIN
#define socklen_t  int
#endif

#ifdef POWERPC
#define socklen_t  int
#endif

#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <float.h>
#include <errno.h>

#ifndef errno
extern int errno;
#endif

#define	MAXINT		32767		/* (2**15)-1, max positive int */
#define POUND       ((unsigned char)0x23)
#define STDARG			1
#define INLINE_METHODS          1

#define MAX_JBYTE 127
#define MAX_JSHORT 32767
#define MAX_JINT 2147483647

#ifndef TRUE
#define TRUE (1)
#define FALSE (0)
#endif

#ifndef True
#define True (1)
#define False (0)
#endif

#ifndef Bool
#define Bool byte
#endif

#ifndef _Pix_h
#define _Pix_h 1
typedef void* Pix;
#endif

#ifndef byte
typedef unsigned char byte;
#endif

#ifndef __P
#ifdef __STDC__
#define __P(protos) protos
#else
#define __P(protos) ()
#endif
#endif /*!__P*/
#if !defined(__STDC__) && !defined(const)
#define const
#endif
#if !defined(__STDC__) && !defined(void)
#define void int
#endif

#define name2(a,b) gEnErIc2(a,b)
#define gEnErIc2(a,b) a ## b

#define name3(a,b,c) gEnErIc3(a,b,c)
#define gEnErIc3(a,b,c) a ## b ## c

#define name4(a,b,c,d) gEnErIc4(a,b,c,d)
#define gEnErIc4(a,b,c,d) a ## b ## c ## d

#define GENERIC_STRING(a) gEnErIcStRiNg(a)
#define gEnErIcStRiNg(a) #a

#define declare(clas,t)        name2(clas,declare)(t)
#define declare2(clas,t1,t2)   name2(clas,declare2)(t1,t2)

#define implement(clas,t)      name2(clas,implement)(t)
#define implement2(clas,t1,t2) name2(clas,implement2)(t1,t2)

#define MAX_MSG_SIZE 5000
extern char gMsgStr[MAX_MSG_SIZE];
extern int gDebug;
extern int gWildCardIndex;
extern byte* gWatchPtr;
extern FILE* gLogFile;
extern int gInterface;
extern int gIProc;
extern int gNProc;
extern int gSpeedOp;
extern int gGlobalFileSystem; 
extern int gMPI; 

#define pure =0

#ifndef FALSE
#define FALSE 0
#define TRUE  1
#endif
#define HIDDEN static

#define EOL             -1
#define NOERR   0

inline int gMyID()  { 
  int ID = 0;
#ifdef USE_MPI
  if( gMPI ) { MPI_Comm_rank(MPI_COMM_WORLD,&ID); }
#endif
  return ID;
}

inline int gNProcs() { 
  int size = 1; 
#ifdef USE_MPI
  if( gMPI ) { MPI_Comm_size(MPI_COMM_WORLD,&size); }
#endif
  return size;
}

/*
typedef unsigned char UINT8;
#ifdef M_I386
typedef unsigned short UINT16;
#else
typedef unsigned int UINT16;
#endif
typedef unsigned long UINT32;

typedef char INT8;
#ifdef M_I386
typedef short INT16;
#else
typedef int INT16;
#endif
typedef long INT32;
*/

typedef unsigned short word;
typedef unsigned long  dword;
typedef unsigned short KEY;

#define SME_UNDEFINED -32767

#undef _SVID

#endif

