#ifndef _intPixMap_h
#define _intPixMap_h 1

#include "Environ.h"
const int INTVHMAP_DEFAULT_INITIAL_CAPACITY = 256;

class intPixMap
{
protected:
  int                   count;
  Pix                   def;

public:
                        intPixMap(Pix  dflt);
  inline virtual              ~intPixMap();

  int                   length() const; // current number of items
  int                   empty() const;

  virtual int           contains(int  key);      // is key mapped?

  virtual void          clear();                 // delete all items

  virtual Pix&          operator [] (int  key) = 0; // access contents by key

  virtual void          del(int  key) = 0;       // delete entry

  virtual Pix           first() = 0;             // Pix of first item or 0
  virtual void          next(Pix& i) = 0;        // advance to next or 0
  virtual int&          key(Pix i) = 0;          // access key at i
  virtual Pix&          contents(Pix i) = 0;     // access contents at i

  virtual int           owns(Pix i);             // is i a valid Pix  ?
  virtual Pix           seek(int  key);          // Pix of key

  Pix&                  dflt();                  // access default val

  void                  error(const char* msg);
  virtual int           OK() = 0;                // rep invariant
};


inline intPixMap::~intPixMap() {}

inline int intPixMap::length() const
{
  return count;
}

inline int intPixMap::empty() const
{
  return count == 0;
}

inline Pix& intPixMap::dflt()
{
  return def;
}

inline intPixMap::intPixMap(Pix  dflt) :def(dflt)
{
  count = 0;
}



class intPixVHMap : public intPixMap
{
protected:
  int*           tab;
  Pix*           cont;
  char*          status;
  unsigned int   size;
  CString        tbuffer;
  
public:
                intPixVHMap( Pix  dflt=0, unsigned int sz=INTVHMAP_DEFAULT_INITIAL_CAPACITY );
                intPixVHMap(intPixVHMap& a);
  inline               ~intPixVHMap();

  Pix&          operator [] (int  key);

  void          del(int  key);

  Pix           first();
  void          next(Pix& i);
  inline int&          key(Pix i);
  inline Pix&          contents(Pix i);

  Pix           seek(int  key);
  inline int           contains(int  key);

  void          clear(); 
  void          resize(unsigned int newsize = 0);

  int           OK();
  
  void 					mark( Pix i, int index=0 );
	int 					is_marked( Pix i, int index=0 );
	const char*   text_representation();     

};

inline intPixVHMap::~intPixVHMap()
{
  delete [] tab;
  delete [] cont;
  delete [] status;
}

inline int intPixVHMap::contains(int  key)
{
  return seek(key) != 0;
}

inline int& intPixVHMap::key(Pix i)
{
  if (i == 0) error("null Pix");
  return *((int*)i);
}

inline Pix& intPixVHMap::contents(Pix i)
{
  if (i == 0) error("null Pix");
  return cont[((int*)i) - tab];
}


#endif
