#ifdef __GNUG__
#pragma implementation
#endif
#include "ODLnkSet.h"


Pix TOrderedObjectODLSet::seek(const TOrderedObject& item )
{
  int cmp = TOrderedObjectCMP( item, _p(sFirst) );
  if(cmp==0) { 
    Pix rv = sFirst; 
    if(sFirst==_p.last()) sFirst = _p.first(); 
    else _p.next(sFirst);
    return rv; 
  }
  else if(cmp>0) {
    for (Pix i = sFirst; i != 0; _p.next(i))
      {
	int cmp = TOrderedObjectCMP(item, _p(i));
	if (cmp == 0) {
	  if(i==_p.last()) sFirst = _p.first(); 
	  else _p.next(sFirst = i);
	  return i;
	}
	else if (cmp < 0)
	  return 0;
      }
    return 0;
  } else {
    for (Pix i = sFirst; i != 0; _p.prev(i))
      {
	int cmp = TOrderedObjectCMP(item, _p(i));
	if (cmp == 0) {
	  if(i==_p.last()) sFirst = _p.first(); 
	  else _p.next(sFirst = i);
	  return i;
	}
	else if (cmp > 0)
	  return 0;
      }
    return 0;
  }
}

Pix TOrderedObjectODLSet::add(TOrderedObject& item )
{
	fUpdateVec = 1;
  Pix i = _p.first();
  if (i == 0) 
  {
    ++fNObjects;
    return (sFirst = _p.prepend(item));
  }
  else {
    Pix i1 = _p.last();
    int cmp = TOrderedObjectCMP(item, _p(i1));
    if (cmp == 0)
      return i1;
    else if (cmp > 0)
      {
	++fNObjects;
	return _p.append(item);
      }
  }
  int cmp = TOrderedObjectCMP(item, _p(i));
  if (cmp == 0)
    return i;
  else if (cmp < 0)
  {
    ++fNObjects;
    return _p.prepend(item);
  }  
  else
  {
    Pix trail = i;
    _p.next(i);
    for (;;)
    {
      if (i == 0)
      {
        ++fNObjects;
        return _p.append(item);
      }
      cmp = TOrderedObjectCMP(item, _p(i));
      if (cmp == 0)
        return i;
      else if (cmp < 0)
      {
        ++fNObjects;
        return _p.ins_after(trail, item);
      }
      else
      {
        trail = i;
        _p.next(i);
      }
    }
  }
}

void TOrderedObjectODLSet::del(const TOrderedObject& item)
{
  Pix i = _p.first();
  if (i == 0)
    return;
  int cmp = TOrderedObjectCMP(item, _p(i));
  if (cmp < 0)
    return;
  else if (cmp == 0)
  {
    --fNObjects;
    _p.del_front();
		fUpdateVec = 1;
  }
  else
  {
    Pix trail = i;
    _p.next(i);
    while (i != 0)
    {
      cmp = TOrderedObjectCMP(item, _p(i));
      if (cmp < 0)
        return;
      else if (cmp == 0)
      {
        --fNObjects;
        _p.del_next_node(trail);
				fUpdateVec = 1;
        return;
      }
      else
      {
        trail = i;
        _p.next(i);
      }
    }
  }
}
        

int TOrderedObjectODLSet::operator <= (const TOrderedObjectODLSet& b) 
{
  if (fNObjects > b.fNObjects) return 0;
  Pix i = first();
  Pix j = b.first();
  for (;;)
  {
    if (i == 0)
      return 1;
    else if (j == 0)
      return 0;
    int cmp = TOrderedObjectCMP(_p(i), b._p(j));
    if (cmp == 0)
    {
      next(i); b.next(j);
    }
    else if (cmp < 0)
      return 0;
    else
      b.next(j);
  }
}

int TOrderedObjectODLSet::operator == (const TOrderedObjectODLSet& b) 
{
  if (fNObjects != b.fNObjects) return 0;
  if (fNObjects == 0) return 1;
  Pix i = _p.first();
  Pix j = b._p.first();
  while (i != 0)
  {
    if (!TOrderedObjectEQ(_p(i),b._p(j))) return 0;
    next(i);
    b.next(j);
  }
  return 1;
}


void TOrderedObjectODLSet::operator |= (TOrderedObjectODLSet& b)  
{
  if (&b == this || b.fNObjects == 0)
    return;
  else
  {
    Pix j = b._p.first();
    Pix i = _p.first();
    Pix trail = 0;
    for (;;)
    {
      if (j == 0)
        return;
      else if (i == 0)
      {
        for (; j != 0; b.next(j))
        {
          ++fNObjects;
          _p.append(b._p(j));
        }
        return;
      }
      int cmp = TOrderedObjectCMP(_p(i), b._p(j));
      if (cmp <= 0)
      {
        if (cmp == 0) b.next(j);
        trail = i;
        next(i);
      }
      else
      {
        ++fNObjects;
        if (trail == 0)
          trail = _p.prepend(b._p(j));
        else
          trail = _p.ins_after(trail, b._p(j));
        b.next(j);
      }
    }
  }
}


void TOrderedObjectODLSet::operator -= (TOrderedObjectODLSet& b)
{
  if (&b == this)
    clear();
  else if (fNObjects != 0 && b.fNObjects != 0)
  {
    Pix i = _p.first();
    Pix j = b._p.first();
    Pix trail = 0;
    for (;;)
    {
      if (j == 0 || i == 0)
        return;
      int cmp = TOrderedObjectCMP(_p(i), b._p(j));
      if (cmp == 0)
      {
        --fNObjects;
        b.next(j);
        if (trail == 0)
        {
          _p.del_front();
          i = _p.first();
        }
        else
        {
          next(i);
          _p.del_next_node(trail);
        }
      }
      else if (cmp < 0)
      {
        trail = i;
        next(i);
      }
      else
        b.next(j);
    }
  }
}

void TOrderedObjectODLSet::operator &= (TOrderedObjectODLSet& b)
{
  if (b.fNObjects == 0)
    clear();
  else if (&b != this && fNObjects != 0)
  {
    Pix i = _p.first();
    Pix j = b._p.first();
    Pix trail = 0;
    for (;;)
    {
      if (i == 0)
        return;
      else if (j == 0)
      {
        if (trail == 0)
        {
          _p.clear();
          fNObjects = 0;
        }
        else
        {
          while (i != 0)
          {
            --fNObjects;
            next(i);
            _p.del_next_node(trail);
          }
        }
        return;
      }
      int cmp = TOrderedObjectCMP(_p(i), b._p(j));

      if (cmp == 0)
      {
        trail = i;
        next(i);
        b.next(j);
      }
      else if (cmp < 0)
      {
        --fNObjects;
        if (trail == 0)
        {
          _p.del_front();
          i = _p.first();
        }
        else
        {
          next(i);
          _p.del_next_node(trail);
        }
      }
      else
        b.next(j);
    }
  }
}


int TOrderedObjectODLSet::OK() const 
{
  int v = _p.OK();
  v &= fNObjects == _p.length();
  Pix trail = _p.first();
  if (trail == 0)
    v &= fNObjects == 0;
  else
  {
    Pix i = trail; next(i);
    while (i != 0)
    {
      v &= TOrderedObjectCMP(_p(trail), _p(i)) < 0;
      trail = i;
      next(i);
    }
  }
  if (!v) error("invariant failure");
  return v;
}
