#ifndef _TOrderedObjectODLSet_h
#ifdef __GNUG__
#pragma interface
#endif
#define _TOrderedObjectODLSet_h 1

#include "DSet.h"
#include "DLnkList.h"

typedef TOrderedObjectDLList TOrderedObjectIterator; 

class TOrderedObjectODLSet : public TOrderedObjectSet
{
  Pix                      sFirst;
  TOrderedObjectDLList     _p;
  PixVec fVec;
  byte fUpdateVec;

protected:
  inline TOrderedObject&  get_object (Pix i) const { return _p(i); } // access item at i

public:
  TOrderedObjectODLSet(int initialSize=64) : _p(initialSize) { fNObjects = 0; sFirst=0; fUpdateVec = 1; }
  TOrderedObjectODLSet(TOrderedObjectODLSet& s) : _p(s._p) { fNObjects  = s.fNObjects; sFirst = s.first(); fUpdateVec = 1; }

  Pix           add(TOrderedObject& item);
  void          del(const TOrderedObject& item);
  virtual inline int   contains(const TOrderedObject& item) {  return seek(item) != 0; }
  inline void          clear() { fNObjects = 0;  _p.clear(); 	fUpdateVec = 1; }
  inline Pix first() const { return _p.first(); }
  inline void next(Pix& idx) const { _p.next(idx); }
  inline TOrderedObjectIterator& iterator() { return _p; }

  inline TOrderedObject&  operator () (Pix i) const { return _p(i); } // access item at i
  inline void DumpLink( Pix   idx, FILE* oFile ) const { _p.DumpLink(idx,oFile); }

  inline int           link (Pix i0, Pix iL, byte lindex) { return _p.link(i0,iL,lindex); }
  inline int           slink (Pix i0, Pix iL, int startIndex=0) { return _p.slink(i0,iL,startIndex); }
  inline TOrderedObject&   link (Pix i, byte lindex) const { return _p.link(i,lindex); }
  inline Pix           plink (Pix i, byte lindex) const { return _p.plink(i,lindex); }
  inline int           owns(Pix i) const  {  return _p.owns(i); }
  inline int           index(const Pix i) const {  return _p.index(i); }
  inline int           set_index(const Pix i, int index) const {  return _p.set_index(i,index); }
  Pix           seek(const TOrderedObject& item) ;
  Pix           append(TOrderedObject& item) { fNObjects++; fUpdateVec = 1; return _p.append(item); } 

  inline void   subset_add( Pix pix, byte setIndex ) { _p.subset_add( pix, setIndex ); }
  inline void   subset_delete( Pix pix, byte setIndex ) { _p.subset_delete( pix, setIndex ); }
  inline byte   subset_contains( Pix pix, byte setIndex ) const { return _p.subset_contains( pix, setIndex ); }

  void          operator |= (TOrderedObjectODLSet& b);
  void          operator -= (TOrderedObjectODLSet& b);
  void          operator &= (TOrderedObjectODLSet& b);

  int           operator == (const TOrderedObjectODLSet& b);
  inline int    operator != (const TOrderedObjectODLSet& b) {  return !(*this == b); }
  int           operator <= (const TOrderedObjectODLSet& b); 

  int           OK() const;

	inline void SetOwnershipCheck( Bool val ) { _p.SetOwnershipCheck(val); }
	
	inline void updateVec() {
		if( fUpdateVec ) { fUpdateVec = 0; _p.CopyToPixVec( fVec ); }
	}
	inline Pix getPix( int index ) { updateVec(); return fVec[index]; }
};

#endif
