//----------------------------------------------------------------------------------------
  //	CPathString.h
  //	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
  //	Change History:
  //----------------------------------------------------------------------------------------

#ifndef __CPathString__
#define __CPathString__

#ifndef _StringRPlex_h
#include "StringPlex.h"
#endif

class CPathString : public StringPlex {

  char fSeparator;
  char fDrive;
  byte fInfo[8];
  static byte kNoData;
  CString fPath;

  void SetSep();
	const CString& GeneratePath(int back_steps=0) const;  
 	int GeneratePath(CString& s) const;  

public:

  CPathString();
  CPathString(const CString& path);
	CPathString(const CPathString& path);

	Bool FullPath(const CString& path) const;
	
  void Add( const char* pathElem );
	void operator= (const CPathString& s); 
	inline CPathString& operator+= (const char* pathElem ) { Add( pathElem ); return *this; }

  inline const char* chars() const {
		GeneratePath();
    return fPath.chars();
  }
  
  inline const CString& Path(const char* terminator = NULL) const {
		GeneratePath();
		if(terminator) { ((CString&)fPath) += terminator; }
    return fPath;
  }

  inline const CString& Path( int back_steps, const char* terminator = NULL ) const {
		GeneratePath(back_steps);
		if(terminator) { ((CString&)fPath) += terminator; }
		else if( back_steps > 0 ) { ((CString&)fPath) += fSeparator; }
		return fPath;
  }
  
  inline const CString& Path(const CString& terminator) const {
		GeneratePath();
		((CString&)fPath) += terminator; 
    return fPath;
  }

  inline int SetPath(CString& path) const {
		return GeneratePath(path);
  }

  inline operator const char*() const { return chars(); }
  inline operator const CString&() const { return Path(); }
};

#endif
