#ifndef _PixVec_h
#ifdef __GNUG__
#pragma interface
#endif
#define _PixVec_h 1

#ifndef __Env__
#include "Environ.h"
#endif

#ifndef _Pix_typedefs
#define _Pix_typedefs 1
typedef void (*PixProcedure)(Pix );
typedef Pix  (*PixMapper)(Pix );
typedef Pix  (*PixCombiner)(Pix , Pix );
typedef unsigned long  (*PixPredicate)(Pix );
typedef void  (*PixPrinter)(Pix,Pix);
typedef int  (*PixComparator)(Pix , Pix );
#endif


class PixVec 
{
protected:      
  int                   len;
  int                   increment;
  Pix                   *s;                  
  static Pix  fGarbage;
  
                        PixVec(int l, Pix* d);
public:
                        PixVec ();
                        PixVec (int l);
                        PixVec (int l, Pix  fill_value);
												PixVec (int l, int inc, Pix  fill_value);
                         PixVec (const PixVec&);
                        ~PixVec ();
	void 								  free();

  PixVec &              operator = (const PixVec & a);
  int                   copy(const PixVec& v);
  PixVec                at(int from = 0, int n = -1);

  int                   capacity() const;
  void                  resize(int newlen);                        

  Pix&                  operator [] (int n);
  Pix&                  elem(int n);

  friend PixVec         concat(PixVec & a, PixVec & b);
  friend PixVec         map(PixMapper f, PixVec & a);
  friend PixVec         merge(PixVec & a, PixVec & b, PixComparator f);
  friend PixVec         combine(PixCombiner f, PixVec & a, PixVec & b);
  friend PixVec         reverse(PixVec & a);
  void					qsort( int first, int last, PixPredicate pix_index, PixPrinter pix_printer=NULL );

  void                  reverse();
  int                  fill(Pix  val, int from = 0, int n = -1);

  void                  apply(PixProcedure f);
  Pix                   reduce(PixCombiner f, Pix  base);
  int                   index(Pix  targ);

  friend int            operator == (PixVec& a, PixVec& b);
  friend int            operator != (PixVec& a, PixVec& b);

  void                  error(const char* msg);
  void                  range_error();
};

inline PixVec::PixVec()
{
  len = 0; s = 0; increment=100;
}

inline PixVec::PixVec(int l)
{
  s = new Pix [len = l];
	fill(0);
	 increment=100;
}


inline PixVec::PixVec(int l, Pix* d) :len(l), s(d) {  increment=100; }


inline PixVec::~PixVec()
{
  delete [] s;
}

inline void PixVec::free()
{
  delete [] s;
  len = 0; s = 0; 
}


inline Pix& PixVec::operator [] (int n)
{
  if ((unsigned)n >= (unsigned)len) { gPrintErr("Illegal Index"); return fGarbage; }
  return s[n];
}

inline Pix& PixVec::elem(int n)
{
  if ((unsigned)n >= (unsigned)len) {
    int oldlen = len;
    resize(n+increment);
    fill(0,oldlen);
  }
  return s[n];
}

inline int PixVec::capacity() const
{
  return len;
}



inline int operator != (PixVec& a, PixVec& b)
{
  return !(a == b);
}

class PixArray : public PixVec 
{
protected:      
  int                fNElem;
public:
 PixArray() : PixVec () { fNElem = 0; }
 PixArray(int l) : PixVec (l) { fNElem = 0; }
 PixArray(int l, Pix  fill_value) : PixVec (l, fill_value) { fNElem = 0; }
 PixArray(int l, int inc, Pix  fill_value) : PixVec (l, inc, fill_value) { fNElem = 0; }
 
 inline int add( Pix p ) { 
	 elem(fNElem++) = p; 
	 return fNElem; 
 }
 inline Pix& add( int index ) {
	 if( index >= fNElem ) { fNElem = index+1; }
	 return elem(index); 
 }
 
 inline PixArray& operator += ( PixArray& v) {
	 for( int i=0; i<v.nElem(); i++ ) {
		 Pix p = v.elem(i);
		 if( p == NULL ) gPrintErr("Adding NULL pix.");
		 add( p );
	 }
	 return *this;
 }
 
  inline PixArray &  operator = ( PixArray &a ) {
		fNElem = 0;
		(*this) += a; 
		return *this;
  }

 inline int nElem() const { return fNElem; }
 void clear() { fNElem = 0; }
 void free() {  fNElem = 0;  PixVec::free(); }
 inline int fill(Pix  val, int size=-1) { return fNElem = PixVec::fill(val,0,size)+1; }
};

#endif
