/* DO NOT EDIT -- this file created by m4 */














/*
*************************************************************************
*									*
* Region3.C								*
*									*
* Class Region3 implements an 3-dimensional region of index space.	*
* A region is considered empty if any of the elements of the upper	*
* bound is less than the corresponding element of the lower bound.	*
*									*
*									*
*************************************************************************
*/

#include "Region3.h"

#define MATCH(s, c) while ((s).get() != (c))

Region3& Region3::operator += (const Region3& rhs)
  {
   if (empty()) return(*this = rhs);
   if (rhs.empty()) return(*this);
   lwp.min(rhs.lwp);
   upp.max(rhs.upp);
   return(*this);
  }

int Region3::operator == (Region3 const & rhs) const
  {
   return(((upp == rhs.upp) && (lwp == rhs.lwp)) || (empty() && rhs.empty()));
  }

/*
*************************************************************************
*									*
* The accrete() and grow() functions increase the size of a region.	*
* Both accrete() and grow() do the same thing.  The CC compiler had	*
* some trouble inlining them, so we define them here.			*
*									*
*************************************************************************
*/

Region3 accrete(const Region3& region, const Point3& p)
  {
   if (region.empty()) return(region);
   return(Region3(region.lower()-p, region.upper()+p));
  }

Region3 grow(const Region3& region, const Point3& p)
  {
   if (region.empty()) return(region);
   return(Region3(region.lower()-p, region.upper()+p));
  }

Region3 accrete(const Region3& region, const int c)
  {
   if (region.empty()) return(region);
   return(Region3(region.lower()-c, region.upper()+c));
  }

Region3 grow(const Region3& region, const int c)
  {
   if (region.empty()) return(region);
   return(Region3(region.lower()-c, region.upper()+c));
  }

Region3* accrete(const Region3 *const region, const int n, const int c)
  {
   Region3 *accreted = new Region3[n];
   for (int i = 0; i < n; i++) accreted[i] = accrete(region[i], c);
   return(accreted);
  }

Region3* grow(const Region3 *const region, const int n, const int c)
  {
   Region3 *grown = new Region3[n];
   for (int i = 0; i < n; i++) grown[i] = grow(region[i], c);
   return(grown);
  }

Region3* accrete(const Region3 *const region, const int n, const Point3& p)
  {
   Region3 *accreted = new Region3[n];
   for (int i = 0; i < n; i++) accreted[i] = accrete(region[i], p);
   return(accreted);
  }

Region3* grow(const Region3 *const region, const int n, const Point3& p)
  {
   Region3 *grown = new Region3[n];
   for (int i = 0; i < n; i++) grown[i] = grow(region[i], p);
   return(grown);
  }
