#ifndef _StringRPlex_h
#ifdef __GNUG__
#pragma interface
#endif
#define _StringRPlex_h 1

#include "CString.h"
#include "Plex.h"
#include <stddef.h>
#include <stdarg.h>


class StringPlex : public Plex
{
	public:
  inline  StringPlex() : Plex() {;}                  
  inline  StringPlex(int size) : Plex(size) {;}                  
  inline  StringPlex(StringPlex& v) : Plex(v) {;}                 
	
  inline CString&      elem (int idx) { return (CString&) Plex::elem (idx); } 
  inline CString&      elem (Pix p)   { return (CString&) Plex::elem (p); } 
  virtual inline VObject* dup() const { return new StringPlex((StringPlex&)*this); }

// read-only versions for const Plexes

  inline const CString& operator [] (int idx) const { return (const CString&) Plex::operator [] (idx); }
  inline const CString& operator () (Pix p) const   { return (const CString&) Plex::operator () (p); }
  inline const CString&      elem (int idx) const  { return (const CString&) Plex::elem (idx); } 
  inline const CString&      elem (Pix p) const     { return (const CString&) Plex::elem (p); } 
  inline CString*  get( int index ) { return (CString*) Plex::objptr(index); }
  
  int find(const CString& v, Bool case_sensitive=True ) const {
	for (int i = 0; i < size(); i++) {
	  CString* s = (CString*) Plex::objptr(i);
	  if( case_sensitive ) {
		if( s && s->equals(v) ) return i;
	  } else {
		if( s && s->equals_nocase(v) ) return i;
	  }
	}
	return -1;
  }


  inline CString* add(const CString& obj, int index = -1) {
		return (CString*) Plex::add( obj, index );
  }
  inline CString* add(char* str, int index = -1) {
		return (CString*) Plex::add( CString(str), index );
  }

  inline CString*      add_high(const CString&  elem) { return add(elem); }
  inline CString*      add_high(const char*  str) { return add(str); }
  inline CString*       add_low(const CString&  elem) { return (CString*) insert(elem,0); }

};

/*
	protected:
	
  int              base;        // base index of lowest chunk
  int              lch;         // index of lowest used chunk
  int              fch;         // 1 + index of highest used chunk
  int              maxch;       // max chunks in array
  CStringIChunk**      chunks;      // array of chunks
  CStringIChunk*       ch;          // cached chunk
  static CString         fDbgStr;

  void             make_initial_chunks(int up = 1);

  inline void      cache(int idx) const;
  void             cache(const CString* p) const;
  CString*             dopred(const CString* p) const;
  CString*             dosucc(const CString* p) const;

  inline void             set_cache(const CStringIChunk* t) const; // logically, 
                                               // not physically const

public:
                   StringPlex();                 // set low = 0;
                                               // fence = 0;
                                               // csize = default

                   StringPlex(int ch_size);      // low = 0; 
                                               // fence = 0;
                                               // csize = ch_size

                   StringPlex(int lo,            // low = lo; 
                            int ch_size);      // fence=lo
                                               // csize = ch_size

                   StringPlex(int lo,            // low = lo
                            int hi,            // fence = hi+1
                            const CString  initval,// fill with initval,
                            int ch_size = 0);  // csize= ch_size
                                               // or fence-lo if 0

                   StringPlex(const StringPlex&);

  inline                  ~StringPlex();

  void             operator= (const StringPlex&);

// virtuals

//  inline CString&             high_element ();
//  inline CString&             low_element ();

  inline const CString&       high_element () const;
  inline const CString&       low_element () const;

  inline Pix              first() const;
  inline Pix              last() const;
  inline void             prev(Pix& ptr) const;
  inline void             next(Pix& ptr) const;
  int              owns(Pix p) const;
	inline CString&             elem (Pix p);
  inline const CString&       operator () (Pix p) const;

  inline int              low() const; 
  inline int              high() const;
  inline int              valid(int idx) const;
  inline void             prev(int& idx) const;
  inline void             next(int& x) const;
	inline CString&             elem (int index);
  inline const CString&       operator [] (int index) const;
    
  inline int              Pix_to_index(Pix p) const;
  inline Pix              index_to_Pix(int idx) const;    

  inline int              can_add_high() const;
  inline int              can_add_low() const;
  inline int              full() const;

  int              add_high(const CString&  elem);
  int              add_high(const char*  elem);
 int               grow_high();

  int              del_high ();
  int              add_low (const CString&  elem);
  int              del_low ();

  void             fill(const CString  x);
  void             fill(const CString  x, int from, int to);
  void             clear();
  void             reverse();

  int              reset_low(int newlow);
    
  int              OK () const; 


};
*/

typedef class TMsgBuff TMsgBuff;

class ArgArray : public StringPlex {

  const static int MAX_ARGS = 64;
  CString fBuffer;
  CString fDbgStr;
  static char* _buff[MAX_ARGS];
  
#ifdef USE_MPI
	void Pack(TMsgBuff* mb ) ;
	void UnPack(TMsgBuff* mb );
#endif

public:
	ArgArray( const ArgArray& a ) : StringPlex((StringPlex&)a) { ; }
  ArgArray( char* header, int chunksize=16 ) : StringPlex(chunksize) { add(header);  }
  ArgArray( int chunksize =16 ) : StringPlex(chunksize) { ; }
  ArgArray( int nargs,  ... ) : StringPlex(16) {
    va_list ap; va_start(ap,nargs); 
    for( int i=0; i < nargs; i++ ) {
      char* s = va_arg ( ap, char* );
      add( s ); 
    }
    va_end (ap); 
  }

  inline int NArgs() const { return _items; }

	 void Print( FILE* oFile ) ;
	 void PrintList( FILE* oFile ) const ;
	 void PrintList( CString& s ) const ;
	 virtual inline VObject* dup() const { return new ArgArray(*this); }
  
  inline CString* Add( const CString& elem ) { add( elem ); return (CString*) &elem; } 
	inline CString* Add( const char* elem );
	int AddList( const char* list , char sep = 0 );
  void ShiftLow();

  inline int Find( const CString& s ) const { return find((CString&)s); }

  inline const char* dump () {
    for( Pix p = first(); p; next(p) ) {
      fDbgStr += (*this)(p);
      fDbgStr += " ";
    }
    return fDbgStr.chars(); 
  }
 
   inline int operator == ( ArgArray& a ) const { 
	 for( int i=0; i<_items; i++ ) {
	   CString& s0 = *((CString*) objptr(i));
	   CString& s1 = a.elem(i);
	  if( !(s0 == s1) ) return 0;
	 }
	return 1;
  }
 
  inline char** Args() {
	int nargs = ( _items >= MAX_ARGS ) ? MAX_ARGS-1 : _items;
	for( int i=0; i<nargs; i++ ) {
	  _buff[i] = (char*)((CString*) objptr(i))->chars();
	}
	_buff[nargs] = 0;
	return (char**) _buff;
  }

  inline int Find( const char* s, Bool case_sens=True ) const { CString str(s); return find(str,case_sens); }
  inline Bool Contains( const CString& s, Bool case_sens=True ) const { return  ( Find(s,case_sens) >= 0 ); }
  inline Bool Contains( const char* s, Bool case_sens=True  ) const { return  ( Find(s,case_sens) >= 0 ); }

  inline CString&  elem(int index) {
		CString* val = (CString*) objptr(index);
		if( val == NULL ) { insert(CString(""), index); }
		return StringPlex::elem(index);
  }
  
	inline CString&  elem (Pix p) { return StringPlex::elem(p); }
  void operator= (const ArgArray& a);
  inline const CString& Top () const;
  const char* string(); 

#ifdef USE_MPI
	inline int Send( int srcProc, int destProc, MPI_Comm comm = MPI_COMM_WORLD ) ;
	int BroadCast(  int srcProc = 0, MPI_Comm comm = MPI_COMM_WORLD ) ;
#endif // MPI

};

inline CString* ArgArray::Add( const char* str ) { 
	return StringPlex::add( str );
}

inline const CString& ArgArray::Top () const {
	Pix p = last();
  return (const CString&) operator()(p);
}


/*

inline int CStringIChunk:: size() const
{
  return top - base;
}


inline int CStringIChunk:: base_index() const
{
  return base;
}

inline  int CStringIChunk:: low_index() const
{
  return low;
}

inline  int  CStringIChunk:: fence_index() const
{
  return fence;
}

inline  int  CStringIChunk:: top_index() const
{
  return top;
}

inline  CString* CStringIChunk:: pointer_to(int i) const
{
  return &(data[i-base]);
}

inline  int  CStringIChunk:: index_of(const CString* p) const
{
  return (p - data) / sizeof(CString) + base;
}

inline  int  CStringIChunk:: possible_index(int i) const
{
  return i >= base && i < top;
}

inline  int  CStringIChunk:: possible_pointer(const CString* p) const
{
  return p >= data && p < &(data[top-base]);
}

inline  int  CStringIChunk:: actual_index(int i) const
{
  return i >= low && i < fence;
}

inline  int  CStringIChunk:: actual_pointer(const CString* p) const
{
  return p >= data && p < &(data[fence-base]);
}

inline  int  CStringIChunk:: can_grow_high () const
{
  return fence < top;
}

inline  int  CStringIChunk:: can_grow_low () const
{
  return base < low;
}

inline  CString* CStringIChunk:: invalidate()
{
  CString* p = data;
  data = 0;
  return p;
}


inline CStringIChunk* CStringIChunk::prev() const
{
  return prv;
}

inline CStringIChunk* CStringIChunk::next() const
{
  return nxt;
}

inline void CStringIChunk::link_to_prev(CStringIChunk* prev)
{
  nxt = prev->nxt;
  prv = prev;
  nxt->prv = this;
  prv->nxt = this;
}

inline void CStringIChunk::link_to_next(CStringIChunk* next)
{
  prv = next->prv;
  nxt = next;
  nxt->prv = this;
  prv->nxt = this;
}

inline void CStringIChunk::unlink()
{
  CStringIChunk* n = nxt;
  CStringIChunk* p = prv;
  n->prv = p;
  p->nxt = n;
  prv = nxt = this;
}

inline  int CStringIChunk:: empty() const
{
  return low == fence;
}

inline  int  CStringIChunk:: full() const
{
  return top - base == fence - low;
}

inline int CStringIChunk:: first_index() const
{
  return (low == fence)? fence : low;
}

inline int CStringIChunk:: last_index() const
{
  return (low == fence)? low - 1 : fence - 1;
}

inline  int  CStringIChunk:: succ(int i) const
{
  return (i < low) ? low : i + 1;
}

inline  int  CStringIChunk:: pred(int i) const
{
  return (i > fence) ? (fence - 1) : i - 1;
}

inline  int  CStringIChunk:: valid_index(int i) const
{
  return i >= low && i < fence;
}

inline  int  CStringIChunk:: valid_pointer(const CString* p) const
{
  return p >= &(data[low - base]) && p < &(data[fence - base]);
}

inline  CString* CStringIChunk:: grow_high ()
{
  if (!can_grow_high()) full_error();
  return &(data[fence++ - base]);
}

inline  CString* CStringIChunk:: grow_low ()
{
  if (!can_grow_low()) full_error();
  return &(data[--low - base]);
}

inline  void CStringIChunk:: shrink_high ()
{
  if (empty()) empty_error();
  --fence;
}

inline  void CStringIChunk:: shrink_low ()
{
  if (empty()) empty_error();
  ++low;
}

inline CString* CStringIChunk::first_pointer() const
{
  return (low == fence)? 0 : &(data[low - base]);
}

inline CString* CStringIChunk::last_pointer() const
{
  return (low == fence)? 0 : &(data[fence - base - 1]);
}

inline CString* CStringIChunk::succ(CString* p) const
{
  return ((p+1) <  &(data[low - base]) || (p+1) >= &(data[fence - base])) ? 
    0 : (p+1);
}

inline CString* CStringIChunk::pred(CString* p) const
{
  return ((p-1) <  &(data[low - base]) || (p-1) >= &(data[fence - base])) ? 
    0 : (p-1);
}


// generic Plex operations

inline CStringPlex::CStringPlex() { lo=0; fnc = 0; }

inline int CStringPlex::chunk_size() const
{
  return csize;
}

inline  int CStringPlex::ecnef () const
{
  return lo - 1;
}


inline  int CStringPlex::fence () const
{
  return fnc;
}

inline int CStringPlex::length () const
{
  return fnc - lo;
}

inline  int CStringPlex::empty () const
{
  return fnc == lo;
}

inline CStringIChunk* CStringPlex::tl() const
{
  return hd->prev();
}

inline int CStringPlex::one_chunk() const
{
  return hd == hd->prev();
}

// StringPlex ops

inline void StringPlex::prev(int& idx) const
{
  --idx;
}

inline void StringPlex::next(int& idx) const 
{
  ++idx;
}

inline  int StringPlex::full ()  const
{
  return 0;
}

inline int StringPlex::can_add_high() const
{
  return 1;
}

inline int StringPlex::can_add_low() const
{
  return 1;
}

inline  int StringPlex::valid (int idx) const
{
  return idx >= lo && idx < fnc;
}

inline int StringPlex::low() const
{
  return lo;
}

inline int StringPlex::high() const
{
  return fnc - 1;
}

inline void StringPlex::set_cache(const CStringIChunk* t) const
{
  ((StringPlex*)(this))->ch = (CStringIChunk*)t;
}

inline void StringPlex::cache(int idx) const
{
  if (idx < lo || idx >= fnc) index_error();
  set_cache(chunks[(idx - base) / csize]);
}  

inline  CString& StringPlex::low_element () 
{
  cache(lo); return *(ch->pointer_to(lo));
}

inline  CString& StringPlex::high_element ()
{
  cache(fnc-1); return *(ch->pointer_to(fnc - 1));
}

inline const CString& StringPlex::low_element () const
{
  cache(lo); return *((const CString*)(ch->pointer_to(lo)));
}

inline const CString& StringPlex::high_element () const
{
  cache(fnc-1); return *((const CString*)(ch->pointer_to(fnc - 1)));
}

inline  int StringPlex::Pix_to_index(Pix px) const
{
  CString* p = (CString*)px;
  if (!ch->actual_pointer(p)) cache(p);
  return ch->index_of(p);
}

inline  Pix StringPlex::index_to_Pix(int idx) const
{
  if (!ch->actual_index(idx)) cache(idx);
  return (Pix)(ch->pointer_to(idx));
}

inline Pix StringPlex::first() const
{
  return Pix(hd->CStringIChunk::first_pointer());
}

inline Pix StringPlex::last() const
{
  return Pix(tl()->CStringIChunk::last_pointer());
}

inline void StringPlex::prev(Pix& p) const  
{
  Pix q = Pix(ch->CStringIChunk::pred((CString*)p));
  p = (q == 0)? Pix(dopred((CString*)p)) : q;
}

inline void StringPlex::next(Pix& p) const
{
  Pix q = Pix(ch->CStringIChunk::succ((CString*)p));
  p = (q == 0)? Pix(dosucc((CString*)p)) : q;
}

inline CString& StringPlex:: elem(Pix p)
{
  return *((CString*)p);
}


inline CString& StringPlex:: elem(int idx)
{
  cache(idx); return *(ch->pointer_to(idx));
}

inline const CString& StringPlex:: operator () (Pix p) const
{
  return *((const CString*)p);
}

inline const CString& StringPlex:: operator [] (int idx) const
{
  cache(idx); return *((const CString*)(ch->pointer_to(idx)));
}

inline StringPlex::~StringPlex()
{
  delete[] chunks;
}
*/
#endif
