#ifndef _TObjectSLList_h
#ifdef __GNUG__
#pragma interface
#endif
#define _TObjectSLList_h 1

#include "Globals.h"
#include "TObjects.h"

#ifndef _TObjectSLListNode_h
#define _TObjectSLListNode_h 1

struct TObjectSLListNode
{
  TObjectSLListNode*         tl;
  TObject&                    hd;
                         TObjectSLListNode( TObject& h, TObjectSLListNode* t = 0 );
                         ~TObjectSLListNode() { }
};


inline TObjectSLListNode::TObjectSLListNode( TObject& h, TObjectSLListNode* t )
:tl(t), hd(h) {;}

typedef TObjectSLListNode* TObjectSLListNodePtr;

#endif


class TObjectSLList
{
protected:
  TObjectSLListNode*        last;

public:
                        TObjectSLList();
                        TObjectSLList(const TObjectSLList& a);
                        ~TObjectSLList();

  TObjectSLList&            operator = (const TObjectSLList& a);

  int                   empty();
  int                   length();

  void                  clear();

  Pix                   prepend(TObject& item);
  Pix                   append(TObject& item);

  void                  join(TObjectSLList&);

  Pix                   prepend(TObjectSLListNode*);
  Pix                   append(TObjectSLListNode*);

  TObject&                  operator () (Pix p);
  Pix                   first();
  void                  next(Pix& p);
  int                   owns(Pix p);
  Pix                   ins_after(Pix p, TObject& item);
  void                  del_after(Pix p);

  TObject&                  front();
  TObject&                  rear();
  TObject                   remove_front();
  int                   remove_front(TObject& x);
  void                  del_front();

  void                  error(const char* msg);
  int                   OK();
};

inline TObjectSLList::~TObjectSLList()
{
  clear();
}

inline TObjectSLList::TObjectSLList()
{
  last = 0;
}

inline int TObjectSLList::empty()
{
  return last == 0;
}


inline Pix TObjectSLList::first()
{
  return (last == 0)? 0 : Pix(last->tl);
}

inline void TObjectSLList::next(Pix& p)
{
  p = (p == 0 || p == last)? 0 : Pix(((TObjectSLListNode*)(p))->tl);
}

inline TObject& TObjectSLList::operator () (Pix p)
{
  if (p == 0) error("null Pix");
  return ((TObjectSLListNode*)(p))->hd;
}

inline TObject& TObjectSLList::front()
{
  if (last == 0) error("front: empty list");
  return last->tl->hd;
}

inline TObject& TObjectSLList::rear()
{
  if (last == 0) error("rear: empty list");
  return last->hd;
}

#endif
