#include "TObjects.h"
#include "PixVec.h"
#include "CString.h"
#include "Environ.h"

//----------------------------------------------------------------------------------------
//					       TObject
//----------------------------------------------------------------------------------------

void  TObject::SetObjIndex( EIndexIndex index, unsigned short val ) {
#ifdef DEBUG
  if( val/256 >= 256 ) { gPrintErr("Illegal Index Value in TOrderedObject::SetIndex\n"); return; }
  if( index>1 || index < 0 ) { gPrintErr("Illegal Index in TOrderedObject::SetIndex\n"); return; }
#endif
  byte* info = fInfo+4+2*index;
  Util::enc_2b( &info, val );
}

unsigned short  TObject::GetObjIndex( EIndexIndex index ) const { 
#ifdef DEBUG
  if( index>1 || index < 0 ) { gPrintErr("Illegal Index in TOrderedObject::GetIndex\n"); return 0; }
#endif
  int i0 = 4+2*index;
  return (unsigned short) Util::dec_2b( fInfo+i0 );
}

const char* TObject::class_name() const {
  return "Object";
}
/*
void TObject::print_on(ostream& out) const {
  out << class_name();
}
*/

VObject* TObject::dup() const { 
  gPrintErr("Can't duplicate this Object");
  return 0L;
}

//----------------------------------------------------------------------------------------
//					       TOrderedObject
//----------------------------------------------------------------------------------------

unsigned long TOrderedObject::fCount = 0;  

///////////////////////////////////////////////////////////
// Error Object
///////////////////////////////////////////////////////////

const char* TError_Object::class_name() const

{
  return "Error_Object";
}


word TError_Object::class_id() const

{
  return CLASS_ERROR;
}


Bool TError_Object::ok() const

{
  return FALSE;
}
