//----------------------------------------------------------------------------------------
//      TObjects.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------
  
#ifndef __TObjects__
#define __TObjects__

#include "Utilities.h"
#include "Utility.h"
#include "object.h"
// #include "iostream.h"

#define DEFAULT_INITIAL_CAPACITY 1000
enum EIndexIndex { kO_Index0, kO_Index1 };
enum EInfoIndex { kO_Info0, kO_Info1, kO_Info2, kO_Info3 };
typedef class PixVec PixVec;
typedef class CString CString;

//----------------------------------------------------------------------------------------
//						TObject
//----------------------------------------------------------------------------------------

class TObject : public VObject
{

protected:

  byte fInfo[8];

public:

  TObject() { memset(fInfo,0,8); }
  virtual void Dump(FILE* oFile=0) {;}

  void SetObjIndex( EIndexIndex index, unsigned short val );
  unsigned short GetObjIndex( EIndexIndex index ) const;
  inline void SetObjInfo( EInfoIndex index, byte val ) { fInfo[index] = val; }
  inline byte GetObjInfo( EInfoIndex index ) const { return fInfo[index]; }
  const char* class_name() const;
 // virtual void print_on(ostream& out) const;
//  virtual void read_from(istream&) {}

//  inline byte& GetObjInfo( EInfoIndex index ) { return fInfo[index]; }

  virtual VObject* dup() const;

};

//////////////////////////////////////////////////////////////////////////////
// Error Object
//////////////////////////////////////////////////////////////////////////////

class TError_Object : public TObject
{
public:
  virtual const char* class_name() const;
  virtual word class_id() const;
  virtual Bool ok() const;
};

//////////////////////////////////////////////////////////////////////////////
// inline functions
//////////////////////////////////////////////////////////////////////////////
/*
inline ostream& operator <<(ostream& out, const TObject& obj)
{
  obj.print_on(out);
  return out;
}

// @FIN 
inline istream& operator >>(istream& in, TObject& obj)
{
  obj.read_from(in);
  CHECK(obj.ok(), "Can't read an Object from a stream");
  return in;
}
*/
//----------------------------------------------------------------------------------------
//						TOrderedObject
//----------------------------------------------------------------------------------------

class TOrderedObject : public TObject
{
  friend int TOrderedObjectCMP( const TOrderedObject& a, const TOrderedObject& b );
  friend int TOrderedObjectEQ( const TOrderedObject& a, const TOrderedObject& b );

  static unsigned long fCount;

protected:

  unsigned long fIndex;

public:

  inline TOrderedObject(unsigned long index) : fIndex(index) { ; }
  inline TOrderedObject() { fIndex = fCount++; }
  inline unsigned long Index() const { return fIndex; }
  inline void SetIndex( unsigned long index ) { fIndex=index; }
  virtual void Dump(FILE* oFile=0) {;}
  virtual int operator==( TOrderedObject& obj ) { return fIndex == obj.fIndex; } 

};

inline int TOrderedObjectEQ( const TOrderedObject& a, const TOrderedObject& b ) {
  return ( a.fIndex == b.fIndex );
}
inline int TOrderedObjectCMP( const TOrderedObject& a, const TOrderedObject& b ) {
  if(a.fIndex == b.fIndex) return 0;
  else if (a.fIndex < b.fIndex) return -1;
  else return 1;
}



#endif
