//----------------------------------------------------------------------------------------
// Utilities.cp
// Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//----------------------------------------------------------------------------------------

#include "Utilities.h"
#include "CString.h"
#include "Environ.h"


int Util::is_integer ( const char *target_str) {

  int i=-1,first_num=0;
  char ch;

  while( (ch=target_str[++i]) != '\0' ) { 
    if( isdigit(ch) ) first_num=1;
    if( (ch=='-' || ch=='+') && first_num ) return(0);  
    if( !( isspace(ch) || isdigit(ch) || ch=='-' || ch=='+') ) return(0);  
  }
  return(1);	  	
}

int Util::is_float ( const char *target_str) {

  int i=-1,first_num=0;
  char ch;

  while( (ch=target_str[++i]) != '\0' ) { 
    if( isdigit(ch) ) first_num=1;
    else if( toupper(ch) == 'E' ) {
      if( first_num==0 ) return(0);
      else first_num=0;
    }
    else if( (ch=='-' || ch=='+') && first_num ) return(0);  
    if( !( isspace(ch) || isdigit(ch) || ch=='-' || ch=='+' || ch=='.' || toupper(ch) == 'E') ) return(0);  
  }
  return(1);	  	
}

int Util::read_number ( FILE *infile, float& val) {
  int i=0, first_num=0;
  int test, isFloat=0;
  char sval[50];

  while( ( test = fgetc(infile) ) != EOF ) {
		if( first_num == 0 ) {
			if( (test=='-') || (test=='+') || isdigit(test)	||	(test=='.') ) {
				if( test=='.' ) { isFloat = 1; }
				sval[i++] = test; 
				first_num = 1;
			} 
			else if( !isspace(test) ) { return -1; }
		} else {		
			if( (test=='-') || (test=='+') || isdigit(test)	||	(test=='.') || (toupper(test) == 'E') ) {
				if( test=='.' ) { isFloat = 1; }
				sval[i++] = test; 
			} else {
				if( isspace(test) ) { break; }
				else { return -1; }
			}
		}
  }
  sval[i++] = 0; 
  val = atof(sval);
  return isFloat;	  	
}

int Util::scan_forward ( FILE *infile, const char *tstring, int line_break, char comment_char ) 
{
  int sLen = strlen(tstring);
  int test, cnt=-sLen, incomment = 0;
  static TString s;
  s.alloc(2*(sLen+1)); s = "";
  while( ( test = fgetc(infile) ) != EOF ) {
    if( test == comment_char ) { incomment = 1; }
    if( line_break && test == '\n' ) { return -1; }
    if( incomment && test == '\n' ) { incomment = 0; }
    s += (char)test;
    if( s.contains(tstring) ) { return 1; }
    if( ++cnt == sLen ) { cnt = 0; s.del(0,sLen); }
  }
  return(0);
}

int Util::scan_forward2 ( FILE *infile, const char *tstring1, const char *tstring2, int line_break, char comment_char ) 
{
  int sLen = imax( strlen(tstring1), strlen(tstring2) );
  int test, cnt=-sLen, incomment = 0;
  static TString s;
  s.alloc(2*(sLen+1)); s = "";
  while( ( test = fgetc(infile) ) != EOF ) {
    if( test == comment_char ) { incomment = 1; }
    if( line_break && test == '\n' ) { return -1; }
    if( incomment && test == '\n' ) { incomment = 0; }
    s += (char)test;
    if( s.contains(tstring1) || s.contains(tstring2) ) { return 1; }
    if( ++cnt == sLen ) { cnt = 0; s.del(0,sLen); }
  }
  return(0);
}

int Util::findNextRecord( FILE *infile, const char *record_name ) {
	int test, found = 0; 
	if( ( infile == NULL ) || ( record_name == NULL ) || ( *record_name == '\0' ) ) return 0;
  while( ( test = fgetc(infile) ) != EOF ) {
		if( test == '\n' ) {
			const char* name = record_name;
			while( ( test = fgetc(infile) ) != EOF ) {
				if( *name++ != test ) break;
				if( *name == '\0' ) { found = 1; break; }
			}
			if( found ) return 1;
		}
	}
	return 0;
}

int Util::readNextField( FILE *infile, CString& field ) {
	int test;
	field = ""; 
	if( infile == NULL  ) return 0;
  while( ( test = fgetc(infile) ) != EOF ) {
		if( !isspace(test) ) break;
  }
	while( !isspace(test) && ( test != EOF ) ) {
		field += (char)test;
		test = fgetc(infile);
	}
	return field.length();
}

/********************************************************************/	

void Util::trim( char* name ) {
  int start_pos=0, end_pos, i, slen;
  end_pos = strlen(name);	
  while ( name[start_pos] == ' ') start_pos++;
  while ( name[end_pos-1] == ' ') end_pos--;
  for(i=0; i< (slen = end_pos-start_pos); i++) name[i] = name[i+start_pos];
  name[slen] = '\0';
}


/********************************************************************/

int Util::check_for ( const char *s0, const char *s1, int start, 
		     ESearchCaseType cs, EInsertPos rp, ESearchIsolType iw)
{
  /*  Check for occurrences of string s1 in string s0 	*/
  /*  after position start. Return -1 if not found.  		*/
  /* if cs = CASESENS -> case sensitive, cs = NOCASE, not case sens. 	*/
  /* if rp = BEG -> return position of beginning of s1, 	*/
  /* 			otherwise return position of (next char following the) end of s1 		*/
  /* if iw = ISOL then s1 must be an isolated word.  		*/
  /* if iw = NEWWORD then s1 must be at beginning of word.  	*/
  int i, j=0, k=-1, Len1 = strlen(s1), Len0 = strlen(s0);
  char t1, t2;
  
  while(k<0) {
    k=0;
    for(i=start; i< Len0; ++i) { 
      t1 = s0[i];
      t2 = s1[j];
      if(cs==NOCASE) { t1 = tolower(t1); t2 = tolower(t2); }   
      if (t1 == t2)  j++;
      else {j=0; k=0; if(iw==NEWWORD) break;}
      if(j==Len1) { k=1; break; }
    }
    if(iw==ISOL && k>0 && (isalnumf(s0[i+1]) || ((i>=Len1) && isalnumf(s0[i-Len1]))) ) { k=-1; start = i; }
  }
  if(k<=0) 		return(-1);
  else if(rp==BEG) 	return(i-Len1+1);
  else      		return(i+1);
}	 
/********************************************************************************/
 
int Util::replace (char *s0,  const char *s_old,  const char *s_new, ESearchCaseType cs, ESearchIsolType iw, int MAXLEN)  	
/* Replace all occurrences of s_old in s0 with s_new 		*/
/*  cs = case_sensitive  									*/
/* if iw = ISOL then s_old must be an isolated word.  			*/
/* if iw = NEWWORD then s_old must be at the beginning of the word.*/
{
  int ioff=0, L_new=strlen(s_new), L_old=strlen(s_old), rv=0;
	
  while( (ioff=check_for(s0,s_old,ioff,cs,END,iw)) > 0) {
    remove_str(s0,L_old,ioff);
    insert(s0,s_new,ioff-L_old,MAXLEN);
    ioff = ioff + (L_new-L_old); 
    rv=1;	
  }
  return(rv);
}	


/*****************************************************************************/	
 
void  Util::insert(char *s0, const char *s1, int offset, int LMAX)  
/* Inserts string s1 into s0 with offset */
{
  int i, L0=slen(s0), L1=slen(s1);
  char *temp = new char[L0-offset+1]; 
  if(L0+L1>LMAX) { printf("Error, string too long(%d):%s",LMAX,s0);
  return; }

  for(i=0; i<(L0-offset); ++i)
    temp[i] = s0[i+offset];
  for(i=0; i<L1; ++i)
    s0[offset+i] = s1[i];
  for(i=0; i<(L0-offset); ++i)
    s0[i+L1+offset] = temp[i];
  s0[L0+L1] = '\0';
  delete[] temp;
}
 
/*********************************************************************************/
 
void  Util::insert_num(char *s0, int num, int offset, int LMAX)  
/* Inserts num into s0 with offset */
{
  int i, L0, L1=1;
  char *temp; 

  L0 = strlen(s0);
  temp = new char[L0-offset+1]; 
  if(L0+L1>LMAX) { printf("Error, string too long(%d):%s",LMAX,s0); return; }
  for(i=0; i<=(L0-offset); ++i)
    temp[i] = s0[i+offset];
  if(num<10) s0[offset] = '0'+ num;
  else {
    s0[offset] = '0'+ num/10; 
    s0[offset+1] = '0'+ num%10;
    L1 = 2;
  }     
  for(i=0; i<=(L0-offset); ++i)
    s0[i+L1+offset] = temp[i];
  delete[] temp;
}
/**********************************************************************/

void  Util::remove_str(char *s0, int Lstr, int offset)  
/* Delete string of length Lstr from s0 */ 
/* prior to position offset.                  */
{
  int i, L0 = strlen(s0);
  for(i=offset-Lstr; i<=L0-Lstr; ++i) s0[i] = s0[i+Lstr];
}
 
/*********************************************************************************/ 

char * Util::resize_copy(char *str0, char *str1 )
{
  char *tmp; int slen, s1, s0;

  if(str0 == NULL) {
    slen = strlen(str1)+50;
    tmp = new char[ slen ];
    strcpy(tmp,str1);
    return(tmp);
  }
  else if( (s1=strlen(str1)) >=  (s0=strlen(str0)) ) {
    slen = s1+50;
    tmp = new char[ slen ];
    strcpy(tmp,str1);
    delete[]  str0;
    return(tmp);
  }
  else {
    strcpy(str0,str1);
    return(str0);
  }
}


int Util::CheckErrors(const char* label, const char* error_str, int index ) {
	if( errno  ) {
		sprintf(gMsgStr,"%s (%d) %s: %s\n",label,index,strerror(errno),error_str);  
		gPrintErr();
		errno = 0;
		return 1;
	}
	return 0;
}

/*****************************************************************************/

	
void Util::ncopyup(const char* from, char* to, int n) { 
  if (from != to) {
    while (--n >= 0) { 
      if( (*to++ = toupper(*from++)) == 0 ) break; 
    }
    *to = 0;                                                  // copy n bytes or until null, null-terminate, upcase;
  }
}

void Util::downcase( char* str, int n ) { 
	while ( --n >= 0 ) { 
		if( (*str = tolower(*str)) == 0 ) break;
		str++; 
	}                                               
}









