#ifndef __Utilities__
#define __Utilities__

#include "Globals.h"
#include "errno.h"

typedef class CString CString;

class Util {

public:

  enum EInsertPos { BEG, END };
  enum ESearchIsolType { NOISOL, ISOL, NEWWORD};
  enum ESearchCaseType { NOCASE, CASESENS };

//  const short kNameFieldLength 		=	100;
//  const short kValueFieldLength		=	1500;
//  const short kPathNameLength		=       500;

  static inline unsigned getbits( byte c, int p, int n) {  // Get n bits at position p from c 
								return ( ( c >> (p+1-n) ) & ~(~0 << n) ); 
  }

	static inline int isValid( float testVal ) {    // returns 0 for NaN, INF, and FLT_MAX
		return ( testVal < FLT_MAX ) && ( testVal > -FLT_MAX );
	}

	static inline unsigned long int pow2(int p) { 
		unsigned long int rv = 1;
		for(int i=0; i<p; i++) { rv *= 2; }
		return rv;
	}
	
  static int scan_forward ( FILE *infile, const char *tstring, int line_break=0, char comment_char = '|' );
  static int scan_forward2 ( FILE *infile, const char *tstring1, const char *tstring2, int line_break=0, char comment_char = '|' );
  static int read_number ( FILE *infile, float& val);
  static int is_float ( const char *target_str );
  static int is_integer ( const char *target_str );

  
  inline static void ncopy(const char* from, char* to, int n)  {
    if (from != to) while (--n >= 0) *to++ = *from++;          // copy n bytes;
  }

  inline static void ncopy0(const char* from, char* to, int n) { 
    if (from != to) {
      while (--n >= 0) { *to++ = *from++; }
      *to = 0;                                                  // copy n bytes, null-terminate;
    } else to[n] = 0;
  }
  
  static void ncopyup(const char* from, char* to, int n); 
  static void downcase( char* str, int n ); 

  inline static void scopy(const char* from, char* to) {
      if (from != 0) while((*to++ = *from++) != 0);             // copy until null;
    } 

  inline static void revcopy(const char* from, char* to, short n) {
    if (from != 0) while (--n >= 0) *to-- = *from--;            // copy right-to-left;
  }


  inline static int slen(const char* t) {  
    if (t == 0)return 0;
    else {
      const char* a = t;                                        // inline  strlen;
      while (*a++ != 0);
      return a - 1 - t;
    }
  }

	static inline int imin( int x, int y ) { return (x<y) ? x : y; }
	static inline int imax( int x, int y ) { return (x>y) ? x : y; }
		
  static inline int cmp( char *str0, char *str1, int nchar )  {
    int i;
    for (i=0; i<nchar; i++) {
      if( tolower(str0[i]) != tolower(str1[i])  ) return 0; 
      if( str0[i] == '\0' ) break;
    }
    return 1;	
  }
  
	inline static int scmp(const char* a, const char* b)
	{
		if ( (b == 0) || (a == 0) ) return 1;
		else {
			int diff = 0;
			while ((diff = *a - *b++) == 0 && *a++ != 0);
			return diff;
		}
	}
	
  static inline int skip_white(FILE *infile, char* comment_chars = (char*)NULL) {
    int ch=0, in_comment = 0;  
    while( ch != EOF ) {
      if( comment_chars ) {
	if( ch == comment_chars[0] ) in_comment = 1;
	if( ch == comment_chars[1] ) in_comment = 0;
      }
      if( !isspace(ch=fgetc(infile)) && !in_comment ) break;
    }
    if(ch==EOF) return 0;
    ungetc(ch,infile);
    return 1;		
  } 

  static inline long lclamp( long ival, long imin, unsigned long imax ) {
    unsigned long itmp = ( (ival>imax) ? imax : ival );
    return ( (itmp<imin) ? imin : itmp );
  }

  static inline int iclamp( int ival, int imin, int imax ) {
    unsigned long itmp = ( (ival>imax) ? imax : ival );
    return ( (itmp<imin) ? imin : itmp );
  }

  static inline float fclamp( float fval, float fmin, float fmax ) {
    float ftmp = ( (fval>fmax) ? fmax : fval );
    return ( (ftmp<fmin) ? fmin : ftmp );
  }

  static inline float ramp( float val ) {
    return (val > 0) ? val : 0.0;
  }
 
  static inline int dec_1b(unsigned char **sptr) {
    return ((int) *(*sptr)++);
  }

  static inline int dec_2b(unsigned char **sptr) {
    int			rval;
  
    rval = (*(*sptr)++ << 8);
    rval |= *(*sptr)++;
    return (rval);
  }

  static inline int dec_2b( byte b1, byte b2 ) {
    int rval = (b1 << 8) | b2;  
    return (rval);
  }

  static inline int dec_2b( const byte* b ) {
    int rval = (*b << 8) | *(b+1);  
    return (rval);
  }

  static inline int dec_3b(unsigned char **sptr) {
    int			rval;
  
    rval = (((int) *(*sptr)++) << 16);
    rval |= (((int) *(*sptr)++) << 8);
    rval |= (int) *(*sptr)++;
    return (rval);         
  }

  static inline long dec_4b(unsigned char **sptr) {
    long			rval;
  
    rval = (((long) *(*sptr)++) << 24);
    rval |= (((long) *(*sptr)++) << 16);
    rval |= (((long) *(*sptr)++) << 8);
    rval |= (long) *(*sptr)++;
    return (rval);
  }


  static inline long dec_Nb(unsigned char **sptr, int bytes) {
    long temp;
    switch(bytes) {
    case 1: temp = dec_1b(sptr); break;
    case 2: temp = dec_2b(sptr); break;
    case 3: temp = dec_3b(sptr); break;
    case 4: temp = dec_4b(sptr); break;
    default: temp = -1;
    }
    return temp;					
  }

  static inline void enc_Nb( unsigned char **sptr, unsigned long value, int bytes ) {
    switch(bytes) {
    case 1:
      *(*sptr)++ = value;
      break;
    case 2:
      *(*sptr)++ = (value >> 8);
      *(*sptr)++ = value;
      break;
    case 3:
      *(*sptr)++ = (value >> 16);
      *(*sptr)++ = (value >> 8);
      *(*sptr)++ = value;
      break;
    case 4:
      *(*sptr)++ = (value >> 24);
      *(*sptr)++ = (value >> 16);
      *(*sptr)++ = (value >> 8);
      *(*sptr)++ = value;
      break;
    }
  }

  static inline void enc_2b(unsigned char **sptr,int value) {
    *(*sptr)++ = (value >> 8);
    *(*sptr)++ = value;
  }

  static inline void enc_3b(unsigned char **sptr,int value) {
    *(*sptr)++ = (value >> 16);
    *(*sptr)++ = (value >> 8);
    *(*sptr)++ = value;
  }

  static inline void enc_4b(unsigned char **sptr,long value) {
    *(*sptr)++ = (value >> 24);
    *(*sptr)++ = (value >> 16);
    *(*sptr)++ = (value >> 8);
    *(*sptr)++ = value;
  }

// Utilities origonally written for MC

  static void trim( char* name );
  static inline long int ceil(float v) { long int i = (int)v; return ( (v-i)>0 ) ? i+1 : i; }
  static inline int isalnumf(char c) {
    if( isalnum(c) || c=='.' || c=='_' || c=='@') return(1);
    else return(0);
  }
  
  static inline int isEnum(char c) {
    if( isdigit(c) || c=='.' || c=='-' || c=='+' || tolower(c)=='e') return(1);
    else return(0);
  }
  static inline int isFnum(char c) {
    if( isdigit(c) || c=='.' || c=='-'  || c=='+' ) return(1);
    else return(0);
  }
  
  static int check_for ( const char *s0, const char *s1, int start, ESearchCaseType cs, EInsertPos rp, ESearchIsolType iw);
  static int replace (char *s0, const char *s_old, const char *s_new, ESearchCaseType cs, ESearchIsolType iw, int MAXLEN);

  static void insert(char *s0, const char *s1, int offset, int LMAX);

  static void insert_num(char *s0, int num, int offset, int LMAX);

  static void remove_str(char *s0, int Lstr, int offset);

  static char *resize_copy(char *str0, char *str1 );

  static inline void replace_prefix(char *s0, int old_prefix_len, char* new_prefix, int MAXLEN) {
    remove_str(s0, old_prefix_len, 0);
    insert(s0, new_prefix, 0, MAXLEN);
  }
  static int CheckErrors(const char* label, const char* error_str, int index=0);
  
  static int findNextRecord( FILE *infile, const char *record_name );
  static int readNextField( FILE *infile, CString& field );
};

#endif

  
