#ifndef __UTILITY_H
#define __UTILITY_H

#include "stdtypes.h"

#ifdef __cplusplus
extern "C" {
#endif
  /* @FPUB */
  int message_box(const char* fmt, ...);
  int warning_box(const char* fmt, ...);
  int sorry_box(const char* fmt, ...);
  int error_box(const char* fmt, ...);
  int fatal_box(const char* fmt, ...);
  int yesno_box(const char* fmt, ...);
  int yesnocancel_box(const char* fmt, ...);
  int yesnofatal_box(const char* fmt, ...);

  /* @END  */
#ifdef __cplusplus
}
#endif


/* @M 
   Utilizzate in fase di debug (definire il simbolo DBG in compilazione)
   */
#ifdef DBG
#define CHECK(p, m) ( (p) ? (void)0 : (void) fatal_box(          \
						       "Check failed in %s, line %d:\n\r%s",      \
						       __FILE__, __LINE__, m) )

#define CHECKS(p, m, s0) ( (p) ? (void)0 : (void) fatal_box(      \
							    "Check failed in %s, line %d:\n\r%s%s", \
							    __FILE__, __LINE__, m, s0) )

#define CHECKD(p, m, d0) ( (p) ? (void)0 : (void) fatal_box(      \
							    "Check failed in %s, line %d:\n\r%s%d", \
							    __FILE__, __LINE__, m, d0) )
#else

#define CHECK(p, m)
#define CHECKS(p, m, s)
#define CHECKD(p, m, d)

#endif
/* @END */


/* @M
   Utilizzata in fase di debug (definire il simbolo TRC in compilazione)
   */
#ifdef TRC
#define TRACE(m) warning_box(m)
#else
#define TRACE(m) ((void) 0)
#endif
/* @END */

char* format (const char* fmt, ...);
const char* cmd2name(const char* argv0, const char* argv1 = "");
int rtoi(const char * roman);
const char* itor(int i);
bool fcopy(const char* orig, const char* dest);
bool fexist(const char* file);
const char * encode(const char * data);
const char * decode(const char * data);
int which(const char *file, char *fullpath);
int  stricmp(const char*, const char*);
int fremove(const char* file);

const char* esc(const char*);
const char* gensym(void);

#define ODD(x)   (x & 1)
#define EVEN(x) !(x & 1) 

#ifdef __UTILITY_CPP
char __tmp_string[1024];
#else
extern char __tmp_string[1024];
#endif

#endif // __UTILITY_H










