#include "assoc.h"
#include "Environ.h"
#include "Utility.h"

TError_Object error;

THash_object* TAssoc_array::_lookup(const char* k, Bool& isnew, Bool insert)
{
  const CString key(k);
  const word hv = key.hash() % HASH_SIZE;
  TArray& arr = _data[hv];
  THash_object* o = NULL;
  isnew = FALSE;
  int i;
  for (i = 0; i < arr.items(); i++)
  {
    THash_object* ob = (THash_object*)(&(arr[i]));
    if (ob->_key == key)
    { o = ob; break; }
    if (ob->_key > key)
      break;
  }

  if (o == NULL && insert) 
  { 
    o = new THash_object(key);
    arr.insert(o,i); 
    isnew = TRUE;
    _cnt++;
  }
  
  return o;
}

THash_object::THash_object(const char* k)
{ 
  _key = k; 
}

THash_object::~THash_object() 
{ 
  if (_obj != NULL) 
    delete _obj; 
}


void TAssoc_array::destroy()
{
  for (int i = 0; i < HASH_SIZE; i++)
    _data[i].destroy();
  _cnt = _row = _col = 0;
}

Bool TAssoc_array::add(const char* key, TObject* obj,
                       Bool force)
{
  Bool isnew = FALSE;

  THash_object* o = _lookup(key,isnew,TRUE);

  if (!isnew)
  {
    if (force) { 
      if (o->_obj != NULL) 
	delete o->_obj;
      o->_obj = obj; 
    }
    return TRUE;
  }
  o->_obj = obj;
  return FALSE;
}

Bool TAssoc_array::add(const char* key, const TObject& obj, Bool force)
{
  return  add(key, (TObject*) obj.dup(), force);
}

Bool TAssoc_array::remove(const char* k)
{
  const CString key(k);
  const word hv = key.hash() % HASH_SIZE;
  TArray& arr = _data[hv];
  THash_object* o = NULL;
  int i;
  for (i = 0; i < arr.items(); i++)
  {
    THash_object* ob = (THash_object*)(&(arr[i]));
    if (ob->_key == key)
    { o = ob; break; }
    if (ob->_key > key)
      break;
  }
  if (o != NULL) 
  { arr.destroy(i,TRUE); _cnt--; return TRUE; }
  return FALSE;
}

TObject& TAssoc_array::find(const char* key)
{
  Bool isnew = FALSE;
  THash_object* o = _lookup(key, isnew);
  if (o == NULL) {
	gPrintErr( format("Can't find key %s in Assoc Array", key) );
	return error;
  }
  if (o->_obj == NULL) return error;
  else return *(o->_obj);
}

TObject* TAssoc_array::objptr(const char* key)
{
  Bool isnew; 
  THash_object* o = NULL;
  if ((o = _lookup(key,isnew)) != NULL)
    return &(o->obj());
  return NULL;
}

Bool TAssoc_array::is_key(const char* key)
{
  Bool isnew = FALSE;
  const THash_object* o = _lookup(key, isnew);
  if (o == NULL) return FALSE;
  return TRUE;
}

TObject* TAssoc_array::get()
{
  const TArray* arr = &_data[_row];
  
  for(;_row < HASH_SIZE;)
  {
    if ((int)_col < arr->items()) 
      break;
    arr = &_data[++_row];
    _col = 0;
  }
  if (_row == HASH_SIZE)
  { _row = 0; return NULL; }
  
  THash_object* o = (THash_object*)arr->objptr(_col++);
  return (o == NULL || o->_obj == NULL) ? &error : o->_obj;
}

THash_object* TAssoc_array::get_hashobj()
{
  const TArray* arr = &_data[_row];
  
  for(;_row < HASH_SIZE;)
  {
    if ((int)_col < arr->items()) 
      break;
    arr = &_data[++_row];
    _col = 0;
  }
  if (_row == HASH_SIZE)
  { _row = 0; return NULL; }
  
  return (THash_object*)arr->objptr(_col++);
}

