#if __GNUG__ >= 2
#  pragma implementation
#endif

#ifdef JAVA

#include "controlsocket.h"
#include "Globals.h"
#include "Environ.h"
#include <string.h>
#include <ctype.h>
#include <errno.h>

extern "C" {
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <unistd.h>
#include <arpa/inet.h>
}


FILE* JavaSocketReader::inStream = NULL;  
FILE* JavaSocketReader::outStream = NULL;
char JavaSocketReader::_host[256];
int JavaSocketReader::_port = -1; 
int JavaSocketReader::_debug = 0; 
int JavaSocketReader::_initialized = 0; 
int JavaSocketReader::_startup_control_panel = 0;
int JavaSocketReader::_socket = -1;
int JavaSocketReader::_stream_socket = -1;
int JavaSocketReader::_rank = 0;

#ifdef USE_MPI
MPI_Comm JavaSocketReader::fComm = 0;
#endif

inline int is_integer ( const char *target_str) {
  int i=-1,first_num=0;
  char ch;

  while( (ch=target_str[++i]) != '\0' ) { 
    if( isdigit(ch) ) first_num=1;
    if( (ch=='-' || ch=='+') && first_num ) return(0);  
    if( !( isspace(ch) || isdigit(ch) || ch=='-' || ch=='+') ) return(0);  
  }
  return(1);	  	
}

inline static int datalen( const char* t, int bufflen ) {  // includes termination char
  if (t == 0) { return 0; }
  else {
    const char* a = t;
    while (*a++ != 0) { 
	  if( (a - t) >=  bufflen ) { 
		return bufflen; 
	  }
	}
    return a - t;
  }
}


void JavaSocketReader::startupControlSocket() {
	char java_cmd[2048];
	if( _initialized == 0 ) {
		fprintf(stderr,"JavaSocketReader not initialized");
		return;
	}

	if( _startup_control_panel ) {
		const char* shell = Env::UsePython() ? "-python" : "";
		if( _debug == 1) {	
//			sprintf(java_cmd,"%s/startup_client -d -p %d", BIN_DIR, _port );
			sprintf(java_cmd,"xterm -sb -sl 512 -e startup_client %s -p %d -m %s -scen %s -d 1 xxx &",  
												   shell, _port, Env::ModelName().chars(), Env::ScenarioName().chars()  );
		} else {
//			sprintf(java_cmd,"%s/startup_client -p %d", BIN_DIR, _port );
			sprintf(java_cmd,"startup_client %s -p %d -m %s -scen %s xxx &",  
												   shell, _port, Env::ModelName().chars(), Env::ScenarioName().chars()  );
		}
	  fprintf(stderr,"info: Executing java command( debug = %d ): %s\n", _debug, java_cmd); 
	  system(java_cmd);    // fire up java controller.
	}
}

int JavaSocketReader::init( int argc, char *argv[] ) {
	char* host = NULL;
	int debug = 0, port = -1;
	
	for(int i=0; i<argc; i++) {

	  if( strcmp(argv[i],"-CSdebug") == 0 ) {
		if( (i+1) < argc && is_integer(argv[i+1]) )  { 
		  debug=atoi(argv[i+1]); 
		} 
	  } else  if( strcmp(argv[i],"-java") == 0 ) {
		  if( (i+1) < argc ) {
			if ( strcmp(argv[i+1],"local") == 0 )  { 
				_startup_control_panel = 1;
				printf("\nstartup control_panel on localhost\n");
			} else {
				host = argv[++i]; 
				if( host ) { printf("\nSetting host to %s\n",host); }
			}
		  } 
	  } else if ( strcmp(argv[i],"-CShost") == 0 ) {
		if ((i+1) < argc) { 
		  host = argv[++i]; 
		  if( host ) { printf("\nSetting host to %s\n",host); }
		}
	  }
	  else  if( strcmp(argv[i],"-CSport") == 0 ) {
		if( (i+1) < argc && is_integer(argv[i+1]) )  { 
		  port=atoi(argv[i+1]); 
		   printf("\nSetting port to ",port);
		} else {  printf("Incorrect CS argument: ", argv[i+1] ); } 
	  } 
	  else if( argv[i] == "-CShelp" ) {
		printf("JST control command line Arguments:");
		printf(" -CSdebug <debug>    Set control debug level: (default 0)");
		printf(" -CShost <host>      Set control host ( default: localhost )");
		printf(" -CSport <port>      Set control port ( default: localhost )");
		printf(" -java <host>        Startup java control panel on host ( <host>=local: localhost )");
		exit(0);
	  }  
	}
	
	return  initializeSocket( host, port, debug );
}


void	JavaSocketReader::openStreams(int s) {
  // called by fork()'ed proc to ask parent for data
  // use buffered I/O on socket for convenience
  _stream_socket = s;
  fprintf(stderr,"\nAccepted socket connection, opening streams" ); 
  inStream  = fdopen(_stream_socket,"r");
  outStream = fdopen(_stream_socket,"w");
  if( (inStream==NULL) || (outStream==NULL) ) { 
	  fatal("Can't open Java streams"); 
  }
  fprintf(stderr,"\nOpened streams" ); 
	sendTelnetMessage( 200, "Opened streams" ); 
}

void	JavaSocketReader::sendTelnetMessage( int code, const char* message ) {
	if( _socket == -1 ) return;
	char scode[16];
	sprintf(scode,"%d",code);
	fputs(scode,outStream);  
	fputc(' ',outStream); 
	fputs(message,outStream); 
	fputc('\r',outStream); 
	fputc('\n',outStream);   
	fflush(outStream);
//	sprintf(gMsgStr,"\nSent Telnet message: (%s) %s", scode, message ); gPrintLog();
}

void	JavaSocketReader::closeConnection() {
   if( inStream != NULL ) { fclose(inStream); inStream = NULL; }
   if( outStream != NULL ) { fclose(outStream); outStream = NULL; }
   if( _stream_socket != -1 ) { close(_stream_socket); _stream_socket = -1; }
}

int JavaSocketReader::connect1() {
  if( gIProc != 0 ) return 0;  
  startupControlSocket();
  // create and bind a TCP/INET socket
  // peer (interface) registers localhost, localport for connecting
//  exit(1);
  fprintf(stderr,"\nListening for socket connection ( port = %d, host = %s ) ", _port, _host ); 
  if( listen_for_connection() ) {
	for (;;) {                                  // block until connection is make from java terminal
	  struct sockaddr_in sin;
	  int s, len = sizeof(struct sockaddr_in);
	  fprintf(stderr,"\nAccepting socket connections ( port = %d, host = %s ) ", _port, _host ); 
	  if ( ( s = accept( _socket, (sockaddr*)&sin, (socklen_t*) &len)) >= 0 )   {
		  closeConnection();
		  openStreams(s);
		  return 1;
	  } else {
	  	perror("\nError accepting socket connection ");  fflush(stderr);
	  	break;
	  }
    } 
  }
  return 0;
}

int JavaSocketReader::listen_for_connection() {
  if( listen( _socket, 4 ) < 0 ) {  perror("\nsocket error ");  fflush(stderr);  return 0; }
  return 1;
}

const char*	JavaSocketReader::processMessages(char* buf, int useSocket, void* interp, ExecuteCommandFn ecf ) {
  int msg_size, cmd_code;
  const char* rStr;
  int debug = 1;
#ifdef USE_MPI 
  if( fComm == 0 ) {
	int flag, err;
	err = MPI_Initialized(&flag);
	if( flag == 0 ) { printf("error: MPI Not Initialized! error= %d\n",err); }
	else { MPI_Comm_dup(MPI_COMM_WORLD,&fComm); }
  }
  MPI_Comm_rank(fComm,&_rank);
#endif
  if( useSocket == 0 ) {
		int repeat = 1;  
#ifdef USE_MPI 
		int size = datalen(buf,256);
		MPI_Bcast( &size, 1, MPI_INT, 0, MPI_COMM_WORLD );
		MPI_Bcast( buf, size, MPI_CHAR, 0, MPI_COMM_WORLD );
#endif
		while(repeat>0) {
			rStr = (*ecf) ( buf, &cmd_code, &repeat, interp  );
			if( rStr && (_rank == 0) ) { 
				sendTelnetMessage( cmd_code, rStr ); 
			}
		}
  } else {
		while (1)  {
			if( _rank == 0 ) { 
			   char* rs = fgets(buf, 256, inStream); 
			   msg_size = ( rs == NULL ) ? 0 : datalen(buf,256);
			}
#ifdef USE_MPI 
			MPI_Bcast( &msg_size, 1, MPI_INT, 0, fComm );
#endif
			if( msg_size > 0 ) {
#ifdef USE_MPI 
			  MPI_Bcast( buf, msg_size, MPI_CHAR, 0, fComm );
#endif
			  int repeat = 1;  
			  if( debug) { sprintf(gMsgStr,"dbg: got msg: %s",buf); gPrintLog(); }
			  while(repeat>0) {
				  rStr = (*ecf) ( buf, &cmd_code, &repeat, interp );
				  if( rStr && (_rank == 0) ) { 
					  if( debug) { sprintf(gMsgStr,"dbg: send msg: %s",rStr);  gPrintLog(); }
					  sendTelnetMessage( cmd_code, rStr ); 
				  } 
			  }
			} else break;
		}
		if( ferror(inStream) ) { return NULL; }
	}
	return rStr;
}

int JavaSocketReader::initializeSocket(const char* host, int port, int debug ) {
  _debug = debug;
  if( port > 0 ) _port = port;	
  if( host ) { sprintf(_host,host); }
  else { sprintf(_host,"localhost"); }
  _initialized = 1;
  
  printf("\nJava debug level set to %d, using client %s:%d\n",_debug,_host,_port);
  return create_socket();
  	
}
/*
int JavaSocketReader::create_socket1() {
  struct sockaddr_in sin;
  
  if (_socket == -1) {
    _port = 0;
    _socket = socket(AF_INET, SOCK_STREAM, 0);  
    memset((char*)&sin, '\0', sizeof(sin));
    
    if ((sin.sin_addr.s_addr = inet_addr((char*)_host)) == -1)  {
      hostent* hp = gethostbyname(_host);
      if (hp != NULL)  {
		memcpy(&(sin.sin_addr), hp->h_addr, hp->h_length);
		sin.sin_family = hp->h_addrtype;
	  }
    }
    else sin.sin_family = AF_INET;  
    
    if (bind(_socket, (sockaddr*)&sin, sizeof(sin)) >= 0) {
      struct sockaddr_in ls;
      int l = sizeof(struct sockaddr_in);
      if (getsockname(_socket, (sockaddr*)&ls, &l) != -1) 	{
		_port = ntohs(ls.sin_port);
		gethostname(_host, 255 );
      }
    }
  }
  return _socket;  
}
*/
int JavaSocketReader::create_socket() {
  struct sockaddr_in sin;
  
  if (_socket == -1) {
    _socket = socket(AF_INET, SOCK_STREAM, 0);  
    // tbi set options
    // set sockaddr for bind()
    memset((char*)&sin, '\0', sizeof(sin));
    
	sin.sin_family = AF_INET;  
	sin.sin_addr.s_addr = htonl(INADDR_ANY);  
	if( _port > 0 ) { 
	  sin.sin_port = htons(_port);  
	}    
    
    if (bind(_socket, (sockaddr*)&sin, sizeof(sin)) >= 0) {
      struct sockaddr_in ls;
      int l = sizeof(struct sockaddr_in);
      if (getsockname(_socket, (sockaddr*)&ls, (socklen_t*) &l) != -1) 	{
		// set local host 
		_port = ntohs(ls.sin_port);
		gethostname(_host, 255 );
      }
    }
  }
  return _socket;  
}


#endif

