#ifndef __DataSocket__
#define __DataSocket__

#ifdef JAVA

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <jni.h>
// #include <byteorder.h>
#include <math.h>
#include <string.h>

#ifdef USE_MPI
#include <mpi.h>
#endif

#ifndef byte
typedef unsigned char byte; 
#endif

class DataSocket {

	char _host[512];
	int _port;
	int _socket_desc;
	int _connected;
	int _bufferPtr;
	int _procnum;
	jbyte* _buffer;
	int _buffer_size;
	jbyte _byteFormat ;   //  0: little-endian,  1: big-endian, 2: network-format (java datastream compatible), 3:undetermined
	static FILE* _logStream;
	

	inline void load_buffer( const void* data, int size ) {
		resize_buffer( size );
		memcpy(_buffer+_bufferPtr, data, size);
		_bufferPtr += size;  
	}
	
	inline int  resize_buffer( int size_increase ) {
		int rv = 0;
		while( _bufferPtr + size_increase > _buffer_size ) {
			_buffer_size = ( _buffer_size > 0 ) ? _buffer_size*2 : 1000;
			rv = 1;
		}
		if( rv ) {
			jbyte* new_buffer = new jbyte[_buffer_size];
			if( _buffer ) {
				memcpy(new_buffer, _buffer, _bufferPtr);
				delete[] _buffer;
			}
			_buffer = new_buffer; 
		}
		return rv;
	}

	public:
	
	DataSocket( char* host, int port );
	int connect1 () ;
	void disconnect(  );
	int setupDataFormats();
	
	inline void DataSocket::writeInts( const jint* ji, int ndata, int buffer ) {
		if(buffer) {
			load_buffer(ji,ndata*4);
		} else { 
			write( _socket_desc, ji, ndata*4 );
		}
	}
	inline void DataSocket::writeShorts( const jshort* js, int ndata, int buffer ) {
		if(buffer) {
			load_buffer(js,ndata*2);
		} else { 
			write( _socket_desc, js, ndata*2 );
		}
	}
	
	inline void DataSocket::writeBytes( const jbyte* jb, int ndata, int buffer ) {
		if(buffer) {
			load_buffer(jb,ndata);
		} else { 
			write( _socket_desc, jb, ndata );
		}
	}
		
	inline void DataSocket::writeFloats( const jfloat* jf, int ndata, int buffer ) {
		if( _byteFormat == 2 ) {
			if(buffer) {
				load_buffer(jf,ndata*4);
			} else { 
				write( _socket_desc, jf, ndata*4 );
			}
		} else {
			jshort s[2];  
			float f0;
			const float *jfp = jf; 
			int exp0, cnt=0;
			while( cnt++ < ndata ) {
				f0 = frexp(*jfp++,&exp0);
				s[0] = (short) ldexp(f0,15);
				s[1] = (short) (exp0 - 15);
				writeShorts( s, 2, buffer );
			} 
		}
	}
			
	
	inline void DataSocket::flush() {
			write( _socket_desc, _buffer, _bufferPtr );
			_bufferPtr = 0;
	}	
	
	inline void DataSocket::readBytes( jbyte* jb, int ndata ) {
		read( _socket_desc, jb, ndata );
	}
		
	inline jbyte getByteOrdering() {
		jint test = 1;
		byte* btest = (byte*)(&test);
		if( btest[3] == 1 ) {  return 1; }
		else if( btest[0] == 1 ) { return 0; }
		else { fprintf( stderr, " Unrecognized integer format! " ); return 1; }
	}
	
	inline jbyte byteFormat() { return _byteFormat; }
	
	static inline int myID()  { 
#ifdef USE_MPI
	  int ID; MPI_Comm_rank(MPI_COMM_WORLD,&ID); return ID;
#else
	  return 0;
#endif
	}

	static inline int nProcs() { 
#ifdef USE_MPI
		int size; MPI_Comm_size(MPI_COMM_WORLD,&size); return size;
#else
		return 1;
#endif
	}
	
	inline int procnum() { return _procnum; }
	
	static inline void  print(char* msg) { 
	  if(  myID() == 0 ) { 
		printf("info: DataSocket: %s",msg); 
		if( _logStream ) {
		  fprintf(_logStream,"info: DataSocket: %s",msg); 
		}
	  } 
	}
	
	static inline void  print3(char* msg, char* msg1 = NULL, char* msg2 = NULL, char* msg3 = NULL ) { 
	  if( myID() == 0 ) { 
		printf("\ninfo: JST.DataSocket: %s",msg); 
		if( msg1 ) { printf(" %s ",msg1); } 
		if( msg2 ) { printf(" %s ",msg2); } 
		if( msg3 ) { printf(" %s ",msg3); } 
		if( _logStream ) {
		  fprintf(_logStream,"\ninfo: JST.DataSocket: %s",msg); 
		  if( msg1 ) { fprintf(_logStream," %s ",msg1); } 
		  if( msg2 ) { fprintf(_logStream," %s ",msg2); } 
		  if( msg3 ) { fprintf(_logStream," %s ",msg3); } 
		  fflush(_logStream);
		}
	  } 
	}

	static inline void  print2(char* msg, int data ) { 
	  if( myID() == 0 ) { 
		printf("\ninfo: JST.DataSocket: %s",msg); 
		printf(" %d \n",data);
		if( _logStream ) {
		  fprintf(_logStream,"\ninfo: JST.DataSocket: %s",msg); 
		  fprintf(_logStream," %d \n",data); 
		  fflush(_logStream);
		}
	  } 
	}
	
	static inline void setLogStream( FILE* f ) {  _logStream = f;  }  

};

#endif
#endif
