// #include <builtin.h>
#include "floatVec.h"
#include "Environ.h"

float floatVec::fErrorVal = kfloatVecError;

void  floatVec::TextDump(FILE* oFile) const { 
  fprintf(oFile,"\nFloatVec: Length = %d, Data:\n",fLength);
  for( int i=0; i<fLength; i++ ) fprintf(oFile, " %f ",fValue[i]);
}

void floatVec::error(const char* msg) const  
{
   gFatal(msg);
}

void floatVec::range_error( int index ) const
{
	sprintf(gMsgStr,"Index out of range: %d, len: %d",index,fLength);
  gPrintErr();
}

floatVec::floatVec(const floatVec& v)
{
  fValue = new float [fLength = v.fLength];
  float* top = &(fValue[fLength]);
  float* t = fValue;
  const float* u = v.fValue;
  while (t < top) *t++ = *u++; 
  fOrigin = NULL;
  fSize = v.fSize;
  fFill = v.fFill;
}

floatVec::floatVec(int l, float  fill_value)
{
  fValue = new float [fSize = fLength = l];
  float* top = &(fValue[fLength]);
  float* t = fValue;
  while (t < top) *t++ = fill_value;
  fOrigin = NULL;
  fFill = fill_value;
}

float& floatVec::add(int n){
	if ((unsigned)n >= (unsigned)fLength) resize(n+100);
	if(n+1>fSize) fSize = n+1;  return fValue[n]; 	
}

void floatVec::add(int n, CString& s){
	if ((unsigned)n >= (unsigned)fLength) resize(n+100);
	if(n+1>fSize) fSize = n+1;  	fValue[n] = atof(s.chars()); 	
}

int floatVec::add(CString& s){
	if ((unsigned)fSize >= (unsigned)fLength) resize(fSize+100);                   
	fValue[fSize++] = atof(s.chars()); return fSize; 	
}

int floatVec::add( float f ){
	if ((unsigned)fSize >= (unsigned)fLength) resize(fSize+100);                   
	fValue[fSize++] = f; return fSize; 
}

floatVec& floatVec::operator = (const floatVec& v)
{
  if (this != &v)
  {
    if(fValue) { delete [] fValue; }
    fValue = new float [fLength = v.fLength];
    fSize = v.fSize;
    float* top = &(fValue[fSize]);
    float* t = fValue;
    const float* u = v.fValue;
    while (t < top) *t++ = *u++;
  }
  return *this;
}

void floatVec::apply(floatProcedure f)
{
  float* top = &(fValue[fLength]);
  float* t = fValue;
  while (t < top) (*f)(*t++);
}

void floatVec::resize(int newl) { resize(newl,fFill); }

// can't just realloc since there may be need for constructors/destructors
void floatVec::resize(int newl, float fill) {
	fFill = fill;
	if( newl > fLength ) {
		float* news = new float [newl];
		int minl = 0;
		float *top, *t = fValue, *p = news;
		if(fValue) { 
			minl = (fLength < newl)? fLength : newl;
			top = &(fValue[minl]);
			while (t < top) *p++ = *t++;
			delete [] fValue;
		}
		top = &(news[newl]);
		while (p < top) *p++ = fFill;
		fValue = news;
		fLength = newl;
	} else {
		float *top = &(fValue[newl]), *p = fValue;
		while (p < top) *p++ = fFill;
	}
}


floatVec concat(floatVec & a, floatVec & b)
{
  int newl = a.fLength + b.fLength;
  float* news = new float [newl];
  float* p = news;
  float* top = &(a.fValue[a.fLength]);
  float* t = a.fValue;
  while (t < top) *p++ = *t++;
  top = &(b.fValue[b.fLength]);
  t = b.fValue;
  while (t < top) *p++ = *t++;
  return floatVec(newl, news);
}


floatVec combine(floatCombiner f, floatVec& a, floatVec& b)
{
  int newl = (a.fLength < b.fLength)? a.fLength : b.fLength;
  float* news = new float [newl];
  float* p = news;
  float* top = &(a.fValue[newl]);
  float* t = a.fValue;
  float* u = b.fValue;
  while (t < top) *p++ = (*f)(*t++, *u++);
  return floatVec(newl, news);
}

float floatVec::reduce(floatCombiner f, float  base)
{
  float r = base;
  float* top = &(fValue[fLength]);
  float* t = fValue;
  while (t < top) r = (*f)(r, *t++);
  return r;
}

floatVec reverse(floatVec& a)
{
  float* news = new float [a.fLength];
  if (a.fLength != 0)
  {
    float* lo = news;
    float* hi = &(news[a.fLength - 1]);
    while (lo < hi)
    {
      float tmp = *lo;
      *lo++ = *hi;
      *hi-- = tmp;
    }
  }
  return floatVec(a.fLength, news);
}

void floatVec::reverse()
{
  if (fLength != 0)
  {
    float* lo = fValue;
    float* hi = &(fValue[fLength - 1]);
    while (lo < hi)
    {
      float tmp = *lo;
      *lo++ = *hi;
      *hi-- = tmp;
    }
  }
}

int floatVec::index(float  targ)
{
  for (int i = 0; i < fLength; ++i) if ( targ == fValue[i] ) return i;
  return -1;
}

floatVec map(floatMapper f, floatVec& a)
{
  float* news = new float [a.fLength];
  float* p = news;
  float* top = &(a.fValue[a.fLength]);
  float* t = a.fValue;
  while(t < top) *p++ = (*f)(*t++);
  return floatVec(a.fLength, news);
}

int operator == (floatVec& a, floatVec& b)
{
  if (a.fLength != b.fLength)
    return 0;
  float* top = &(a.fValue[a.fLength]);
  float* t = a.fValue;
  float* u = b.fValue;
  while (t < top) if ( !(*t++ == *u++) ) return 0;
  return 1;
}

void floatVec::fill(float  val, int from, int n)
{
  int to;
  if( fLength == 0 ) return;
  if (n < 0)
    to = fLength - 1;
  else
    to = from + n - 1;
  if ((unsigned)from > (unsigned)to)
    range_error(from);
  float* t = &(fValue[from]);
  float* top = &(fValue[to]);
  while (t <= top) *t++ = val;
}

void floatVec::CopyToString(CString& s, int from, int n)
{
  int to;
  if (n < 0)
    to = fSize - 1;
  else
    to = from + n - 1;
  if ((unsigned)from > (unsigned)to)
    range_error(from);
  float* t = &(fValue[from]);
  float* top = &(fValue[to]);
  while (t < top) { s+= *t++; s+= ", "; }
  s+= *t++;
}

int floatVec::CopyFromString(CString& s, char sep, int from)
{
	int ci0 = 0, ci1 = 0, i=from;
	clear();
	while ( (ci1 = s.index(sep, ci0)) >= 0 ) { 
		TString s1(s.at(ci0, ci1-ci0)); 
		s1.gsub("\""," ");
		add(i++) = atof(s1.chars());
		ci0 = ci1+1;
	}
	ci1 = s.length();
	TString s2(s.at(ci0, ci1-ci0)); 
	s2.gsub("\""," ");
	add(i++) = atof(s2.chars());
	return i;
}


floatVec floatVec::at(int from, int n)
{
  int to;
  if (n < 0)
  {
    n = fLength - from;
    to = fLength - 1;
  }
  else
    to = from + n - 1;
  if ((unsigned)from > (unsigned)to)
    range_error(from);
  float* news = new float [n];
  float* p = news;
  float* t = &(fValue[from]);
  float* top = &(fValue[to]);
  while (t <= top) *p++ = *t++;
  return floatVec(n, news);
}

floatVec merge(floatVec & a, floatVec & b, floatComparator f)
{
  int newl = a.fLength + b.fLength;
  float* news = new float [newl];
  float* p = news;
  float* topa = &(a.fValue[a.fLength]);
  float* as = a.fValue;
  float* topb = &(b.fValue[b.fLength]);
  float* bs = b.fValue;

  for (;;)
  {
    if (as >= topa)
    {
      while (bs < topb) *p++ = *bs++;
      break;
    }
    else if (bs >= topb)
    {
      while (as < topa) *p++ = *as++;
      break;
    }
    else if ((*f)(*as, *bs) <= 0)
      *p++ = *as++;
    else
      *p++ = *bs++;
  }
  return floatVec(newl, news);
}

