#ifndef _floatVec_h
#define _floatVec_h 1

// #include <builtin.h>
#include "CString.h"
#include <float.h>

static const float kfloatVecError = FLT_MAX;

#ifndef _float_typedefs
#define _float_typedefs 1
typedef void (*floatProcedure)(float );
typedef float  (*floatMapper)(float );
typedef float  (*floatCombiner)(float , float );
typedef int  (*floatPredicate)(float );
typedef int  (*floatComparator)(float , float );
#endif


class floatVec 
{
protected:      
  int                   fLength;
  int                   fSize;
  float                 *fValue;
  float                  fFill;
  floatVec*             fOrigin;
	static float 					fErrorVal; 
	
                        floatVec(int l, float* d);
public:
                        floatVec ();
                        floatVec (int l);
                        floatVec (int l, float  fill_value);
                        floatVec (const floatVec&);
                        ~floatVec ();
  void                  alloc(int len);
 inline void            realloc(int len);
  inline void            shallow_copy(floatVec& v);
	inline  void           deep_copy(const float* f, int len ) { realloc(len); memcpy(fValue,f,len*sizeof(float)); }
   int                   reinitialize();
  
	float&                 add(int n);
	void                   add(int n, CString& s);
	int                    add(CString& s);
	int                    add( float f );
	
  inline void						 setData( float* f, int len  ) { fValue = f; fLength = fSize = len; }

  floatVec &              operator = (const floatVec & a);
  floatVec                at(int from = 0, int n = -1);

  int                     capacity() const;
  void                    resize( int newlen ); 
  void                    resize( int newlen, float fill ); 
  void                    clear();                       

//  float&                  operator [] (int n);
  float                   operator [] (int n) const;
  float&                  elem(int n);
//  float                   elem(int n) const;

  friend floatVec         concat(floatVec & a, floatVec & b);
  friend floatVec         map(floatMapper f, floatVec & a);
  friend floatVec         merge(floatVec & a, floatVec & b, floatComparator f);
  friend floatVec         combine(floatCombiner f, floatVec & a, floatVec & b);
  friend floatVec         reverse(floatVec & a);

  void                  reverse();
//  void                  sort(floatComparator f);
  void                  fill(float  val, int from = 0, int n = -1);
  void                  CopyToString(CString& s, int from = 0, int n = -1);
  int                   CopyFromString(CString& s, char sep = ',', int from=0);

  void                  apply(floatProcedure f);
  float                   reduce(floatCombiner f, float  base);
  int                   index(float  targ);

  friend int            operator == (floatVec& a, floatVec& b);
  friend int            operator != (floatVec& a, floatVec& b);

  void                  error(const char* msg) const;
  void                  range_error(int index) const;
  const float*          data() const;
  float*                DataStart();
  void                  TextDump(FILE* oFile) const;
  inline int            Size() { return fSize; }
	static float 					ErrorVal() { return fErrorVal; }

};

inline floatVec::floatVec()
{
  fLength = 0; fValue = 0;   fOrigin = NULL; fSize = 0;
}

inline floatVec::floatVec(int l)
{
  fValue = new float [fLength = l];   fOrigin = NULL; fSize = 0;
}


inline floatVec::floatVec(int l, float* d) : fLength(l), fValue(d) { fOrigin = NULL; fSize = l; }


inline floatVec::~floatVec()
{
  if( fOrigin ==  NULL ) delete [] fValue;
}

/*
inline float& floatVec::operator [] (int n)
{
#ifdef DEBUG
  if ((unsigned)n >= (unsigned)fLength)
    range_error();
#endif
	if( (n+1) > fSize ) fSize = n+1;
  return fValue[n];
}
*/
inline float floatVec::operator [] (int n) const
{
  if ((unsigned)n >= (unsigned)fLength) return 0.0;
  return fValue[n];
}

inline float& floatVec::elem(int n)
{
#ifdef DEBUG
  if ((unsigned)n >= (unsigned)fLength) {
    range_error(n);
    return fErrorVal;
	}
#endif
	if( (n+1) > fSize ) fSize = n+1;
  return fValue[n];
}

inline void floatVec::clear() { fSize = 0; fill(0.0); }
/*
inline float floatVec::elem(int n) const
{
#ifdef DEBUG
  if ((unsigned)n >= (unsigned)fLength)
    range_error();
#endif
  return fValue[n];
}
*/
inline float* floatVec::DataStart()
{
  return fValue;
}

inline const float* floatVec::data() const
{
  return fValue;
}


inline int floatVec::capacity() const
{
  return fLength;
}

inline void floatVec::alloc(int len)
{
  fValue = new float [len];
  fLength = len;
}
inline void floatVec::realloc(int len)
{
	if( len > fLength ) {
		float* tmp =  new float [len];
		memcpy(tmp,fValue,fLength*sizeof(float));
		fLength = len;
		fValue = tmp;
		if( fValue ) { delete fValue; }
	}
}

inline void floatVec::shallow_copy(floatVec& v)
{
  if(fValue) { delete [] fValue; }
  fValue = v.fValue;
  fLength = v.fLength;
  fSize = v.fSize;
  fOrigin = &v;
}

inline int floatVec::reinitialize() {
  if(  fOrigin ) {
    fValue = fOrigin->fValue;
    fLength = fOrigin->fLength;
    fSize = fOrigin->fSize;
    return 1;
  } else return 0;
}

inline int operator != (floatVec& a, floatVec& b)
{
  return !(a == b);
}

#endif
