#ifndef __VOBJECT_H
#define __VOBJECT_H

#ifndef __CLASSES_H
#include <classes.h>
#endif

#include "Globals.h"

//////////////////////////////////////////////////////////////////////////////
// Object
//////////////////////////////////////////////////////////////////////////////
class VObject
{
public:

  virtual ~VObject() {}
  virtual const char* class_name() const;
  virtual word class_id() const;
  virtual Bool ok() const;
  virtual VObject* dup() const;
  virtual word hash() const { return 0; }
  virtual Bool equals( const VObject& b ) const { return (this == &b); }
};

//////////////////////////////////////////////////////////////////////////////
// TSortable
//////////////////////////////////////////////////////////////////////////////
class TSortable : public VObject
{
public:
  // @FPUB
  virtual int compare(const TSortable& s) const pure;
  virtual const char* class_name() const;
  virtual word class_id() const;
};

//////////////////////////////////////////////////////////////////////////////
// inline functions
//////////////////////////////////////////////////////////////////////////////

inline Bool operator ==(const TSortable& a, const TSortable& b)

{
  int res = a.compare(b);
  return res == 0 || res == SME_UNDEFINED;
}

inline Bool operator >(const TSortable& a, const TSortable& b)

{
  int res = a.compare(b);
  return res > 0 || res == SME_UNDEFINED;
}

inline Bool operator <(const TSortable& a, const TSortable& b)

{
  int res = a.compare(b);
  return res < 0 || res == SME_UNDEFINED;
}

inline Bool operator >=(const TSortable& a, const TSortable& b)

{
  int res = a.compare(b);
  return res >= 0 || res == SME_UNDEFINED;
}

inline Bool operator <=(const TSortable& a, const TSortable& b)

{
  int res = a.compare(b);
  return res <= 0 || res == SME_UNDEFINED;
}

inline Bool operator !=(const TSortable& a, const TSortable& b)

{
  int res = a.compare(b);
  return res != 0 && res != SME_UNDEFINED;
}

#ifdef __VOBJECT_CPP
#define extern
#endif

#undef extern

#endif // __OBJECT_H
