//-------------------------------------------------------------------------------
//	pgIO.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//	
//--------------------------------------------------------------------------------

#ifndef __pgIO__
#define __pgIO__

#include "CString.h"
#include "Environ.h"
#include "floatVec.h"
#include "StringPlex.h"

typedef class PGdatabase;

class pgIO {

#ifdef POSTGRESS
  PGdatabase* f_data;
#endif
	
  CString f_dbName;
  CString f_MsgBuff;
  ArgArray f_Names;
  int f_debug;
  int f_TransactionStarted;
  floatVec f_Values;
  enum ELineType { kParmDec, kComment };

	void PrintStatus( const char* str, int rv );
	
	int Execute( const char* cmd_name );	
	inline void PrintErrorMsg();
	
public:

	enum ETableType { kHDepParm, kSeries };
	enum EDBPName { kHab, kSector, kParm };
			
	pgIO(int debug = 1, int connect = True);
	pgIO(const char* dbaseName, int debug = 1, int connect = True);
	~pgIO();
	
	int Connect( const char* dbName = NULL);
	int Start();
	int End();
	int CreateTable( const char* table_name, ETableType tt  );
	int DumpTable( const char* table_name, ETableType tt, FILE* fp, int dumpData = 1, char* sector = NULL );
	inline void  SetDebug( int d ) { f_debug = d; }
	
	int AddDBPValue( const char* table_name, const char* hab_name, int hab_index, 
					const char* sector_name, const char* parm_name, const char* units, float value, const char* comment );
	int AddSeriesValue( const char* table_name, const char* sector_name, const char* series_name, 
											 const char* date, float dt, const char* units, floatVec& value, const char* comment );
	int UpdateDBPValue(  const char* table_name, int hab_index, const char* sector_name, 
												const char* parm_name, float value, const char* comment );
	int DumpDBPValues( const char* table_name, FILE* fp, const char* sector_name = NULL );
	int AddHabName( const char* table_name, const char* hab_name, int hIndex );	
	int GetDBPValues( const char* table_name, const char* sector_name, const char* parm_name );
	int GetSeriesValues( const char* table_name, const char* sector_name, const char* series_name, const char* date=NULL ); 
	int GetNames( const char* table_name, EDBPName dn, const char* sector_name = NULL );
	void ReadExport( const char* table_name, const char* filename );
	int DeleteDBPValue(  const char* table_name, const char* sector_name = NULL, 
													 const char* parm_name=NULL, int hab_index  = 0   );
											
  inline const floatVec& Values() const { return f_Values; }
	inline float Value(int i) const { return f_Values[i]; }
	inline const char* Name(int i) const { return f_Names[i].chars(); }
	inline const ArgArray& Names() const { return f_Names; }
};

#endif

