#ifndef __ViewServer__
#define __ViewServer__

#include <stdio.h>

#ifdef JAVA

#ifndef byte
typedef unsigned char byte;
#endif

typedef class DataSocket DataSocket;

class ViewServer {

	static DataSocket* _ds;
	static char _host[256];
	static int _port;
	static FILE* _logStream;
	static int _debug; 
	static int _initialized; 
	static int _simulation_initialized; 
	static int _startup_listener;
	static int _timeout;
	static int _buffer_size;
	static int _dataset_index;
	static unsigned short* _data_buffer;
	
	static char* _proj_name;
	static char* _model_name;
	static char* _proj_path; 

	static int connect()	;  
	static void do_init_simulation();

	public:

	static int SECONDS;
	static int DAYS;
	static int MONTHS;
	static int YEARS;

	static int BYTES;
	static int SHORTS;
	static int INTS;
	static int FLOATS;
	
	static int init( int argc, char *argv[] );
	static int config( const char* host, int port ); 
	static byte create_2D_animator(int width, int height, byte animatorType, byte* region_map, const byte* name  );
	static byte create_3D_animator(int width, int height, int max_images, byte* region_map, const byte* name );
	static byte create_3D_ContourViewer(int length0, int length1, int length2, int nimages, const byte* name );	

	static void send_animation_frame( byte index, int size, int* data, float time, const byte* info = NULL  );
	static void send_animation_frame( byte index, int size, int* data, int max_val, int min_val, float time, const byte* info = NULL  );

	static void send_animation_frame( byte index, int size, float* data, float time, const byte* info = NULL  );
	static void send_animation_frame( byte index, int size, float* data, float max_val, float min_val, float time, const byte* info = NULL  );

	static void send_animation_frame( byte index, int size, short* data, float scale[2], float time, const byte* info = NULL  );
	static void send_3D_animation_frame( byte index, int size, float* data, float time, const byte* info = NULL  );
	static void send_contour_image_frame( byte ind, int s, float* data, float time, const byte* info = NULL  );
	static void send_contour_image_frame( byte ind, int s, float* data, float scale[2], float time, const byte* info = NULL  );

	static byte create_new_graph( byte index, int t0, int tf, float dt, float ymin, float ymax, const byte* name, byte units, byte overwrite = 0 );
	static byte add_graph_component( const byte* name, const byte* color, byte graph_index );
	static void send_graph_data(  byte graph_index, byte component_index, int offset, int npoints, float* data );	
	static void disconnect() ;

	static int create_dataset(int L0, int L1, int L2, byte dim, byte array_dim, byte* region_map, const byte* name, const char* categories = NULL, byte format = 0, int browse = 0 );
	static void add_data_entry( int dataset_index, short* data, int data_size, float max, float min, float time, float dt, const byte* info, byte format=0  );
	static void init_simulation( const char* proj_name, const char* model_name, const char* proj_path  );
	static void setLogStream( FILE* f );

};

#endif
#endif
