//-------------------------------------------------------------------------------
//	Module.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//	
//--------------------------------------------------------------------------------

#ifndef __Module__
#define __Module__

#include "MML_Module.h"


//----------------------------------------------------------------------------------------
//						TModule
//----------------------------------------------------------------------------------------
  
class TModule : public Module
{

  char fCD[4];
  TNamedObjectList fExternalModulesList;
	void  WriteNameToConfigFile(CStream& cnfgStream, char type, const CString& name);
    
 protected:

 public:

  enum EStatus { kStandard, kGlobal, kExternal, kIgnored };
  enum EOptimizationLevel { kNone, kSeparateSpatial, kMergeCmds };

  static EConfigInfo kStatus;
  static EConfigInfo kOpLevel;

  TModule ( const CString& name );
 
  void PrintName (FILE *DFile, Bool printValue);
  void Free ();
  void MakeConnections (void);
  
  virtual void  WriteDataToConfig( CStream& outStream );   
  int Config( TConfigData& cd);
			
  Variable* CreateNewVariable( const CString& variable_name, Variable* template_var = NULL );
  Module* AddSubModule(const char* module_name, Bool create = True );
  int  ReadEvent( TMMLData& md, TEvent::EType et );
 
  void SetFieldsFromMML ();
  void CreateCommandDependencies(void);
  virtual void WriteModuleCode(FILE* CHdrFile, FILE* CEqnFile) const;
  virtual int ConfigExternal(TConfigData& cd, Module* m); 
};



#endif

