//----------------------------------------------------------------------------------------
  //	ObjectIterator.h
  //	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
  //	Change History:
  //----------------------------------------------------------------------------------------
  
#ifndef __ObjectIterator__
#define __ObjectIterator__

#include "SList.h"
typedef class TVariable TVariable;
typedef class TModule TModule;
typedef class TGraph TGraph;

class CObjectIterator {
  Pix fP;
  TNamedObjectList& fList;

public:
  CObjectIterator(TNamedObjectList& l) : fList(l) { fP = 0;}

  inline TOrderedObject* First() { 
    fP = fList.first(); 
    return (TOrderedObject*) ((fP) ? &fList.elem(fP) : NULL); 
  }

  inline int More() { 
    if( fP == 0 ) return 0;
    else  return 1;
  }

  inline TOrderedObject* Next() { 
    fList.next(fP); 
    return (TOrderedObject*) ((fP) ? &fList.elem(fP) : (TOrderedObject*) NULL); 
  }

  inline TModule* FirstModule() { return (TModule*) First(); }
  inline TModule* NextModule() { return (TModule*) Next(); }
  TVariable* FirstVariable() { return (TVariable*) First(); }
  TVariable* NextVariable() { return (TVariable*) Next(); }
  TGraph* FirstGraph() { return (TGraph*) First(); }
  TGraph* NextGraph() { return (TGraph*) Next(); }
};


#endif
