//----------------------------------------------------------------------------------------
//	Variable.cc
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------
  
#include "ObjectIterator.h"
#include "Variable.h"
#include "Module.h"
#include "Model.h"
#include "MML_Connection.h"
#include "MML_Pipe.h"

 FlagType	FisGraph ;		//  1 = is Graph

  //----------------------------------------------------------------------------------------
  //				TVariable::TVariable:
  //----------------------------------------------------------------------------------------
  
  
TVariable :: TVariable (const char* name ) : Variable(name)
{ 
	if(fFlagList==NULL) {
    fFlagList = new TObjectList();
    AddFlags();
  } 
	fDerivatives = 0;
} // TVariable::IVariable
  
void TVariable::AddFlags() {
	Variable::AddFlags();
  AddFlag("FisGraph",FisGraph);
}
 
  
//----------------------------------------------------------------------------------------
//				TVariable::SetFieldsFromValue:
//----------------------------------------------------------------------------------------

void TVariable :: SetFieldsFromMML () 
{
  if( GetCInfo(kType) == kNULL ) {
	  sprintf( gMsgStr, " %s::%s(mode %x): Variable referenced but not declared .", fModule->Name(), Name(), GetCInfo(kMode) );
	  gPrintErr();
	}
  if( GetCInfo(kType) == kState ) { 
    SetF( FisStateVar, True, "SetFieldsFromMML"); 
    SetF( FisClamped, True, "SetFieldsFromMML"); 
    SetF(FisConstant,False,"SetFieldsFromMML"); 
  }
  if( GetCInfo(kType) == kFlux ) SetF( FisFlux, True, "SetFieldsFromMML"); 
  if( GetCInfo(kMode) == kInput ) SetF( FisImport, True, "SetFieldsFromMML"); 
  if( GetCInfo(kMode) == kIgnored ) SetF( FisIgnored, True, "SetFieldsFromMML"); 

	int potentialParam = (GetCInfo(kInitMode) != kDBase), isParam = 0; 
	CString pvalue; 
	for( Pix p = fCommandList.first(); p; fCommandList.next(p) ) {
		TCommand& c = (TCommand&) fCommandList(p);
		if( ( c.GetObjInfo(TCommand::kType) == TCommand::kUpdate ) && potentialParam && ( c.ArrayOrder() == 0 ) ) {
			if( c.GetObjInfo( TCommand::kDepIndex ) == TCommand::kParameter ) { 
				isParam = 1;
				TEquationNode* en = (TEquationNode*) c.GetNode();
				TConstNode* cn = (TConstNode*) en->Expr();
				pvalue = cn->StringVal();
			} else {
				potentialParam = 0; isParam = 0;  
			}
		} else if ( c.GetObjInfo(TCommand::kType) == TCommand::kIntegrate ) {
				potentialParam = 0; isParam = 0;      
		}  else if ( c.GetObjInfo(TCommand::kType) == TCommand::kFunction ) {
		  SetF(FisConstant,False," SetFieldsFromMML: Function Command "); 
		}
	}
	if( isParam ) {
		SetF(FisSpatial,False,"ParseConfig");
		SetF( FisConstant ,True,"ParseConfig");
		SetCInfo(kInitMode, kParameter);
		fDefValue.elem(0) = pvalue;				
	}
}

//----------------------------------------------------------------------------------------
//				TVariable::SplitCondition:
//----------------------------------------------------------------------------------------

int TVariable :: SplitCondition( int splitIndex ) { 
  switch (  splitIndex ) {
  case kSplitConstant:
    if( GetF(FisConstant) ) return 1;
    else return 0;
    break;
  case kSplitSpatial:
    if( GetF(FisSpatial) )  return 1;
    else return 0;
    break;
  }
}

//----------------------------------------------------------------------------------------
//				TVariable::SetFieldsFromValue:
//----------------------------------------------------------------------------------------
/*    
void TVariable :: SetFieldsFromValue (CString& value, TEvent::EType et) 
{
  if(GetF(FisImport)) return;

  //  if( GetF(FisFunctionArg) ) { 
  //    SetF( FisSpatial | FdoLinkEdges, True, "SetFieldsFromValue"); 
  //  }

  if( value.containsName("GRAPH") >= 0 ) {
    SetF(FisGraph,True,"SetFieldsFromValue");
  }

  if( GetF(FisImport) && fConnection->GetModule()->GetCInfo(TModule::kStatus) == TModule::kIgnored ) {
    SetF(FisSpatial,False,"SetFieldsFromValue");
    SetF(FisConstant,True,"SetFieldsFromValue");
    SetF( FisIgnored, True, "SetFieldsFromMML"); 
  }
  if( value.containsName("SL::Rand") >= 0 ||  value.containsName("SL::Normal") > 0 ) { 
    if(GetF(FisSpatialRand)) SetF(FisSpatial,True,"SetFieldsFromValue");  
    SetF(FisConstant,False,"SetFieldsFromValue");  
  }
} */
  
  //----------------------------------------------------------------------------------------
  //				TVariable::Free:
  //----------------------------------------------------------------------------------------
  
  void TVariable::Free ()
{

} // TVariable::Free


  //----------------------------------------------------------------------------------------
  //				TVariable::Dump:
  //----------------------------------------------------------------------------------------
  
void TVariable::Dump(FILE* oFile)
{
  TVariable* aVar;
  if( GetCInfo(Variable::kType) !=  Variable::kTime  ) {
    Variable::Dump(oFile);
    fprintf(oFile,"\t\tVar %s DUMP: InitMode=%x", Name(), GetCInfo(kInitMode) );
    if(fModule) { fprintf(oFile," Module=%s",fModule->Name()); }
    else fprintf(oFile," Module=NULL");
    PrintFlags();
    if( fConnection ) fprintf(oFile,"\t\tConnection = %s : %s\n",
			      fConnection->GetModule()->Name(), fConnection->Name() ); 
  }
}  //  TVariable::PrintFields
  


int TVariable::Config( TConfigData& cd) {
  const CString& cmd = cd.Cmd();
  if ( cmd == "DS" ) {
		CString depVar;
		Module* m = NULL; 
		if( cd.HasArg(0) ) { depVar = *cd.Arg(0); }
		if( cd.HasArg(1) ) {
			CString &mod = *cd.Arg(0); 
			m =  Model::I0().GetModule( mod, False );
			if( m == NULL ) { 
				sprintf(gMsgStr,"Can't find Module %s in DS config cmd.",mod.chars()); 
				gPrintErr(); 
			} 
		} else { m = fModule; }
		if( m ) {
			Variable* v = m->GetVariable(depVar,False);
			if( v == NULL ) { 
				sprintf(gMsgStr,"Can't find Variable %s:%s in DS config cmd.", m->Name(), depVar.chars() ); 
				gPrintErr(); 
			} else {
				TDerivative* d = Model::I0().GetDerivative(v);
				Pix p0 = d->AddInitiator( this );
				sprintf(gMsgStr,"Configured derivative d-%s / d-%s", Name(), depVar.chars() ); 
				gPrintScreen(); fDerivatives++;
			}
		}
	} else {
		return Variable::Config(cd);
	}
	return 1;
} //  TVariable::ParseConfig



  //----------------------------------------------------------------------------------------
  // GLOBALS::printSVDebugCode: 
  //----------------------------------------------------------------------------------------
  
void TVariable::PrintSVDebugCode(FILE* cFile) 
{
  int nVar=0;
  char sc='%';
  TVariable* aFluxVar;
  
  if(GetF(FisSpatial)) fprintf(cFile,"\t\tif(fDebug>0) if(fIndex==1) if( cellIndex == 0 ) { sprintf(gNet->fMsgStr,\"\\n#FD %s fluxes = (",Name());
  else fprintf(cFile,"\t\tif(fDebug>0) if(fIndex==1) { sprintf(gNet->fMsgStr,\"\\n#FD %s fluxes = (",Name());
  CObjectIterator fluxIter(fFluxList); 
  for(aFluxVar = fluxIter.FirstVariable(); fluxIter.More(); aFluxVar = fluxIter.NextVariable()) 
  	if( !aFluxVar->GetF(FisIgnored) ) { 
  		if(nVar>0) fprintf(cFile,",");
		fprintf(cFile," %s",(char*)aFluxVar->Name()); nVar++;
	}
  fprintf(cFile,")\\n\"); gNet->PrintOut(0); }\n");
  if(nVar==0) return;
  if( GetF(FisSpatial) ) fprintf(cFile,"\t\tif(fDebug>0) if( gCurrentPoint->fInfo[0] == 'd' ) {\n\t\t\tsprintf(gNet->fMsgStr,\"\\n#FV %s fluxes = (",Name()); 
  else fprintf(cFile,"\t\tif(fDebug>0) {\n\t\t\tsprintf(gNet->fMsgStr,\"\\n#FV %s fluxes = (",Name()); 
  for(int i=0; i<nVar; i++) fprintf(cFile,"%cf,",sc);
  fprintf(cFile,")\","); nVar=0;
  for(aFluxVar = fluxIter.FirstVariable(); fluxIter.More(); aFluxVar = fluxIter.NextVariable()) 
  	if(!aFluxVar->GetF(FisIgnored)) { 
  		if(nVar>0) fprintf(cFile,",");
		fprintf(cFile," %s",(char*)aFluxVar->Name()); nVar++;
		if( aFluxVar->GetF(FisSpatial)  ) {
		  if( GetF(FisSpatial) ) {
		    if( aFluxVar->GetF(FisSpatial) ) {
		      fprintf(cFile,"->Value(cellIndex)"); 
		    }
		    else fprintf(cFile,"->Value()"); 
		  }
		  else if(GetF(FisSpatial) ) {
		    //				char frameType = aVar->fModule->fFrame.fType;
		    //		  		if(frameType == 'G') sprintf(vname,"->fGridPlex(gCurrentPoint)");
		    fprintf(cFile,"->fValueP[cellIndex]"); 
		  } 
		  else fprintf(cFile,"->fValueP[TIME->Step(0,1)]"); 
		}
		else fprintf(cFile,"->Value()"); 
	      }
  fprintf(cFile,"); gNet->PrintOut(0);\n\t\t}\n");
}
    
  //----------------------------------------------------------------------------------------
  //				TVariable::WriteDataToConfig:
  //----------------------------------------------------------------------------------------
  
  void  TVariable::WriteDataToConfig( CStream& outStream ) const
{
  if( GetCInfo(Variable::kType) ==  Variable::kTime  ) return;
  if( fName.length() == 0 ) return;  

  Variable::WriteDataToConfig(outStream);
  
  if( fDerivatives > 0 ) {
		int cnt = 0;
		TNamedObjectList& dlist = Model::I0().Derivatives();
		for( Pix p = dlist.first();  p; dlist.next(p) ) {
			TDerivative* d = (TDerivative*) &dlist(p);
			TNamedObjectList& initiators = d->fInitiators;	
			for( Pix pt = initiators.first(); pt; initiators.next(pt) ) {
				const Variable* v = (Variable*)&initiators(pt); 
				if( v == this ) {
					 Module* m = d->fIndepVar->GetModule();
					 if( m != fModule ) { outStream << " DS(" << d->fIndepVar->Name() << "," << m->Name() << ")"; }
					 else { outStream << " DS(" <<  d->fIndepVar->Name() << ")"; }
					 if( ++cnt == fDerivatives ) return;
				}
			}
		}  
  }
  
} // TVariable::WriteDataToConfig

  //---------------------------------------------------------------------------------------------------
  //				TVariable::AddModifier:
  //----------------------------------------------------------------------------------------
  

int TVariable::AddModifier( const CString& mod ) {
  if( Variable::AddModifier( mod ) ) {
    if( GetCInfo(kType) == kFlux ) { SetF(FisFlux,True,"AddModifier"); }
    else if(  GetCInfo(kType) == kState ) { SetF(FisStateVar,True,"AddModifier"); }
    else if(  GetCInfo(kType) == kAux ) { ; }
    if(  GetCInfo(kMode) == kInput ) { SetF(FisImport,True,"AddModifier"); }
    return 1;
  } else return 0;
}


enum EFunctionType { kNoFunction, kUtilityFunction, kSpatialFunction, kAggSpatialFunction };

EFunctionType function_enclosure_type(char* val, int offset);   


EFunctionType function_enclosure_type(char* val, int offset) {
  int sLevel = 0; 
  char *tst = val+offset;
  while( --tst > val ) { 
    if(  *tst == '(' && sLevel == 0 ) { break; }
    else if(  *tst == ')' ) sLevel++;
  }
  while( --tst >= val ) {
    if( *tst == 'P' ) return kSpatialFunction;
		if( *tst == 'X' ) return kAggSpatialFunction;
   if( !isspace(*tst) ) {
      if( isalnum(*tst) )  return kUtilityFunction;
      else return kNoFunction;
    }
  }
  return kNoFunction;     
}
   



  
