#include "pgIO.h"
enum EActionType { kTest, kImport, kDump, kModify, kInsert, kDelete };

main(int argc, char *argv[])
{
		CString tableName;
		CString dbaseName;
		CString fileName;
		CString sectorName;
		CString parmName;
		CString comment;
		int habIndex;
		float value;
  	EActionType at = kImport;
  	pgIO::ETableType tt = pgIO::kHDepParm;

		if( argc == 2 ) {
		  printf("pgargs: dbaseName tableName test/import/dump/insert/modify/delete series/hdparm {names ...} \n");
		  exit(0);
		} else if( argc < 5 ) {
		  printf("Usage: pgIO dbaseName tableName test/import/dump/insert/modify/delete series/hdparm {names ...}\n");
		  exit(0);
		}

		if( argv[4][0] == 'h' )  tt = pgIO::kHDepParm;
		else if( argv[4][0] == 's' )  tt = pgIO::kSeries;
		else gFatal("Error, Unknown DataType (series/hdparm).");

		if( strncmp(argv[3],"test",4) == 0 ) {
			at = kTest;		
 		} else if( strncmp(argv[3],"imp",3) == 0 ) {
			at = kImport;
			if(argc < 6) gFatal("Error, Must specify fileName for Import.");
			else fileName = argv[5];
		} else if( strncmp(argv[3],"dump",4) == 0 ) {
			at = kDump;		
		} else if ( strncmp(argv[3],"ins",3) == 0 ) {
				if( argc > 5 ) sectorName = argv[5]; 
				if( argc > 6 ) parmName = argv[6]; else parmName = "NULL"; 
				if( argc > 7 ) habIndex = atoi(argv[7]); else habIndex = 0; 
				if( argc > 8 ) value= atof(argv[8]); else value = 0.0; 
				if( argc > 9 ) comment = argv[9]; else comment = "NULL"; 
				at = kInsert;		
		} else if ( strncmp(argv[3],"mod",3) == 0 ) {
				if( argc > 5 ) sectorName = argv[5]; 
				if( argc > 6 ) parmName = argv[6]; else parmName = "NULL"; 
				if( argc > 7 ) habIndex = atoi(argv[7]); else habIndex = 0; 
				if( argc > 8 ) value= atof(argv[8]); else value = 0.0; 
				if( argc > 9 ) comment = argv[9]; else comment = "NULL"; 
				at = kModify;		
		} else if ( strncmp(argv[3],"del",3) == 0 ) {
				if( argc > 5 ) sectorName = argv[5]; 
				if( argc > 6 ) parmName = argv[6]; else parmName = "NULL"; 
				if( argc > 7 ) habIndex = atoi(argv[7]); else habIndex = 0; 
				at = kDelete;		
		} 	
		else gFatal("Error, Unknown ActionType (test/imp/dump/ins/mod/del).");
			
		dbaseName = argv[1];
		tableName = argv[2];

  	pgIO pgio(dbaseName);
  	pgio.Start();
  	
  	if( at == kTest && tt == pgIO::kHDepParm ) {
			pgio.SetDebug( 1 );
			CString sectorName = "Sector1";
			CString parmName = "Parm1";
			int nHab = 10;
			pgio.CreateTable( tableName, pgIO::kHDepParm);

			for( int i=0; i<nHab; i++ ) {
				CString HabName = "Hab"; 
				HabName.appendIndex(i);		
				pgio.AddDBPValue( tableName, HabName, i, sectorName, parmName, "m", i*0.1, " ");
			}

			int nv = pgio.GetDBPValues( tableName, sectorName, parmName );
			if(nv>0) { 
				gPrintScreen( "GotValues:\n" );
				for( int i=0; i<nv; i++ ) {
					sprintf(gMsgStr,"%d:  %f\n",i,pgio.Value(i) ); gPrintScreen( );
				}
			}
			nv = pgio.GetNames( tableName, pgIO::kSector );
			if(nv>0) { 
				gPrintScreen( "GotNames:\n" );
				for( int i=0; i<nv; i++ ) {
					sprintf(gMsgStr,"%d:  %s\n",i, pgio.Name(i) ); gPrintScreen( );
				}
			}
		} else if( at == kTest && tt == pgIO::kSeries ) {
			pgio.SetDebug( 1 );
			CString sectorName = "Sector1";
			pgio.CreateTable( tableName, pgIO::kSeries);
			CString seriesName = "Series1";
			int sl = 10;
			floatVec seriesVals;

			seriesVals.clear();
			for( int i=0; i<sl; i++ ) {
				seriesVals.add(i) = i*0.001;
			}		
			pgio.AddSeriesValue( tableName, sectorName, seriesName, "10/10/95", 1.0, "days", seriesVals, " " );
			int nv = pgio.GetSeriesValues( tableName, sectorName, seriesName, "10/10/95" );

			if(nv>0) { 
				gPrintScreen( "Got Series Values:\n" );
				for( int i=0; i<nv; i++ ) {
					sprintf(gMsgStr,"%d:  %f\n",i, pgio.Value(i) ); gPrintScreen( );
				}
			}
		} else if( at == kImport && tt == pgIO::kHDepParm ) {
			 pgio.SetDebug( 1 );
			 pgio.CreateTable( tableName, pgIO::kHDepParm);
			 pgio.ReadImportFile( tableName, fileName );
		} else if( at == kDump ) {
			 pgio.SetDebug( 0 );
			 if(argc>5) pgio.DumpTable( tableName, tt, stderr, argc-5, argv[5] );
			 else pgio.DumpTable( tableName, tt, stderr, 0 );
		} else if( at == kModify ) {
			 pgio.SetDebug( 1 );
			 pgio.UpdateDBPValue(  tableName, habIndex, sectorName, parmName, value, comment );
		} else if( at == kInsert ) {
			 pgio.SetDebug( 1 );
			 pgio.AddDBPValue( tableName, "***", habIndex, sectorName, parmName, "***", value, comment );
		} else if( at == kDelete ) {
			 pgio.SetDebug( 1 );
			 pgio.DeleteDBPValue(  tableName, sectorName, parmName, habIndex  );
		}
  	pgio.End();
}


	
				
		
		
		
		
		
		
