#include "pgIO.h"

#ifdef POSTGRESS
#include "PQpp.h"
#endif

//----------------------------------------------------------------------------------------
//						pgIO::pgIO
//----------------------------------------------------------------------------------------

pgIO::pgIO( int debug, int connect) {
		f_dbName = getenv("USER");
#ifdef POSTGRESS 
		f_data = NULL;
#endif
		f_debug = debug;
		f_TransactionStarted = 0;
		if( connect ) Connect();
}

pgIO::pgIO(const char* dbaseName, int debug, int connect) {
		f_dbName = dbaseName; 
#ifdef POSTGRESS
		f_data = NULL;
#endif
		f_debug = debug;	
		f_TransactionStarted = 0;
		if( connect ) Connect();
}

pgIO::~pgIO() { 
	End(); 
#ifdef POSTGRESS
	if(f_data) delete f_data; 
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::Execute
//----------------------------------------------------------------------------------------

int pgIO::Execute( const char* cmd_name ) {
#ifdef POSTGRESS
		if( f_debug ) { sprintf(gMsgStr,"Executing command: %s",(const char*)f_MsgBuff); gPrintScreen(); }
	  int rv = f_data->exec(f_MsgBuff.data()); 
		PrintStatus(cmd_name,rv);
		return rv;
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::PrintErrorMsg
//----------------------------------------------------------------------------------------
	
void pgIO::PrintErrorMsg() {
#ifdef POSTGRESS
		sprintf(gMsgStr,"%s",f_data->errormessage()); gPrintErr();
#endif 
}	

//----------------------------------------------------------------------------------------
//						pgIO::Connect
//----------------------------------------------------------------------------------------

int pgIO::Connect( const char* dbName ) {

#ifdef POSTGRESS
 /* begin, by creating the parameter environtment for a backend
     connection. When no parameters are given then the system will
     try to use reasonable defaults by looking up environment variables 
     or, failing that, using hardwired constants */
     
		PGenv f_env;
		if(dbName) f_dbName = dbName;	
		
  /* make a connection to the database */
		f_data = new PGdatabase(&f_env, f_dbName.data() );	
		
  /* check to see that the backend connection was successfully made */
		if (f_data->status() == CONNECTION_BAD) {
			sprintf(gMsgStr,"Connection to database '%s' failed.\n", (const char*) f_dbName); gPrintErr();
			sprintf(gMsgStr,"%s",f_data->errormessage()); 
			delete f_data;
			gFatal();
		}
#endif
		return 1;
}

//----------------------------------------------------------------------------------------
//						pgIO::Start
//----------------------------------------------------------------------------------------

int pgIO::Start() {
	int rv;		
	End();    /* end previous transaction */
#ifdef POSTGRESS	   
  if ( (rv=f_data->exec("BEGIN")) != PGRES_COMMAND_OK) { /* start a transaction block */
    sprintf(gMsgStr,"BEGIN command failed\n");
    delete f_data;
    gFatal();
  } else PrintStatus("BEGIN",rv);
  f_TransactionStarted = 1;
#endif
  return 1;
}

//----------------------------------------------------------------------------------------
//						pgIO::End
//----------------------------------------------------------------------------------------

int pgIO::End() {
	int rv;
#ifdef POSTGRESS
		/* end previous transaction */
	if( f_TransactionStarted ) {
		rv = f_data->exec("END");
		PrintStatus("END",rv);
		f_TransactionStarted = 0;
	}
#endif
	return 1;
}

//----------------------------------------------------------------------------------------
//						pgIO::CreateTable
//----------------------------------------------------------------------------------------

int pgIO::CreateTable( const char* table_name, ETableType tt ) {
#ifdef POSTGRESS
  int rv=0;
  f_MsgBuff = "DROP TABLE ";
  f_MsgBuff += table_name;
  f_MsgBuff += ";";
	rv = Execute("DROP TABLE");
	if( rv == PGRES_FATAL_ERROR ) Start(); 

	switch(tt) {
		case kHDepParm:	
			f_MsgBuff = "CREATE TABLE ";
			f_MsgBuff += table_name;
			f_MsgBuff += "( HabName  varchar(20), HabIndex int, SectorName  varchar(20),";
			f_MsgBuff += " ParmName  varchar(20), Units  varchar(20), ParmValue float, Comment  varchar(256) );";
			break;
		case kSeries:
			f_MsgBuff = "CREATE TABLE ";
			f_MsgBuff += table_name;
			f_MsgBuff += "( SectorName  varchar(20), SeriesName  varchar(20), StartTime date, ";
			f_MsgBuff += " DT  float, Units  varchar(20), SeriesValue float[], Comment  varchar(256) );";
			break;
	}
	return Execute("CREATE TABLE");
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::AddValue
//----------------------------------------------------------------------------------------

int pgIO::AddDBPValue(  const char* table_name, const char* hab_name, int hab_index, const char* sector_name, 
												const char* parm_name, const char* units, float value, const char* comment ) {
#ifdef POSTGRESS
  int rv=0;
  f_MsgBuff = "INSERT INTO ";
  f_MsgBuff += table_name;  
  f_MsgBuff += " VALUES ( '";
  f_MsgBuff += hab_name;  f_MsgBuff += "', ";
	f_MsgBuff.appendIndex(hab_index);  f_MsgBuff += ", '";
  f_MsgBuff += sector_name;  f_MsgBuff += "', '";
  f_MsgBuff += parm_name;  f_MsgBuff += "', '";
  f_MsgBuff += units;  f_MsgBuff += "', ";
  f_MsgBuff += value;  f_MsgBuff += ", ' ";
  f_MsgBuff += comment;  f_MsgBuff += "' );";  
  return Execute("INSERT ");
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::UpdateDBPValue
//----------------------------------------------------------------------------------------

int pgIO::UpdateDBPValue(  const char* table_name, int hab_index, const char* sector_name, 
												const char* parm_name, float value, const char* comment ) {
#ifdef POSTGRESS
  int rv=0;

  f_MsgBuff = "UPDATE ";
  f_MsgBuff += table_name;  
  f_MsgBuff += " SET ParmValue = ";
	f_MsgBuff += value; 
	if( comment ) {
		f_MsgBuff += ", Comment = '";
		f_MsgBuff += comment; f_MsgBuff +=  "' ";  
	}
  f_MsgBuff += " WHERE HabIndex = ";
	f_MsgBuff.appendIndex(hab_index);  
	f_MsgBuff += " and SectorName = '";
  f_MsgBuff += sector_name;  
	f_MsgBuff += "' and ParmName = '";
  f_MsgBuff += parm_name;  
  f_MsgBuff += "';";
  return Execute("INSERT ");
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::DeleteDBPValue
//----------------------------------------------------------------------------------------

int pgIO::DeleteDBPValue(  const char* table_name, const char* sector_name, 
													 const char* parm_name, int hab_index  ) {
#ifdef POSTGRESS
  int rv=0;

  f_MsgBuff = "DELETE FROM ";
  f_MsgBuff += table_name;  
  if( sector_name ) {
    f_MsgBuff += " WHERE ";
		f_MsgBuff += " SectorName = '";
		f_MsgBuff += sector_name;  f_MsgBuff += "' "; 
		rv = 1; 
  }
	if( parm_name ) {
		if( rv ) f_MsgBuff += " and ";
		else f_MsgBuff += " WHERE ";
		f_MsgBuff += " ParmName = '";
		f_MsgBuff += parm_name;  f_MsgBuff += "' "; 
		rv = 1; 
	}
	if( hab_index ) {
		if( rv ) f_MsgBuff += " and ";
		else f_MsgBuff += " WHERE ";
		f_MsgBuff += " HabIndex = ";
		f_MsgBuff.appendIndex(hab_index); 
	} 
	f_MsgBuff += ";";
	if( Env::QueryUser( "Execute Deletion" ) ) { 
		return Execute("INSERT ");
	} else {
		return 0;
	}
#endif
}


//----------------------------------------------------------------------------------------
//						pgIO::AddHabName
//----------------------------------------------------------------------------------------

int pgIO::AddHabName( const char* table_name, const char* hab_name, int hIndex ) {
#ifdef POSTGRESS
  int rv=0;
  f_MsgBuff = "UPDATE ";
  f_MsgBuff += table_name;  
  f_MsgBuff += " SET  HabName = '";
  f_MsgBuff += hab_name;  f_MsgBuff += "'";
  f_MsgBuff += " WHERE HabIndex = ";  
  f_MsgBuff.appendIndex(hIndex);
	f_MsgBuff += ";";  
  return Execute("UPDATE ");
#endif
}
//----------------------------------------------------------------------------------------
//						pgIO::AddValue
//----------------------------------------------------------------------------------------

int pgIO::AddSeriesValue( const char* table_name, const char* sector_name, const char* series_name, const char* date, float dt, const char* units, floatVec& value, const char* comment ) {
#ifdef POSTGRESS
  int rv=0;
  f_MsgBuff = "INSERT INTO ";
  f_MsgBuff += table_name;  
  f_MsgBuff += " VALUES ( '";
  f_MsgBuff += sector_name;  f_MsgBuff += "', '";
  f_MsgBuff += series_name;  f_MsgBuff += "', '";
  f_MsgBuff += date;  f_MsgBuff += "', ";
  f_MsgBuff += dt;  f_MsgBuff += ", '";
  f_MsgBuff += units;  f_MsgBuff += "', '{";
  value.CopyToString(f_MsgBuff);  f_MsgBuff += "}', ' ";
  f_MsgBuff += comment;  f_MsgBuff += "' );";  
  return Execute("INSERT ");
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::DumpTable
//----------------------------------------------------------------------------------------

int pgIO::DumpTable( const char* table_name, ETableType tt, FILE* fp, int dumpData, char* sector ) {
#ifdef POSTGRESS
	f_debug = 0;
	int np;
	if(dumpData == 2) { return DumpDBPValues( table_name, fp, sector ); }
	CString parm_name;
	int ns = GetNames( table_name, kSector );
	ArgArray sectorNames(Names());	
	for(int i=0; i<ns; i++) if( sector == NULL || sectorNames[i] == sector ) {
		fprintf(fp,"\n\nSector = %s",(const char*)sectorNames[i]);
		np = GetNames( table_name, kParm, sectorNames[i] );
		for(int j=0; j<np; j++) {
			parm_name = Name(j);
			fprintf(fp,"\n\t%s",(const char*)parm_name);
			if(dumpData) {
				int nd = GetDBPValues( table_name, sectorNames[i], parm_name );
				int nv = f_Values.Size();
				for( int k=1; k<nv; k++ ) {
					fprintf(fp," %f ",f_Values[k]);
				}
			}
		}
	}
	return np;
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::GetValues
//----------------------------------------------------------------------------------------

int pgIO::GetDBPValues( const char* table_name, const char* sector_name, const char* parm_name ) {
  int rv=0;
#ifdef POSTGRESS
  f_MsgBuff = "SELECT HabIndex, ParmValue FROM ";
  f_MsgBuff += table_name;  
	f_MsgBuff += " WHERE ";
	f_MsgBuff += " SectorName = '";	f_MsgBuff += sector_name; f_MsgBuff += "' and";
 	f_MsgBuff += " ParmName = '";	  f_MsgBuff += parm_name; f_MsgBuff += "';";
  Execute(" SELECT FROM database ");
	int nt = f_data->ntuples();
	if( nt == 0 ) {gPrintErr("Can't find DBase Parm."); return 0; }
	f_Values.clear();
	for (int i=0; i <nt; i++) {
		int hab = atoi(f_data->getvalue(i,0)); 
		f_Values.add(hab) = atof(f_data->getvalue(i,1)); 
	}
	return nt;
#else
	return 0;
#endif
}
//----------------------------------------------------------------------------------------
//						pgIO::DumpDBPValues
//----------------------------------------------------------------------------------------

int pgIO::DumpDBPValues( const char* table_name, FILE* fp, const char* sector_name ) {
  int rv=0;
#ifdef POSTGRESS
  f_MsgBuff = "SELECT SectorName, ParmName, HabIndex, ParmValue FROM ";
  f_MsgBuff += table_name; 
  if( sector_name ) {  
		f_MsgBuff += " WHERE ";
		f_MsgBuff += " SectorName = '";	f_MsgBuff += sector_name; 	f_MsgBuff += "';";
	}	else f_MsgBuff += ";";
  Execute(" SELECT FROM database ");
	int nt = f_data->ntuples();
	if( nt == 0 ) {gPrintErr("Can't find DBase Parm."); return 0; }
	for (int i=0; i <nt; i++) {
		int hab = atoi(f_data->getvalue(i,2)); 
		float value = atof(f_data->getvalue(i,3));
		fprintf(fp,"\n%s: \t%s \t%d %f ",f_data->getvalue(i,0),f_data->getvalue(i,1),hab,value);
	}
	return nt;
#endif
}

int pgIO::GetSeriesValues( const char* table_name, const char* sector_name, const char* series_name, const char* date ) {
  int rv=0;
#ifdef POSTGRESS
  f_MsgBuff = "SELECT SeriesValue FROM ";
  f_MsgBuff += table_name;  
	f_MsgBuff += " WHERE ";
	f_MsgBuff += " SectorName = '";	f_MsgBuff += sector_name; f_MsgBuff += "' and";
 	f_MsgBuff += " SeriesName = '";	  f_MsgBuff += series_name; 
 	if(date) { f_MsgBuff += "' and"; f_MsgBuff += " StartTime = '";	f_MsgBuff += date;  }
 	f_MsgBuff += "';";
  Execute(" SELECT FROM database ");
	int nt = f_data->ntuples();
	if( nt == 0 ) { gPrintErr("Can't find Series."); return 0; }
	if( nt > 1 ) {  gPrintErr("Warning, found more then one Series."); }
	CString ds(f_data->getvalue(0,0));
	nt = f_Values.CopyFromString( ds );
	return nt;
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::GetNames
//----------------------------------------------------------------------------------------

int pgIO::GetNames( const char* table_name, EDBPName dn, const char* sector_name ) {
  int rv=0;
#ifdef POSTGRESS
	switch( dn ) {
		case kSector:
			f_MsgBuff = "SELECT DISTINCT SectorName FROM ";
			f_MsgBuff += table_name;  
			f_MsgBuff += ";";
			break;
		case kParm:
			if( sector_name == NULL )	{gPrintErr("Must specify sector_name to get parm name."); return 0; }
			f_MsgBuff = "SELECT DISTINCT ParmName FROM ";
			f_MsgBuff += table_name;  
			f_MsgBuff += " WHERE ";
			f_MsgBuff += " SectorName = '";	f_MsgBuff += sector_name; f_MsgBuff += "';";
			break;
		case kHab:
			f_MsgBuff = "SELECT DISTINCT HabName FROM ";
			f_MsgBuff += table_name;  
			break;
	}
  Execute(" SELECT FROM database ");
	int nt = f_data->ntuples();
	f_Names.Clear();
	for (int i=0; i <nt; i++) { f_Names.Add(f_data->getvalue(i,0)); }
	return nt;
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::PrintStatus
//----------------------------------------------------------------------------------------


void pgIO::PrintStatus( const char* str, int rv ) {
#ifdef POSTGRESS
	if( f_debug > 0 ) {
		sprintf(gMsgStr,"%s command returned ",str); gPrintScreen();
		switch(rv) {
			case PGRES_EMPTY_QUERY: sprintf(gMsgStr,"PGRES_EMPTY_QUERY\n"); break;
			case PGRES_COMMAND_OK: sprintf(gMsgStr,"PGRES_COMMAND_OK\n"); break;
			case PGRES_TUPLES_OK: sprintf(gMsgStr,"PGRES_TUPLES_OK\n"); break;
			case PGRES_COPY_OUT: sprintf(gMsgStr,"PGRES_COPY_OUT\n"); break;
			case PGRES_COPY_IN: sprintf(gMsgStr,"PGRES_COPY_IN\n"); break;
			case PGRES_BAD_RESPONSE: sprintf(gMsgStr,"PGRES_BAD_RESPONSE\n"); break;
			case PGRES_FATAL_ERROR: sprintf(gMsgStr,"PGRES_FATAL_ERROR: "); break;
			case PGRES_NONFATAL_ERROR: sprintf(gMsgStr,"PGRES_NONFATAL_ERROR: "); break;
			default: sprintf(gMsgStr,"returned %d\n",rv);
		}
		gPrintScreen();
	}
	if( rv == PGRES_FATAL_ERROR || rv == PGRES_NONFATAL_ERROR) {
		if( f_debug == 0 ) { sprintf(gMsgStr,"%s command returned: ",str); gPrintScreen(); }
		PrintErrorMsg(); 
	}
#endif
}

//----------------------------------------------------------------------------------------
//						pgIO::ReadExport
//----------------------------------------------------------------------------------------

const int MAXDATALNLEN = 10000;

void pgIO::ReadExport( const char* table_name, const char* filename ) {
#ifdef POSTGRESS
	FILE	 *fp;
	CString buff, sectorName, parmName, stmp;
	ELineType lt = kParmDec;
	floatVec pData;
	int inSector=0;
	
	if (!(fp = fopen (filename, "r"))) {
		(void) printf ("Can't open %s.\n", filename);
		return;
	}
	while( buff.readLine(fp) ) {
		int index = 0;
		if( buff.contains('\264') ) {
			sectorName = buff.before('\264');
			inSector = 1;
		}	else if(inSector) {
			switch(lt) {
				case kParmDec: {
					int cnt=0;
					parmName =  buff.before('\t');
					index += parmName.length();
					pData.clear();
					while (1) {
						stmp = buff.getTSubString('\t',index); 
						if( stmp.empty() ) break;
						pData.add(cnt++,stmp);
					}					   
					lt = kComment;
					} break;		
				case kComment: { 
					buff.gsub("'","");
					for( int i=0; i < pData.Size(); i++ ) {
						const char* comment = ( i == 0 ) ?  buff.chars() : " ";
						int iH = ( pData.Size() == 1 ) ? 256 : i+1;
						AddDBPValue( table_name, "***", iH, sectorName, parmName, "***", pData[i], comment );
					}
					lt = kParmDec;
					} break;
			}
		}
	}
#endif
}

const int kMaxFields = 25;

void pgIO::ReadImportFile( const char* table_name, const char* filename ) {
#ifdef POSTGRESS
	FILE	 *fp;
	CString buff, sectorName, parmName, comment;
	CString res[kMaxFields];
	float value;
	int iH;
	
	if (!(fp = fopen (filename, "r"))) {
		(void) printf ("Can't open %s.\n", filename);
		return;
	}
	while( buff.readLine(fp) ) {
		buff.splitColumns( res, kMaxFields );
		sectorName = res[0];
		parmName = res[1];
		iH = atoi(res[2]);
		value = atof(res[3]);
		comment = res[4];
		AddDBPValue( table_name, "***", iH, sectorName, parmName, "***", value, comment );
	}
#endif
}
		

		
				
		
		
		
		
		
		
