//----------------------------------------------------------------------------------------
//	Bounds.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __Bounds__
#define __Bounds__

#include "CnfgProcessor.h"
#include "MML_Time.h"

//----------------------------------------------------------------------------------------
//						CBounds
//----------------------------------------------------------------------------------------

enum EBoundType { kB_Max, kB_Min };
 
class CBounds {
  float fMax; 
  float fMin;
  byte fErrorType;
  int fNError;
  int fMaxError;
  float fCurrentTime;

 public:	

  CBounds() { fMax = FLT_MAX; fMin = -FLT_MAX;  fErrorType = 'p';  fNError = 0; fMaxError = 4; fCurrentTime = -FLT_MAX; }
  CBounds(float max, float min) { fMax = max; fMin = min; fErrorType = 'p'; fNError = 0;  fMaxError = 4; fCurrentTime = -FLT_MAX; }
  inline unsigned char CheckOut(float testVal) { if ( ( testVal < fMin ) || ( testVal > fMax ) ) return fErrorType; else return '\0'; }
  inline int CheckIn(float testVal) { return ( ( testVal > fMin ) && ( testVal < fMax ) ); }
  
  inline unsigned char Check(float testVal) {
		unsigned char rval = '\0';
		int isValid = ( testVal <= fMax ) && ( testVal >= fMin );  // Must do this way to catch NaN's
    if ( !isValid ) {
			if( gTime() > fCurrentTime ) { fCurrentTime = gTime(); fNError = 0; }
			if( fNError++ < fMaxError ) { rval = fErrorType; }
		}
		return rval;
  }
  inline float GetBound( EBoundType type ) 
    { switch( type ) { case  kB_Max: return fMax; case kB_Min: return fMin; } }  
  inline float SetBound( EBoundType type, float val ) 
    { switch( type ) { case  kB_Max: return fMax=val;  case kB_Min: return fMin=val; } return 0.0; }

  inline void Config(TConfigData& cd ) {
    int iarg; CString* s;
    cd.FloatArg(0, fMax, CD::kRequired);
    cd.FloatArg(1, fMin );
    if( cd.IntArg(2,iarg) > 0 ) fMaxError = iarg;
    if( s = cd.Arg(3) ) { fErrorType = (*s)[0]; }

    if(gDebug>1) { sprintf(gMsgStr,"\nOutput Config: G(%.1f,%.1f,%c)", fMax,fMin,fErrorType); gPrintDebug(); } 
  }

  inline void WriteDataToConfig( CStream& outStream ) const {
   if ( fMax < FLT_MAX || fMin >  FLT_MIN ) { 
      outStream << " B(" << (double)fMax << "," << (double)fMin << "," << fMaxError << "," << (char)fErrorType << ")"; 
   }	
  }
}; 


#endif
