#include "MML_Model.h"
#include "CnfgProcessor.h"
#include "MML_Module.h"
#include "MML_Variable.h"


int CnfgProcessor::GetDataFromConfig() {

  if( GetObjectType() == kModel ) { Model::I0().Config(*this); }
  else if( GetObjectType() == kModule ) {
    if( NewObject() || fCurrentModule == NULL ) fCurrentModule = Model::I0().GetModule(Name(1),False);
    if(  fCurrentModule == NULL ) { 
      gPrintErr( Name(1) + ": Can't find Module in GetDataFromConfig.");
      TNamedObjectList&  ml = Model::I0().ModuleList();
      CString mtmp("\tModule Dump: ");
	  for( Pix p = ml.first(); p; ml.next(p) ) {
			Module* mod = (Module*) &ml(p);
			mtmp += mod->SName();  mtmp += " ";
	  }
	  gPrintErr( mtmp.chars() );
	  return 0; 
    }
    else fCurrentModule->Config(*this);		
  }
  else if( GetObjectType() == kVariable ) {
    if( NewObject() || fCurrentModule == NULL ) fCurrentModule = Model::I0().GetModule(Name(1),False);
    if(  fCurrentModule == NULL ) { 
			gPrintErr( Name(1) + ": Can't find Module."); 
			if(gDebug) { Model::I0().ModuleListDump(); }
			return 0; 
		}
    if( NewObject() || fCurrentVariable == NULL) fCurrentVariable = fCurrentModule->GetVariable(Name(),False);
    if(  fCurrentVariable == NULL ) {
			TNamedObjectList&  ml = Model::I0().ModuleList();
			Module* mod = NULL;
			for( Pix p = ml.first(); p; ml.next(p) ) {
				mod = (Module*) &ml(p);
				fCurrentVariable = mod->GetVariable(Name(),False);
				if( (fCurrentVariable != NULL) && !fCurrentVariable->GetF(FisImport) ) break;
				else { fCurrentVariable = NULL; }
			}
			if(  fCurrentVariable == NULL ) {
				sprintf( gMsgStr,"Config file error: Unknown Variable %s in Module %s configured with command %s(...) ", Name().chars(), fCurrentModule->Name(), Cmd().chars() );
				gPrintErr(); 
			} else if( (Cmd() != "ip") && (Cmd() != "i") ) {
				sprintf( gMsgStr,"Config file error: Variable %s::%s configured with command %s(...) in wrong Module (%s)", mod->Name(), Name().chars(), Cmd().chars(), fCurrentModule->Name() );
				gPrintErr(); 
			}
			return 0; 
		}
    fCurrentVariable->Config(*this);
  } 
  else if( GetObjectType() == kExternal ) {
		if( fCurrentModule == NULL ) {
			if( !Model::I0().ConfigExternal( *this, fCurrentModule ) ) { gPrintErr( Name(1) + ": Can't find External Module."); return 0; }
		} else {
			if( !fCurrentModule->ConfigExternal( *this, fCurrentModule ) ) { gPrintErr( Name() + ": Can't find External Module."); return 0; }		
		}
  }
  return 1;
}

void CnfgProcessor::Read()
{
  gPrintScreen("Reading config file"); 
  int tst, reset = 1;

  while( (tst = ReadCmd(reset)) >= 0 ) {
	if( reset == 1 ) { reset = 0; }
    if( gDebug > 1 ) Dump(tst);
    GetDataFromConfig();
  }
}

void CnfgProcessor::Dump(int status) {
  sprintf(gMsgStr,"\n(%c,%d,%d)Cmd:%s->%s: %s[ ",
	  Info(kCInfo0),NArgs(),NLevel(),(const char*)Name(0),(const char*)Name(),(const char*)Cmd()); 
  gPrintLog();
  for(int i=0; i<NArgs(); i++) { 
    CString* s;
    if( s = Arg(i) ) {
      sprintf(gMsgStr," %s ",s->chars()); 
      gPrintLog(); 
    } 
  }
  sprintf(gMsgStr," ]: status %d ",status); gPrintLog();
}
