#ifndef __CnfgProcessor__
#define __CnfgProcessor__

#include "ConfigObjects.h"
typedef class Module Module;
typedef class Variable Variable;

class CnfgProcessor : public TCnfgReader  {

  Module* fCurrentModule;
  Variable* fCurrentVariable;

  int GetDataFromConfig();
  void Dump(int status);

public:

  enum ECObjectType { kModel, kModule, kVariable, kExternal, kUnknown };

  CnfgProcessor( const char* filename ) :   TCnfgReader( filename ) 
    { fCurrentModule = NULL; fCurrentVariable = NULL; }
  CnfgProcessor() :   TCnfgReader() 
    { fCurrentModule = NULL; fCurrentVariable = NULL; }

  void Read();
  
  inline ECObjectType GetObjectType() {
		ECObjectType type = kUnknown;
		switch(fObjectIndex) {
			case 0: type = kModel; break;
			case 1: type = kModule; break;
			case 2: type = kVariable; break;
			case 3: type = kVariable; break;
			case 4: type = kExternal; break;
		}
		return type;
	}
	
};

#endif
