//----------------------------------------------------------------------------------------
//      Config.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History
//----------------------------------------------------------------------------------------

#ifndef __Config__
#define __Config__
  
#include "Utilities.h"
#include "SList.h"
#include "StringPlex.h"

//----------------------------------------------------------------------------------------
//						TConfigData
//----------------------------------------------------------------------------------------

#define kCMaxPackSize 512

enum EConfigInfo { kCInfo0, kCInfo1,  kCInfo2,  kCInfo3, kCInfo4, kCInfo5,  kCInfo6,  kCInfo7  }; 
 
class TConfigData {

protected:

  char fPackBuf[kCMaxPackSize];
  ArgArray fCArg;
  ArgArray fName;
  CString fComment;
  byte fInfo[8];
  int fNArgs;
  int fLevelIndex;
  int fStatus;

public:

  enum EStatus { kRequired, kOPtional, kCheckFor };
  enum EInfo { fData0, fData1, fData2, fData3, kNewObject, kProcessed, kNArgs, kStatus  };

  TConfigData ()  { fNArgs = 0; memset(fInfo,0,8); fLevelIndex=0; fStatus=-1; }
  int Pack();
  void UnPack();
  int addToString( CString& str );
  inline int NArgs() { return fNArgs; }
  inline int HasArg( int index ) {
    CString* a = Arg((unsigned int)index);
    return ( a && (a->length() > 0) ); 
  }
  inline int NLevel() { return fLevelIndex; }
  inline const CString& Name( int index ) const { return fName[index]; }
  inline CString& SName( int index ) { return fName.elem(index); }
  inline const CString& Name() const { return fName[fLevelIndex]; }
	inline CString& SName() { return fName.elem(fLevelIndex); }
  inline const CString& Cmd() const { return fName[fLevelIndex+1]; }
  inline CString& SCmd() { return fName.elem(fLevelIndex+1); }
  inline byte Info(EConfigInfo index) { return fInfo[index]; }

  CString* Arg( int index, EStatus status = kOPtional );
  int IntArg( int index, int& arg, EStatus status = kOPtional );    
  int FloatArg( int index, float& arg, EStatus status = kOPtional );

  inline void Process() { fInfo[kProcessed] = 1; }
  inline int Processed() { return fInfo[kProcessed]; }
  inline void Reset() { fInfo[kProcessed] = 0; }
  inline void SetCmd( const char* cmd, int lIndex=0 ) { fLevelIndex=lIndex; fName.elem(fLevelIndex+1) = cmd; }
  inline void SetArg( int index, const char* arg ) { fNArgs = index+1; fCArg.elem(index) = arg; }
	inline CString&  Comment() { return fComment; }
};


//----------------------------------------------------------------------------------------
//						TCnfgReader
//----------------------------------------------------------------------------------------

enum EConfigDocType  { kMMLConfig, kCGConfig,  kRunTimeConfig };		

class TCnfgReader : public TConfigData {
 
  private:
  
  	char fTerm[8];
	int fNTerm;
	char fCnfg;
	FILE* fCnfgFile;

	int isTerm(char ch);
	int SkipCSpace(char& tch);
	int ReadArg( CString& s, char& ch );
	int ReadEnvVar( CString& s );
	int ParseConfig(int reset);
	int BracketType(char ch);

  protected:

	int fObjectIndex;
	inline byte NewObject() { return fInfo[kNewObject]; }

  public:  

  	TCnfgReader();
  	TCnfgReader( const char* filename ) { Open( filename ); } 
	int Open( const char* filename, const char* ctrlChars, int NCtrl );
	inline int Open( const char* filename ) {
	  char c[] = {'#','$','*','@','~'}; 
	  return Open(filename,c,5); 
	}
        void Close();
  	~TCnfgReader();

  	int ReadCmd( int reset );
};


typedef TConfigData CD;

#endif



