//----------------------------------------------------------------------------------------
//      ConfigObject.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History
//----------------------------------------------------------------------------------------

#ifndef __ConfigObject__
#define __ConfigObject__
  
#include "Utilities.h"
#include "SList.h"
#include "StringPlex.h"
#include "Config.h"
#include "CStream.h"
#include "MML_Pipe.h"

//----------------------------------------------------------------------------------------
//						TConfigObject
//----------------------------------------------------------------------------------------

const byte kNoConfig = 255;
const byte kDefaultConfig = 0;

class TConfigObject : public TNamedObject { 

protected:
    byte fConfigInfo[8] ;

public:

    enum ECObjectType { kUnknown, kModel, kModule, kVariable, kObject, kFunction };

    TConfigObject ( const char* name, byte cobjtype, int index=0 ) : TNamedObject(index,name) { memset(fConfigInfo,0,8); SetObjInfo( kO_Info3, cobjtype ); }

 //   inline byte& GetCInfo( EConfigInfo index)  { return fConfigInfo[index]; }
    inline byte GetCInfo( EConfigInfo index) const { return fConfigInfo[index]; }
    inline byte SetCInfo( EConfigInfo index, byte val)  {
			if( gDebug > 1 ) { sprintf(gMsgStr,"\n** Set Config Info for %s(%x) to %x ",Name(),index,val); gPrintLog(); } 
			return fConfigInfo[index] = val; 
		}
    inline byte GetType() { return GetObjInfo(kO_Info3); }

    inline virtual int Config(TConfigData& cd) {
      sprintf(gMsgStr,"\nWarning, Unrecognized Config Cmd for %s: Nargs = %d, CMD = %s",
	      Name(), cd.NArgs(), (const char*)cd.Cmd() );	
      gPrintScreen();
      return 0;
    }
    inline virtual int Initialize() { return 0; }
    inline virtual int Finalize() { return 0; }
    inline virtual int Execute() { return 0; }
    inline virtual int UStep() { return 0; }

    inline TConfigObject& operator= ( TConfigObject& f ) { 
      memcpy(fConfigInfo,f.fConfigInfo,8);
      return *this;
    }
};


#endif
