#ifndef _Externals_h_
#define _Externals_h_

#if __GNUG__ >= 2
#  pragma interface
#endif

#include "MML_Schedule.h"
#include "PixPlex.h"

#ifdef OM3
extern "C" {
#include "om3.h"
}
#endif

typedef class Variable Variable;

class EVarLink : public TNamedObject {
public:  
  enum EModality { kIn, kOut, kInOut, kInitIn, kInitOut };
private:
  Variable* _var;
  EModality _modality;
public:
  EVarLink( const char* name, Variable* v,  EModality modality ) ;
  EVarLink( const char* name, Variable* v,  CString* modality ) ;
  inline Variable* getVar() { return _var; }
  inline EModality getModality() { return _modality; }
  int is_applicable( EModality modality_context );
  Bool isInput();
};

#include "MML_Variable.h"

class ALRec : public TObject {
  PixXPlex  _external_var_links;
  int _layer_index;   

  public:
  
  ALRec( int layer_index  ) { _layer_index = layer_index; }
  
  PixXPlex& get_var_links() { return _external_var_links; }
  int get_AL() { return _layer_index; }
  inline void addLinkRec( EVarLink* link ) { _external_var_links.add_high(link); }
  EVarLink* getVarLink( const char* var_name, const char* module_name = NULL  );
  EVarLink* getVarLink( Variable* v );
};

class EModRec : public TNamedObject {
  PixXPlex _activationLayerRecs;
  int _activated;
  ArgArray _args;
  ExSchedule::ETimeUnit _unit;
  double _time;

  double translate_time_units( double time,  ExSchedule::ETimeUnit to_unit ); 

  public:
  
  EModRec( const char* mod_name, ArgArray& args  ) : _args(args), TNamedObject(mod_name)  { 
	_unit = ExSchedule::kUndefined;
	_activated = 1; _time=0;
  }
  EModRec( const char* mod_name  ) : TNamedObject(mod_name) { 
	_unit = ExSchedule::kUndefined; 
	_activated = 1;  _time=0;
  }
 
  PixXPlex& get_activationLayerRecs() { return _activationLayerRecs; }
  int activated() { return _activated; }
  void deactivate() { if( _activated == 2) { _activated = 3; } }
  ALRec*  get_ALRec( int layer_index  );
  int  update_variables( EVarLink::EModality modality, Module* m, Variable* var );
  int has_Externals( EVarLink::EModality modality, Module* m, Variable* var  );
  void WriteDataToConfig( CStream& outStream, Variable* var=NULL );
  int init();
  int run( double end_time );
  int finalize();
};

class Externals {

  static PixXPlex _EModRecs;

  public:
       
  static EVarLink* register_variable_link( const char* ext_mod_name, const char* ext_var_name, Variable* var, CString *modality  );
  

  static EModRec*  get_EModRec( const char* ext_mod_name, Bool create = False, ArgArray* args=NULL  );
  static EVarLink* get_VarLink( Variable* v, const char* ext_mod_name = NULL ) ;
    
  static inline ALRec* get_ALRec( const char* ext_mod_name, int layer_index ) {
	EModRec* emr = get_EModRec( ext_mod_name );
	return (emr==NULL) ? NULL : emr->get_ALRec(  layer_index  );
  }
  
  static int   initialize_module( const char* name, ArgArray* args=NULL, Bool exec_init= False );
  static void  run( double end_time ) ;
  static void  finalize() ;
  
  static int  update_variables( EVarLink::EModality modality, Module* m=NULL, const char* ext_mod_name=NULL, Variable* var=NULL ); 
  static int   has_Externals( EVarLink::EModality modality, Module* m=NULL, const char* ext_mod_name=NULL, Variable* var=NULL ); 
  static void WriteDataToConfig( CStream& outStream, Variable* var=NULL );

   static int   get_partition_type() ;

  static int   get_partition_dim( int dimension ) ;

  static int   get_grid_dim( int dimension ) ;
  
  static inline int deactivate(const char* ext_mod_name) { 
	EModRec*  mr = get_EModRec( ext_mod_name ); 
	if( mr != NULL ) { mr->deactivate(); return 0; }
	return 1;
  }
  

};

//----------------------------------------------------------------------------------------
//						TExternalsUpdateCommand 
//----------------------------------------------------------------------------------------

class TExternalsUpdateCommand : public TCommand {

  EVarLink::EModality _modality;

public:

  TExternalsUpdateCommand( const CString& name, EVarLink::EModality modality, Variable* v = NULL  )  
    : TCommand(name,v)  { 
    SetObjInfo(kExType,kExternalUpdate); 
    _modality = modality;
  }
  virtual int Execute( Module* m = NULL ) { return Externals::update_variables( _modality, m , NULL, GetVar() ); }
  virtual void WriteMML( FILE* oFile, EWriteMode mode = kDefinition ) {;}
  virtual int GetModifierString( CString& name ) const  { return TCommand::GetModifierString(name); }
  virtual void Dump( FILE* oFile ){;}

  int AddModifier( const CString& mod, Bool isExtension = False ) { return 0;}
};
		
#endif
