//-*-Mode: C++;-*-
#ifndef _GOFCalc_h_
#define _GOFCalc_h_

#if __GNUG__ >= 2
#  pragma interface
#endif

#include "MML_Variable.h"

#ifdef HAS_MPE

#include "dfit.h"

class TConfiguration : public TNamedObject { 
protected:
    CString fValue;
public:
    TConfiguration ( const char* name, const char* value ) : TNamedObject(name) { fValue = value; }
    inline const char* Value() { return fValue.chars(); }
    inline CString& SValue() { return fValue; }
};

//---- GOFCalc -----------------------------------------------------------

enum ESearchType { kGrad,  kEvol };

class GOFCalc 
{
  static  DFit fDFit;
  static  TNamedObjectList  fVariableList;
  static  TNamedObjectList fParameterList;
  static  TNamedObjectList fConfigurationList;
  static ESearchType fSearchType;
  static int* fTopologyMap2[2];
  static int* fTopologyMap3[3];
  static float* fResults;
  static float fCurrentGOF;
  static float fParmIncrementWeight;
  static float fInitParmIncrementWeight;
  static float fMutProb;
  static float fCrossProb;
  static int fNCells;
  static int  fPopSize;
  static int* fNCellsProc;
  static int* fProcOffset;
  static int fOrder;
  static int fDefaultOrder;
  static int fMaxRefine;
  static int fRefineLevel;
  static float fRefinePct;
  static int fIter;
  static int fParameterIndex;
  static FILE* fLogFile;
  static CString fLogFileName;
  static CString fDisplayMode;
  
  static int getNCellsForOrder(int order, int np);
  static int getPSpaceCoordinateForOrder( int parameter_index, int dim, int order );
  static inline void createTopologyOffsets2() ;
  static inline void createTopologyOffsets3() ;
  static int moveParameterCentroid( int parameter_index );
  
public:


  static int updateParametersGA(); 
  static int initGA();

  static int registerParameter( Variable& v );  
  static int configureVariableTest( Variable& v, TConfigData& cd );
  static inline ESearchType getSearchType() { return fSearchType; } 
  static int evolve( int nGen );
  static int converge_genomes( float percent_genomes, int max_runs );
  static int initGradOptimizer( float fitness = -1 );
  static TNamedObjectList& ParameterList() { return fParameterList; }
  
  static int setVariableWeight( Variable& v, float val );
  static int configureGOF( const CString& method_name, TConfigData& cd );
  
  static int registerReferenceData( Variable& v, const CString& filename, int* cols );
  static int registerProperty( CString& property, CString& value );
  static int updateData();
  static void log( const char* msg, Bool flush = False );

  static int setOrder( int max_order );  
  
  static inline int getNCellsTotal() { 
	if( fOrder < 0 ) { setOrder(fDefaultOrder); }
	return fNCells; 
  }
  
  static inline int getNCells() { 
	if( fOrder < 0 ) { setOrder(fDefaultOrder); }
	return (fNCellsProc == NULL) ? 0 : fNCellsProc[gIProc]; 
  }
  static inline int getNIter() { return fIter; }
  static inline int getParameterIndex() { return fParameterIndex; }
 static inline CString& getDisplayMode() { return fDisplayMode; }

  static inline int getProcOffset( int iter ) { 
	fIter = iter;
	if( fOrder < 0 ) { setOrder(fDefaultOrder); }
	return (fProcOffset == NULL) ? 0 : fProcOffset[gIProc]; 
  }
    
  static int readReferenceData( Bool force = False );
  
  static int updateParameters( int parameter_index );
  static int calcGOF( int parameter_index, int iteration );
  static float getFitness();
  static int plotVariables( const char* label, Bool doRef = False );
  static int optimize(int iter);
  static inline float getGOFSensitivity( int parameter_index ) { return fabs(fResults[ parameter_index ] - fResults[ 0 ]); } 
  static int plotGOF(int p0, int p1, int s0=10, int s1=10 );

  
  static int getPSpaceCoordinate( int parameter_index, int dim );    
  static inline int getParameterIndex( int dim ) { return (1 + dim*2); }    
  
  static int printParameters( Bool showSensitivity = True );
  static int printGenomes();
  static inline void verbose(Bool v) { fDFit.verbose(v); }
  static int refineSearch(); 
  static int allocateResults( int size );
  static float parmIncrementWeight() { return fParmIncrementWeight; }

  static inline int getTopology() { return (int) fSearchType; }    
  
  
  
};

#endif
#endif
