#include "MML_Connection.h"
#include "MML_Module.h"
#include "MML_Model.h"
#include "MML_Variable.h"

//========================================================================================
// 				CLASS TConnection
//========================================================================================

TConnection::TConnection( const char* name ) : TNamedObject(name) { 
    fMod0 = NULL;
    fMod1 = NULL;
    fVar0 = NULL;
    fVar1 = NULL;
} 

//----------------------------------------------------------------------------------------
//						TConnection::TConnection
//----------------------------------------------------------------------------------------

void TConnection::IConnection( Module* module0, Variable* variable0, Module* module1, Variable* variable1 ) { 
  fMod0 = module0;
  fMod1 = module1;
  fVar0 = variable0;
  fVar1 = variable1;
  if( fVar0 && fMod0 ) fNodeName0 = fMod0->SName() + "::" + fVar0->Name(); else fNodeName0 = "NULL";
  if( fVar1 && fMod1 ) fNodeName1 = fMod1->SName() + "::" + fVar1->Name(); else fNodeName1 = "NULL";
}

//----------------------------------------------------------------------------------------
//						TConnection::Add
//----------------------------------------------------------------------------------------

void TConnection::Add( Module* module0, Variable* variable0, Module* module1, Variable* variable1 ) { 
  fMod0 = module0;
  fMod1 = module1;
  fVar0 = variable0;
  fVar1 = variable1;
  if( fVar0 && fMod0 ) fNodeName0 = fMod0->SName() + "::" + fVar0->Name(); else fNodeName0 = "NULL";
  if( fVar1 && fMod1 ) fNodeName1 = fMod1->SName() + "::" + fVar1->Name(); else fNodeName1 = "NULL";
}

//----------------------------------------------------------------------------------------
//						TConnection::operator=
//----------------------------------------------------------------------------------------

TConnection& TConnection::operator= (const TConnection& x) {
  fVar0 = x.fVar0;
  fVar1 = x.fVar1;
  fMod0 = x.fMod0;
  fMod1 = x.fMod1;
  if( fVar0 && fMod0 ) fNodeName0 = fMod0->SName() + "::" + fVar0->Name(); else fNodeName0 = "NULL";
  if( fVar1 && fMod1 ) fNodeName1 = fMod1->SName() + "::" + fVar1->Name(); else fNodeName1 = "NULL";
  return *this;
}

//----------------------------------------------------------------------------------------
//						TConnection::Equals
//----------------------------------------------------------------------------------------

int TConnection::NodeEquals (int NodeIndex, const char* modName, const char* varName) {
  if(NodeIndex == 0) {
    if( fVar0 && fVar0->SName() == varName && fMod0->SName() == modName  )  
      return 1; 
    else return 0;
  }
  else {
    if( fVar1 && fVar1->SName() == varName && fMod1->SName() == modName  )    
      return 1; 
    else return 0;
  }		
}

int TConnection::NodeEquals (int NodeIndex, const CString modName, const CString varName) {
  if(NodeIndex == 0) { 
    if( fVar0 && fVar0->SName() == varName && fMod0->SName() == modName  )   
      return 1; 
    else return 0;
  }
  else {
    if( fVar1 && fVar1->SName() == varName && fMod1->SName() == modName  )    
      return 1; 
    else return 0;
  }		
}
const char* TConnection::NodeName (int NodeIndex) const {
  if(NodeIndex == 0) { return (const char*)fNodeName0; }
  else { return (const char*)fNodeName1; }
}

Variable* TConnection::NodeVar (int NodeIndex) {
  Variable* rv;
  if(NodeIndex == 0) rv = fVar0;
  else rv = fVar1;
  return rv;
}

Module* TConnection::NodeMod (int NodeIndex) {
  Module* rv;
  if(NodeIndex == 0) rv = fMod0;
  else rv = fMod1;
  return rv;
}

int TConnection::ProcessCommand(const TCommandNode* n) { return 0; }

int TConnection::ProcessAttribute(const TAttributeNode* cn){
	const TDeclarationNode* dn = cn->Declaration();
	CString& cmd = (CString&) dn->Command();
	const TNode* vn = cn->Value();
	cmd.downcase();
	int rv = 0;
	
  if( cmd == "origin" ) {
		if( GetAttrValue( vn, kAVString, kAVString2 ) ) {
			const CString* s = fAttrValue;
			if( s )  {  rv = AddNode( s, kOrigin );  }
		}		
  }
  else if( cmd  == "destination" ) {
		if( GetAttrValue( vn, kAVString, kAVString2 ) ) {
			const CString* s = fAttrValue;
			if( s )  {  rv = AddNode( s, kDestination );  }
		}
  } 
  return rv;
}
 
void TConnection::WriteMML( FILE* oFile, EWriteMode mode )  { 
  if( fVar1 == NULL ) return;
  if( fVar1->GetF(FDualConnection) ) {
		fprintf( oFile, "\tdual Connection %s { \n\t\tOrigin = %s;\n\t\tDestination =  %s;\n\t}\n", 
	   Name(), (const char*)fNodeName0, (const char*)fNodeName1 );
	} else {
		fprintf( oFile, "\tConnection %s { \n\t\tOrigin = %s;\n\t\tDestination =  %s;\n\t}\n", 
	   Name(), (const char*)fNodeName0, (const char*)fNodeName1 );
	} 
}

void TConnection::WriteXML( FILE* oFile ) { 
  if( fVar1 == NULL ) return;
  if( fVar1->GetF(FDualConnection) ) {
		fprintf( oFile, "\n\t<link name=\"%s\" type=\"dual\" origin = \"%s.%s\" destination =  \"%s.%s\" />", 
	   Name(), fMod0->Name(),fVar0->Name(), fMod1->Name(),fVar1->Name() );
	} else {
		fprintf( oFile, "\n\t<link name=\"%s\" origin = \"%s.%s\" destination =  \"%s.%s\" />", 
	   Name(), fMod0->Name(),fVar0->Name(), fMod1->Name(),fVar1->Name() );
	} 
}

void TConnection::WriteCCode( FILE* CHdrFile, FILE* CEqnFile) {
  if(fVar0) {
		if( fVar1->GetF(FDualConnection) ) {
			fprintf(CEqnFile,"\n\t%s::I().%s.Connect(&(%s::I().%s),True);",
					fMod1->Name(),fVar1->Name(),fMod0->Name(),fVar0->Name());
		} else {
			fprintf(CEqnFile,"\n\t%s::I().%s.Connect(&(%s::I().%s));",
					fMod1->Name(),fVar1->Name(),fMod0->Name(),fVar0->Name());
		}
	}
  else fprintf(CEqnFile,"\n\t%s::I().%s.Connect(NULL);",fMod1->Name(),fVar1->Name());
}

int TConnection::AddNode( const CString* v, ENodeType type )
{
  CString VarName[3], *var, *mod;
  CString sep;
  if( v->contains("::") ) { sep = "::"; }
  else { sep = "."; }
  Module *aMod = NULL;
  Variable *aVar = NULL;

  if( gDebug) fprintf(Env::LogFile(),"\nAdded Node(%x) to Connection %s: (%s)", type, Name(), (char*)v );

  if( *v != "NULL" ) {
	int nelem = split( *v, VarName, 3, sep);
	if( ExprBuilder::GetMode() == ExprBuilder::kSMML ) {
	  mod = &VarName[0];
	  var = &VarName[1]; 
	  if( ( *mod == "this" ) || ( *mod == fParent->SName() ) ) { return 0; } 
	  if(  *var == "out" ) { return 0; } 
	} else {
	  switch( nelem ) {
	  case 1: var = &VarName[0]; mod = NULL; break;
	  case 2: var = &VarName[1]; mod = &VarName[0]; break;
	  case 3: var = &VarName[2]; mod = &VarName[1]; break;
	  }
	}
	if( mod ) {
		aMod = Model::I0().GetModule(*mod,False);
		if( aMod == NULL ) {
			sprintf(gMsgStr," Can't find Module in TConnection::AddNode: %s", mod->chars() ); gPrintLog();
			return 0;
		}
	} else {
		sprintf(gMsgStr," No Module specified in TConnection::AddNode: %s", v->chars() ); gPrintLog();
		return 0;
	}
	aVar = aMod->GetVariable(*var);
  } 

  if( type == kOrigin ) {
    if( aVar ) aVar->FlagExport();
    fMod0 = aMod;
    fVar0 = aVar;
    fNodeName0 = *v;
  } else {
    if( aVar ) aVar->FlagImport();
    fMod1 = aMod;
    fVar1 = aVar;
    fNodeName1 = *v;  
  }
  return 1;
}

//========================================================================================
// 				CLASS TConnectionList
//========================================================================================

TConnectionList::TConnectionList() {fModule = NULL;}

TConnectionList::TConnectionList( Module* aModule ) { fModule = aModule; }

//----------------------------------------------------------------------------------------
//						TConnectionList::AddConnection
//----------------------------------------------------------------------------------------


void TConnectionList::AddConnection( CString* v0, CString* v1 )
{
  CString VarName0[3], *var0=NULL, *mod0=NULL;
  CString VarName1[3], *var1=NULL, *mod1=NULL;
  CString sep = "::";

  Module *aMod0=NULL,  *aMod1=NULL;
  Variable *aVar0=NULL,  *aVar1=NULL;

  if( gDebug) fprintf(Env::LogFile(),"\nAdded Connection: (%s, %s)", (char*)v0, (char*)v1 );

  if( *v0 != "NULL" ) {
    int nelem = split( *v0, VarName0, 3, sep);
    switch( nelem ) {
    case 1: var0 = &VarName0[0]; mod0 = NULL; break;
    case 2: var0 = &VarName0[1]; mod0 = &VarName0[0]; break;
    case 3: var0 = &VarName0[2]; mod0 = &VarName0[1]; break;
    }
    aMod0 = (mod0) ? Model::I0().GetModule(*mod0) : fModule;
    aVar0 = aMod0->GetVariable(*var0);
  }
  if( *v1 != "NULL" ) {
    int nelem = split( *v1, VarName0, 3, sep);
    switch( nelem ) {
    case 1: var1 = &VarName1[0]; mod1 = NULL; break;
    case 2: var1 = &VarName1[1]; mod1 = &VarName1[0]; break;
    case 3: var1 = &VarName1[2]; mod1 = &VarName1[1]; break;
    }
    aMod1 = (mod1) ? Model::I0().GetModule(*mod1) : fModule;
    aVar1 = aMod1->GetVariable(*var1);
  }
  CString name = "c" + length();
  TConnection c(name);
  c.IConnection( aMod0, aVar0, aMod1, aVar1 );
  append(c);
  if(aVar1) aVar1->FlagImport();
  if(aVar0) aVar0->FlagExport();

} 


//----------------------------------------------------------------------------------------
//						TConnectionList::AddConnection
//----------------------------------------------------------------------------------------


void TConnectionList::AddConnection( Module* aMod0, Variable* aVar0, Module* aMod1, Variable* aVar1 )
{
  CString name = "c" + length();
  TConnection c(name);
  c.IConnection( aMod0, aVar0, aMod1, aVar1 );
  append(c);
  if(aVar1) aVar1->FlagImport();
  if(aVar0) aVar0->FlagExport();
} 

//----------------------------------------------------------------------------------------
//						TConnectionList::GetConnection
//----------------------------------------------------------------------------------------

const char* TConnectionList::GetConnection(int nodeIndex, const CString&  modName, const CString&  varName ) {
  int nIndex1 = (nodeIndex>0) ? 0 : 1;
  for( Pix p = first(); p; next(p) ) {
    TConnection& c =(TConnection&) (*this)(p);
    if( c.NodeEquals(nodeIndex,modName,varName) ) 
      return c.NodeName(nIndex1);
  }
  return NULL;	
}

//----------------------------------------------------------------------------------------
//						TConnectionList::GetConnection
//----------------------------------------------------------------------------------------

TNamedObject* TConnectionList::GetConnection(const CString&  modName, const CString&  varName, ELevel  type ) {
  for( Pix p = first(); p; next(p) ) {
    TConnection& c = (TConnection&) (*this)(p);	
    if( c.NodeEquals(0,modName,varName) ) {
      if( type == kVar ) return c.NodeVar(1);
      else if ( type == kMod ) return c.NodeMod(1);
      else gProgramBreak("Illegal Object Type in GetConnection.");
    }
    if( c.NodeEquals(1,modName,varName) ) {
      if( type == kVar ) return c.NodeVar(0);
      else if ( type == kMod ) return c.NodeMod(0);
      else gProgramBreak("Illegal Object Type in GetConnection.");
    }
  }
  return NULL;	
}

//----------------------------------------------------------------------------------------
//				TConnectionList::WriteMML:
//----------------------------------------------------------------------------------------

void  TConnectionList::WriteMML( FILE* oFile ) {
  for( Pix p = first(); p; next(p) ) {
    TConnection& c = (TConnection&) (*this)(p);
    c.WriteMML(oFile);
  }
}


