//----------------------------------------------------------------------------------------
//	Connection.h;
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.;
//	Change History:;
//----------------------------------------------------------------------------------------;
  
#ifndef __MML_Connection__
#define __MML_Connection__

#include "Globals.h"
#include "MML.h"
#include "ConfigObjects.h"
#include "DLnkList.h"

typedef class Variable Variable;
typedef class Module Module;

//----------------------------------------------------------------------------------------
//						TConnection
//----------------------------------------------------------------------------------------

class TConnection : public TNamedObject, public MMLObject {  // describes a connection from mod0->var0 to mod1->var1;	

  CString fNodeName0;
  CString fNodeName1;

  Variable* fVar0;  
  Module*  fMod0;

  Variable* fVar1;  
  Module*  fMod1;
  
  Module*  fParent;

public:

  enum ENodeType { kOrigin, kDestination };

  TConnection( const char* name );
  void IConnection( Module* module0, Variable* variable0, Module* module1, Variable* variable1 );
  void Add( Module* module0, Variable* variable0, Module* module1, Variable* variable1 );
  TConnection& operator= (const TConnection& x);

  int operator== (const TConnection& x) {
    if( fVar0 == x.fVar0 && fVar1 == x.fVar1 && fMod0 == x.fMod0 && fMod1 == x.fMod1 ) return 1;
    else return 0;		
  }
	
  int operator>= (const TConnection& x) {
    if( fMod1 == x.fMod1 && fVar1 == x.fVar1 ) return 1;
    else return 0;		
  }
	
  int operator<= (const TConnection& x) {
    if( fVar0 == x.fVar0 && fMod0 == x.fMod0 )  return 1;
    else return 0;		
  }
  
  int Valid() { return ( (fVar0 != NULL) && (fMod0 != NULL) && (fVar1 != NULL) && (fMod1 != NULL) ); }
  int NodeEquals (int NodeIndex, const char* modName, const char* varName); 
  int NodeEquals (int NodeIndex, const CString modName, const CString varName); 
  const char* NodeName (int NodeIndex) const ;
  Variable* NodeVar (int NodeIndex);
  Module*   NodeMod (int NodeIndex);
  inline void SetParent(Module*  parent) { fParent = parent; }

  void WriteMML( FILE* oFile, EWriteMode mode = kDefinition ); 
  void WriteXML( FILE* oFile ); 
   virtual int AddModifier( const CString& mod, Bool isExtension = False) { return 0;}
  virtual void Dump( FILE* oFile ){ WriteMML( oFile ); }

  virtual int ProcessCommand(const TCommandNode* n);
	virtual int ProcessAttribute(const TAttributeNode* n);

  virtual int GetModifierString( CString& name ) const { return 0;}
  int AddNode( const CString* v, ENodeType type );
  virtual void WriteCCode( FILE* CHdrFile, FILE* CEqnFile);

}; 
  
class TConnectionList  : public TNamedObjectList
{
private: 
  Module* fModule;      
public:
  enum ELevel { kVar, kMod };

  TConnectionList();
  TConnectionList( Module* aModule );

  void IConnectionList( Module* aModule ) { fModule = aModule; }

  void AddConnection( CString* v0, CString* v1 );
  void AddConnection( Module* aMod0, Variable* aVar0, Module* aMod1, Variable* aVar1 );
  const char* GetConnection(int nodeIndex, const CString&  modName, const CString& varName );
  TNamedObject* GetConnection( const CString&  modName, const CString&  varName, ELevel type  );
  virtual void WriteMML( FILE* oFile );
  virtual void Dump( FILE* oFile ){ WriteMML( oFile ); }
};

#endif
