#include "ExprBuilder.h"
#include "Environ.h"
#include "MML_Model.h"
#include "MML_Module.h"
#include "MML_Variable.h"
#include "MML_Function.h"
static int array_error_count = 0;

//----------------------------------------------------------------------------------------
  //						 TConstant
  //----------------------------------------------------------------------------------------

TNamedObjectList TConstant::fConstantList;

TConstant* TConstant::New( const CString& name ) { 
	TConstant* f = new TConstant(name); 
	fConstantList.append(*f);
	return f;
}

int TConstant::ProcessAttribute(const TAttributeNode* an) {
	const TDeclarationNode* dn = an->Declaration();
	const TNode* vn = an->Value();
	const CString& cmd = dn->Command();
	const ArgArray&  ql = dn->QualifierList()->List();

	CString c( downcase(cmd) );
	if( c == "library" ) { 
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) {
				fLibrary = *s;
				fHasLibrary = 1;
			}
		}
	} else if( c == "translation" ) { 
		if( GetAttrValue( vn, kAVUnknown ) ) {
			const CString* s = fAttrValue;
			if(s) fTranslation = *s;
		}
	}  else if( c == "type" ) { 
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) {
				const CString dcs ( downcase(*s) );
				if( dcs == "function" ) fFunctionCall = 1;
			}
		}
	} else if( c == "dynamic" ) { 
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) {
				const CString dcs ( downcase(*s) );
				if( dcs == "true" ) fDynamic = 1;
			}
		}
	} 
	else return 0;
	return 1;
}

TConstant* TConstant::GetConstant( const char* name, const char* library ) {
	for( Pix p = fConstantList.first(); p; fConstantList.next(p) ) {
		TConstant& f = (TConstant&) fConstantList(p);
		if( f.SName() == name ) {
			if( library == NULL ) return &f;
			else if ( f.fHasLibrary && (f.Library() == library) ) return &f;
		}
	}
	return (TConstant*)NULL; 
}

void TConstant::WriteCCode( TCommand* c, CString& s ) { 
	
	if(fHasLibrary) { s+=fLibrary; s+="::"; }
	s+=fTranslation;
	if(fFunctionCall) { s+="()"; }
}
//----------------------------------------------------------------------------------------
  //						 TFunction
  //----------------------------------------------------------------------------------------

TNamedObjectList TFunction::fFunctionList;

TFunction* TFunction::New( const CString& name ) { 
	TFunction* f = new TFunction(name); 
	fFunctionList.append(*f);
	return f;
}

void TFunction::SetAttributes(CString& library, char* functionCode, CString& translation, EFunctionSource source, int nargs) {
 fLibrary = library;
 fFunctionCode = functionCode;
 fTranslation = translation;
 fNReqArgs = fNMaxArgs = nargs;
 fSource = source;
}

int TFunction::ProcessAttribute(const TAttributeNode* an) {
	const TDeclarationNode* dn = an->Declaration();
	const TNode* vn = an->Value();
	const CString& cmd = dn->Command();
	const ArgArray&  ql = dn->QualifierList()->List();

	CString c( downcase(cmd) );
	if( c == "library" ) { 
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) fLibrary = *s;
		}
	} else if( c == "functioncode" ) {  
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) fFunctionCode = *s;
		}		
	} else if( c == "translation" ) { 
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) fTranslation = *s;
		}
	} else if( c == "derivative" ) { 
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) fDerivative = *s;
		}
	} else if( c == "source" ) { 
		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) {
				if( tolower((*s)[0]) == 's' ) { fSource = kFS_SMELib; }
				else  { fSource = kFS_UserLib; }
			}
		}
	} else if( c == "nargs" ) { 
		if( ql.Contains("required") ) {
			if( GetAttrValue( vn, kAVInt ) ) {
				fNReqArgs = fAttrValue;
			}
		} else {
			if( GetAttrValue( vn, kAVInt ) ) {
				fNMaxArgs = fAttrValue;
			}
		}
	}
	else return 0;
	return 1;
}

TFunction* TFunction::GetFunction( const char* name, const char* library, EFunctionSource source ) {
	for( Pix p = fFunctionList.first(); p; fFunctionList.next(p) ) {
		TFunction& f = (TFunction&) fFunctionList(p);
		if( f.fSource == kFS_SMELib ) {
			if( ( f.Translation() == name ) && ( f.Library() == library ) && ( f.fSource == kFS_SMELib ) ) return &f;
			if( ( f.SName() == name ) && ( f.Library() == library ) && ( f.fSource == kFS_SMELib ) ) return &f;
		} else {
			if( f.SName() == name ) return &f;
		}
	}
	return (TFunction*)NULL; 
}

void TFunction::WriteMMLRegistration(FILE* f) const { 
	fprintf(f,"\nFunction %s {",Name());
	fprintf(f,"\n\tLibrary = %s;",fLibrary.chars());
	if( fSource == kFS_SMELib ) {  fprintf(f,"\n\tSource = SME;"); } 
	else { fprintf(f,"\n\tSource = User;"); }	
	fprintf(f,"\n\tFunctionCode = %s;",fFunctionCode.chars());
	fprintf(f,"\n\tTranslation = %s;",fTranslation.chars());
	fprintf(f,"\n\trequired NArgs = %d;",fNReqArgs);
	fprintf(f,"\n\tmax NArgs = %d;",fNMaxArgs);
	fprintf(f,"\n}\n");				

}

void TFunction::WriteCCode(TCommand* c, CString& s,   TListNode* arg, int isGlobal, int wContext ) { 
	const TOrderedObjectDLList& al = arg->List();
	
	if( fFunctionCode[1] == 'M' ) {
		Pix p = al.first();
		TNode* n = (TNode*) &al(p);
		if( n->NodeType() != TNode::kVar ) { gFatal(c->Var()->SName() + ": method argument 1 not a Variable in equation\n"); }
		TVarNode* vn = (TVarNode*)n;
		Variable* var = vn->GetVariable(); 
		if( var == NULL )  { gFatal(c->Var()->SName() + ": Unknown variable for method in equation\n"); }
		n->WriteCCode(c,s,isGlobal,1); 
		s+=".";  s+=fTranslation; s+="( ";
		if( fFunctionCode[0] == 'a' ) {
		  ArgArray* ml = vn->GetMapList(); 
		  int is_dimension_name, index; 
		  if( c->CodeGenMode() < 2 ) { s += "p,"; }
		  for( int iarg=0; iarg < ml->NArgs(); iarg++ ) {
			CString& arg = ml->elem(iarg);
			if( iarg > 0 ) { s += ","; }
			if( arg == "*" ) {
			  s += "kA__Wildcard";
			} else {
			  ArrayRec* ar = Model::I0().getArrayDeclaration( arg, index, is_dimension_name ); 
			  if( ar == NULL ) {
				if (array_error_count++ < 8 ) {
					gPrintErr( format("Unrecognized Array argument %d: %s in Variable %s (TFunction::WriteCCode)", index, arg.chars(), var->Name() ));
				}
			  } else {
				if( is_dimension_name  ) {
				  s += format("kA__%s",arg.chars());	
				} else {
				  s +=  format("kA__%s",arg.chars());				
				}
			  }
			}
		  }
		} else {
		  ArrayRec* ar = var->getArrayDeclaration( 0 );
		  if( ar ) { s+=" array_index, "; }
		  if( c->CodeGenMode() < 2 ) { s+=" p, "; }
		  int first = 1;
		  while( al.next(p) ) { 
			  n = (TNode*) &al(p); 
			  if( !first ) { s+=", "; first=0; }
			  n->WriteCCode(c,s,isGlobal,1); 
		  }
		}
		s+=" )";
	} else {
		if( fFunctionCode[0] == 'G' || (fSource == kFS_UserLib) ) { s+=fTranslation; }
		else { s+=fLibrary; s+="::"; s+=fTranslation; }
		s+="("; arg->WriteCCode(c,s,isGlobal,wContext); 	s+=")";
	}
}

void TFunction::WriteDCode(TCommand* c, CString& s,  TListNode* arg, int isGlobal, int wContext ) { 
	
	if( fFunctionCode[1] == 'M' ) {
		const TOrderedObjectDLList& al = arg->List();
		Pix p = al.first();
		TNode* n = (TNode*) &al(p);
		if( n->NodeType() != TNode::kVar ) { gFatal(c->Var()->SName() + ": Illegal delay argument 1 in equation\n"); }
		TVarNode* vn = (TVarNode*)n;
		Variable* var = vn->GetVariable(); 
		if( var == NULL )  { gFatal(c->Var()->SName() + ": Unknown delay argument 1 in equation\n"); }
		n->WriteDCode(c,s,isGlobal,1); 
		s+=".";  s+=fDerivative; s+="( ";
		if( c->CodeGenMode() < 2 ) { s+=" p, "; }
		int first = 1;
		while( al.next(p) ) { 
			n = (TNode*) &al(p); 
			if( !first ) { s+=", "; first=0; }
			n->WriteCCode(c,s,isGlobal,1); 
		}
		s+=" )";
	} else {
		if( fFunctionCode[0] == 'G' || (fSource == kFS_UserLib) ) { s+=fDerivative; }
		else { s+=fLibrary; s+="::"; s+=fDerivative; }
		s+="("; arg->WriteDCode(c,s,isGlobal,wContext); 	s+=")";
	}
}
