//----------------------------------------------------------------------------------------
//      MML_Function.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------
  
#ifndef __MML_Function__
#define __MML_Function__

#include "SList.h"
#include "Utilities.h"
#include "MML.h"
#include "ConfigObjects.h"

typedef class TListNode TListNode;
typedef class TCommand TCommand;
//----------------------------------------------------------------------------------------
  //						 TConstant
  //----------------------------------------------------------------------------------------

class TConstant : public MMLObject, public TNamedObject { 
	CString fTranslation;
	CString fLibrary;
	static TNamedObjectList fConstantList;
	Bool fFunctionCall;
	Bool fHasLibrary;
	Bool fDynamic;

public:
	TConstant(const char* name ) : TNamedObject ( name ) { fFunctionCall=0; fHasLibrary=0; fDynamic=0; }
	void WriteMML(CString& s) const { s+=SName(); }
	virtual void WriteCCode( TCommand* c, CString& s  ) ;
	
	static TConstant* GetConstant( const char* name, const char* library = NULL ) ;
	static TConstant* New( const CString& name );
	inline CString&  Library() { return fLibrary; }
	inline Bool Dynamic() { return fDynamic; }
	int ProcessAttribute(const TAttributeNode* an);
	virtual void WriteMML( FILE* oFile, EWriteMode mode = kDefinition ) {;}
};

//----------------------------------------------------------------------------------------
  //						 TFunction
  //----------------------------------------------------------------------------------------

enum EFunctionSource { kFS_UserLib, kFS_SMELib };

class TFunction : public TConfigObject, public MMLObject { 
	CString fTranslation;
	CString fLibrary;
	CString fDerivative;
	int fNReqArgs;
	int fNMaxArgs;
	CString fFunctionCode;
	EFunctionSource fSource;
	
	static TNamedObjectList fFunctionList;

public:
	TFunction(const char* name ) : TConfigObject ( name, kFunction ) { fNReqArgs = 0; fNMaxArgs = 0; fSource = kFS_SMELib; }
	void WriteMML(CString& s) const { 
		if( fSource == kFS_SMELib ) { s+=fLibrary; s+="::"; }
		s+=fTranslation; 
	}
	void WriteMMLRegistration(FILE* f) const ;
	
	virtual void WriteCCode(TCommand* c, CString& s,   TListNode* arg, int isGlobal=0, int wContext=0  ) ;
	virtual void WriteDCode(TCommand* c, CString& s,  TListNode* arg, int isGlobal=0, int wContext=0  ) ;
	inline int Differentiable() { return !fDerivative.empty(); }
	
	static TFunction* GetFunction( const char* name, const char* library, EFunctionSource source = kFS_SMELib ) ;
	static TFunction* New( const CString& name );
	static TNamedObjectList& FunctionList() { return fFunctionList; }
	inline CString&  Library() { return fLibrary; }
	int ProcessAttribute(const TAttributeNode* an);
	void SetAttributes(CString& library, char* functionCode, CString& translation, EFunctionSource source, int nargs); 
	inline int CheckNArgs(int nargs) { return ( (fNMaxArgs >= nargs) && (fNReqArgs <= nargs) ); }
	virtual void WriteMML( FILE* oFile, EWriteMode mode = kDefinition ) {;}
	inline CString& FunctionCode() { return  fFunctionCode; }
	inline CString& Translation() { return fTranslation; }
	inline	EFunctionSource Source() { return fSource; }

};

#endif
