#include "MML_LUT.h"
#include "MML_Module.h"
#include "ExprBuilder.h"

//========================================================================================
  // 								CLASS TLUT 
  //========================================================================================
  
//----------------------------------------------------------------------------------------
  //				TLUT::TLUT:
  //----------------------------------------------------------------------------------------
  
TLUT :: TLUT (const char* name) : TNamedObject(name) 
{ 
  fLUTIndex = 0;
  fNumLUT = 0;
  fMethodName = name;
  fDerivative = 0;
} // TLUT :: Initialize
  
  
  //----------------------------------------------------------------------------------------
  //				TLUT::ILUT:
  //----------------------------------------------------------------------------------------
  
  int TLUT :: ILUT ( Module* thisModule ) 
{
  Pix p = thisModule->LUTList().Insert(*this);
  if( p != 0 ) {
	fLUTIndex = (int) thisModule->LUTList().index(p);
	return fLUTIndex;
  }
  return -1;
}  // TLUT :: ILUT
  
  
int TLUT :: AddPoint( float x, const float* y, int ngraph ) {
  if( fNumLUT == 0) fNumLUT = ngraph;
  else if ( fNumLUT != ngraph ) gFatal( fName + " :-> All entries in LUT must be the same size." ); 
  if( ngraph == 1 ) {
    const TTemporalTimeSlice t( x, *y ); 
    add_high(t);
  } else {
//    float* data = new float[ngraph];
//    memcpy(data,y,ngraph*sizeof(float));
//    const TimeSlice t( x, data, kTS_Deep ); 
//    add_high(t);
			gPrintErr("Higher order graphs not currently supported.");
  }
	return ngraph;  
}


int TLUT :: AddPoint( CString res[], int ngraph ) {
  if( fNumLUT == 0) fNumLUT = ngraph;
  else if ( fNumLUT != ngraph ) gFatal( fName + " :-> All entries in LUT must be the same size." ); 
  if( ngraph == 1 ) {
		errno=0; 
		float x = atof(res[0]);
		Util::CheckErrors( "graph", res[0], fLUTIndex);
		double y = atof(res[1]);
		Util::CheckErrors( "graph", res[1], fLUTIndex);
		const TTemporalTimeSlice t( x, y ); 
    add_high(t);
  } else {
		gPrintErr("Higher order graphs not currently supported.");
//    float* data = new float[ngraph];
//		float x = atof(res[0]);
//		for( int i=0; i<ngraph; i++ ) {
//			data[i] = atof(res[i+1]);
//			Util::CheckErrors( "graph", res[i+1], fLUTIndex);
//		}
//    const TimeSlice t( x, data, kTS_Deep ); 
//    add_high(t);
  }
	return ngraph;    
}

  //----------------------------------------------------------------------------------------
  //				TLUT::Read:
  //----------------------------------------------------------------------------------------  
  void  TLUT :: Read(FILE* inFile) 
{
  int test = 0; char inputVal[51];
  int i = -1, j, k, rtst;
  int MorePts = True;
	errno=0; 
  float x, y;

  while( isspace(test) || test == 0 ) test = fgetc(inFile); 				
  if ( test != '(' ) { 
	gProgramBreak("graph Read Error: ");
    	sprintf(gMsgStr,"graphindex= %d, test = '%c' instesd of '(' (no points in graph)\n",fLUTIndex,test);
    	gFatal(); 
   } 
   while(MorePts) {
    for (k=0;  k < 50; k++)  { if( (test = fgetc(inFile)) != ',') inputVal[k] = test; else break; }
    inputVal[k] = inputVal[50] = '\0';
    x = atof(inputVal);
    Util::CheckErrors( "graph", inputVal, fLUTIndex);
    if ( gDebug > 2 )  fprintf(Env::LogFile(),"\n Read LUT values: %s",inputVal);
    for (k=0;  k < 50; k++)  { if( (test = fgetc(inFile)) != ')') inputVal[k] = test; else break; }
    inputVal[k] = inputVal[50] = '\0';
    y = atof(inputVal);
    Util::CheckErrors( "graph", inputVal, fLUTIndex);
    if ( gDebug > 2 )  fprintf(Env::LogFile()," %s\n",inputVal);
    k=-1;
    AddPoint(x,&y,1);
    while ( test != '(' ) {
      test = fgetc(inFile);
      if(++k<50) inputVal[k] = test; 
      if(test == '\n')  {  MorePts = False; break; }
      if(test == EOF)  {  MorePts = False; printf("\nEOF in LUT\n\n"); }
      if ( isalnum(test) || test == EOF ) { inputVal[k] = '\0';   	
      printf("graph Read search Error: graphindex= %d, i = %d, test = %c (%x), prev = %s\n",fLUTIndex,i,test,test,inputVal); 
      for(j=0; j<i; j++) printf("(%.1f,%.1f)",(*this)[j].Time(),(*this)[j]()); 
      exit(10); 
      }
    }
  }
  if ( gDebug > 2 ) {     	
    fprintf(Env::LogFile(),"\nRead LUT: graphindex= %d, Npt = %d\n",fLUTIndex,i); 
    for(j=0; j<i; j++) fprintf(Env::LogFile(),"(%.1f,%.1f)",(*this)[j].Time(),(*this)[j]());
    fprintf(Env::LogFile(),"\n"); 
  }
  
} // TLUT::Read
  
//----------------------------------------------------------------------------------------
//				TLUT::Print:
//----------------------------------------------------------------------------------------
  
  
  void  TLUT::Print(FILE* cEqnFile) const 
{ 
  if( fNumLUT == 0 ) return;
  fprintf(cEqnFile,"\n\tLUT %s {\n\t\t", (const char*)fName );
  
  for( int j=0; j < length(); j++ ) { 
    fprintf(cEqnFile,"(%.4E",(*this)[j].Time());
    if( fNumLUT == 1 )  fprintf(cEqnFile,",%.4E",(*this)[j]());
//    else for(int k=1; k<= fNumLUT; k++) fprintf(cEqnFile,",%.4E",(*this)[j].Value(k));
    fprintf(cEqnFile,")");
    if(j<length()-1) fprintf(cEqnFile,",");
    if( (j%4) == 3 ) fprintf(cEqnFile,"\n\t\t");  
  }
  fprintf(cEqnFile,"\n\t}\n");
  
}  //  TLUT::Print

//----------------------------------------------------------------------------------------
//				TLUT::PrintMML:
//----------------------------------------------------------------------------------------

void  TLUT::WriteMML(FILE* oFile, EWriteMode mode) {
  if( fNumLUT == 0 ) return;
  fprintf(oFile,"\tLUT %s {\n\t\tlist Data = (  ", (const char*)fName );
  
  for( int j=0; j < length(); j++ ) { 
    fprintf(oFile,"( %.4E",(*this)[j].Time());
    if( fNumLUT == 1 )  fprintf(oFile,", %.4E",(*this)[j]());
//    else for(int k=1; k<= fNumLUT; k++) fprintf(oFile,", %.4E",(*this)[j].Value(k));
    fprintf(oFile," )");
    if(j<length()-1) fprintf(oFile,", ");
    if( (j%4) == 3 ) fprintf(oFile,"\n\t\t\t\t");  
  }
  fprintf(oFile,"\n\t\t);\n\t}\n");
  
} 

void  TLUT::WriteXML(FILE* oFile) {
  if( fNumLUT == 0 ) return;
  fprintf(oFile,"\n\t<lut name=\"%s\" >\n\t\t<data>\n\t\t\t", (const char*)fName );
  
  for( int j=0; j < length(); j++ ) { 
    fprintf(oFile,"( %.4E",(*this)[j].Time());
    if( fNumLUT == 1 )  fprintf(oFile,", %.4E",(*this)[j]());
//    else for(int k=1; k<= fNumLUT; k++) fprintf(oFile,", %.4E",(*this)[j].Value(k));
    fprintf(oFile," )");
    if(j<length()-1) fprintf(oFile,", ");
    if( (j%4) == 3 ) fprintf(oFile,"\n\t\t\t");  
  }
  fprintf(oFile,"\n\t\t</data>\n\t</lut>\n");
  
} 

  //----------------------------------------------------------------------------------------
  //				TLUT::WriteCEqns:
  //----------------------------------------------------------------------------------------
  
  
  void  TLUT :: WriteCCode(FILE* cHdrFile, FILE* cEqnFile)
{ 
  fprintf(cHdrFile,"\n\n\tinline double %s(double x) { \n", fName.chars() );
  fprintf(cHdrFile,"\t\tstatic double g[%u][%u] = {\n\t\t\t",length(),fNumLUT+1); 
  for(int j=0; j < length(); j++) {
    fprintf(cHdrFile,"{ %.4E",(*this)[j].Time()); 
    if( fNumLUT == 1 )  fprintf(cHdrFile,", %E",(*this)[j]());
//    else { for(int k=1; k<= fNumLUT; k++) fprintf(cHdrFile,", %E",(*this)[j].Value(k)); }
    if(j==length()) fprintf(cHdrFile,"}"); else fprintf(cHdrFile,"},");
    if( (j%4) == 3 ) fprintf(cHdrFile,"\n\t\t\t");  
  }
  fprintf(cHdrFile," };\n");
  fprintf(cHdrFile,"\t\treturn SL::Graph( 0, x, %d, g); \n\t}", length()-1 );
}  //  TLUT::WriteLUTEqns

  void  TLUT :: WriteDCode(FILE* cHdrFile, FILE* cEqnFile) const
{ 
  fprintf(cHdrFile,"\n\n\tinline double D%s(double x) { \n", fName.chars() );
  fprintf(cHdrFile,"\t\tstatic double g[%u][%u] = {\n\t\t\t",length(),fNumLUT+1); 
  for(int j=0; j < length(); j++) {
    fprintf(cHdrFile,"{ %.4E",(*this)[j].Time()); 
    if( fNumLUT == 1 )  fprintf(cHdrFile,", %E",(*this)[j]());
//    else { for(int k=1; k<= fNumLUT; k++) fprintf(cHdrFile,", %E",(*this)[j].Value(k)); }
    if(j==length()) fprintf(cHdrFile,"}"); else fprintf(cHdrFile,"},");
    if( (j%4) == 3 ) fprintf(cHdrFile,"\n\t\t\t");  
  }
  fprintf(cHdrFile," };\n");
  fprintf(cHdrFile,"\t\treturn SL::GraphP( 0, x, %d, g); \n\t}", length()-1 );
}  //  TLUT::WriteLUTEqns

void TLUT :: WriteDCode(TCommand* c, CString& s,  TListNode* arg, int isGlobal, int wContext  ) {
		
		s += SName(); s += "P";
		s += '('; arg->WriteCCode(c,s,isGlobal,wContext); s += ')'; 
}

  //----------------------------------------------------------------------------------------
  //				TLUT::ProcessNode:
  //----------------------------------------------------------------------------------------
  

int TLUT :: ProcessGeneral(TNode* n) {  
	if( n->NodeType() == TNode::kGraph ) {
		TGraphNode* gn = (TGraphNode*)n;
		CString res[10], sep = ",";
		if(gn) { 
			if( gn->GetLUT() == NULL ) {
				gn->SetLUT(this);
				const TOrderedObjectDLList& list = gn->PointList();
				for( Pix p=list.first(); p; list.next(p) ) {
					TNode* n0 = (TNode*) &list(p);
					if( n0->GetObjInfo(TNode::kNodeType) == TNode::kPoint ) {	
						TPointNode* pn = (TPointNode*) n0;
						CString&  pd = pn->PointData(); 
						int nd = split(pd, res, 10, sep);
						AddPoint( res, nd-1 );
					}
				}
				return 1;
			}
		}
	}
	return 0;
}

int TLUT :: ProcessCommand(const TCommandNode* n) { return 0; }

int TLUT :: ProcessAttribute(const TAttributeNode* an) {
	const TDeclarationNode* dn = an->Declaration();
	CString& cmd = (CString&) dn->Command();
	const TNode* vn = an->Value();
	cmd.downcase();
//	gPrintScreen( format( "Processing graph %s", fName.chars() ) );
	
	if( cmd == "data" ) {
		if( length() == 0 ) {
			if( vn->NodeType() ==  TNode::kList ) {
				TListNode* ln = (TListNode*)vn;
				const TOrderedObjectDLList& list = ln->List();
				int index = 0;
				for( Pix p = list.first(); p; list.next(p) ) {
					TNode* in = (TNode*)&list(p);
					floatVec fv; 
					int cnt = GetAttributeFloatList( in, fv );
					if( cnt != 2  ) {
						gPrintErr( format( "Problem with reading graph %s", fName.chars() ) );
					} else {
						if( fNumLUT <= 0 ) fNumLUT = cnt-1;
						else if( fNumLUT != cnt-1 ) gFatal( " UnEqual graph point lists. " );
						const float* fdata = fv.data();
						AddPoint( fdata[0], fdata+1, fNumLUT ); index++;
					}
				}
				return index;
			} else return NodeTypeError( an ); 
		}
  } else if( cmd == "methodname" ) {
  		if( GetAttrValue( vn, kAVString ) ) {
			const CString* s = fAttrValue;
			if(s) fMethodName = *s;
		}				  
	} else return 0;
  return 1;
}



