#include "MML_Schedule.h"
#include "Environ.h"

//----------------------------------------------------------------------------------------
//			TimeExSchedule::Clamp:
//----------------------------------------------------------------------------------------

void TimeExSchedule::Clamp( ExSchedule* parent, StepExSchedule& s) {
  Start = smax( Start, s.StartTime()*StepInc );
  if( parent ) Start = smax( Start, parent->StartTime() ); 
  Stop = smin( Stop, s.StopTime()*StepInc );
  if( parent ) Stop = smin( Stop, parent->StopTime() );
  StepInc = StepInc*s.DT();
}

//----------------------------------------------------------------------------------------
//			ExSchedule::kTypeList:
//----------------------------------------------------------------------------------------

ArgArray  ExSchedule::kTypeList( 4, " ", "time", "step", "dyn" );
EInfoIndex ExSchedule::kMode = kO_Info0;
EInfoIndex ExSchedule::kUnit = kO_Info1;

//----------------------------------------------------------------------------------------
//			ExSchedule::Config:
//----------------------------------------------------------------------------------------

int  ExSchedule::Config( TConfigData& cd ) {
  const CString& cmd = cd.Cmd();
  if( ScheduleConfigured() ) return 0;   // break if already configured. 
  int iarg;
  if( cmd == "OS" || cmd == "O" ) {
    SetObjInfo(kMode,kStepS);
    fSSchedule.Config(cd);
    if( fParent ) {  fTSchedule.Clamp(fParent,fSSchedule); }
  } else if( cmd == "OT" ) {
    SetObjInfo(kMode,kTimeS);
    fTSchedule.Config(cd);
    switch( fTSchedule.getUnit() ) {
	  case 's' : SetObjInfo(kUnit,kSecond ); break;
	  case 'm' : SetObjInfo(kUnit,kMinute ); break;
	  case 'h' : SetObjInfo(kUnit,kHour ); break;
	  case 'd' : SetObjInfo(kUnit,kDay ); break;
	  case 'w' : SetObjInfo(kUnit,kWeek ); break;
	  case 'y' : SetObjInfo(kUnit,kYear ); break;
	} 
    if( fParent ) {  fTSchedule.Clamp(fParent,fSSchedule); } 
  } else return 0;
  return 1;
}

//----------------------------------------------------------------------------------------
//			ExSchedule::AddModifier:
//----------------------------------------------------------------------------------------

int ExSchedule::AddModifier( const CString& mod, Bool isExtension ) {
  return SetMode(mod,isExtension);
}

//----------------------------------------------------------------------------------------
//				ExSchedule::GetModifierString:
//----------------------------------------------------------------------------------------

int ExSchedule::GetModifierString( CString& mod ) const {
  mod += kTypeList[ GetObjInfo(kMode) ];
  return 1;
}

//----------------------------------------------------------------------------------------
//				ExSchedule::WriteMML:
//----------------------------------------------------------------------------------------
 
void ExSchedule::WriteMML( FILE* oFile, EWriteMode mode )  {
  CString mod;
  GetModifierString(mod);
  if( mode == kDeclaration ) { 
    fprintf(oFile,"\t\t%s Schedule %s;\n",(const char*)mod,Name());
  } else if( mode == kDefinition ) {
    fprintf(oFile,"\t\t%s Schedule %s {\n",(const char*)mod,Name());
    switch(GetObjInfo(kMode)) {
    case kStepS: fSSchedule.WriteMML(oFile); break;
    case kTimeS: fTSchedule.WriteMML(oFile); break;
    }
    fprintf(oFile,"\t\t }\n");
  }
}

int ExSchedule :: ProcessAttribute(const TAttributeNode* an) {
  if( !ScheduleConfigured() )  SetObjInfo(kMode,kTimeS);
  switch(GetObjInfo(kMode)) {
  case kStepS:
    { int tmp = fSSchedule.ProcessAttribute(an) ;
      if( fParent ) {  fTSchedule.Clamp(fParent,fSSchedule); } 
      return tmp; }
  case kTimeS:
    { int tmp = fTSchedule.ProcessAttribute(an) ;
      if( fParent ) {  fTSchedule.Clamp(fParent,fSSchedule); } 
      return tmp; }
  }
}
//----------------------------------------------------------------------------------------
//				ExSchedule::WriteCCode:
//----------------------------------------------------------------------------------------

void ExSchedule::WriteCCode( FILE* CHdrFile, FILE* CEqnFile) {
  fprintf(CHdrFile,"");
  fprintf(CEqnFile,"");
}

//----------------------------------------------------------------------------------------
//				ExSchedule::Dump:
//----------------------------------------------------------------------------------------
  
void ExSchedule::Dump( FILE* oFile ){ WriteMML( oFile ); }


