//----------------------------------------------------------------------------------------
//	MML_Time.h
//	Developed by Tom Maxwell, MIIEE, Chesapeake Biological Lab.
//	Change History:
//----------------------------------------------------------------------------------------

#ifndef __SSEvents__
#define __SSEvents__
  
#include "SList.h"
typedef class Module Module;


//----------------------------------------------------------------------------------------
//						TTime
//----------------------------------------------------------------------------------------
  
  class  TTime {

    static CString fName;
    static float fValue;
    static float fStartTime;
    static float fDT;
    static int fStep;
    static float fYear;
    static float fYearInit;
    static float fDT_Year;
    
  public:

    inline TTime( char* name ) { fName = name; fStartTime = fValue = 0; fStep = 0; fYearInit = 0.0; fDT_Year = 0.0; }

    static inline int Step(int index, int step=1) {
      if( step == 0 ) return 0;
      return (int)(fValue/fDT)+index;
    }
    static inline int Step() { return fStep; } 
    static inline void SetYear( float year, float dt_year ) { fYearInit = fYear = year; fDT_Year = dt_year; }
    static inline void SetStartTime( float start ) { fStartTime = fValue = start; }

    static inline float Value() { return fValue; } 
    static inline float Year() { return fYear; } 
    static inline float YearFromSimTime( float simtime ) { return fYearInit + simtime*fDT_Year; } 
	static inline float SimTimeFromYear( float year ) { return (year - fYearInit)/fDT_Year; } 
     static inline float Current() { return fValue; } 
  
    static float Value(int index, int step=1) {  if( step == 0 ) return 0.0; return fValue + fDT*index; }

    inline static void Update() { fValue += fDT; fStep++; fYear += fDT_Year; }

    inline static void Update(float ftime) { fValue = ftime; fStep = (int) (ftime/fDT); fYear = fYearInit + fStep*fDT_Year; }

    inline static void Init(void) {   fValue = 0; fStep = 0; }

    inline static void DT(float dt) { fDT = dt; }

    inline static float DT(void) { return fDT; }
    inline static float Start(void) { return fStartTime; }
    inline static float DTYear(void) { return fDT_Year; }

    inline Pix SSInit( Module* mod ) {
      fValue = 0; fStep = 0; return 0; 
    }

  };

inline float gTime() { return TTime::Current(); }
inline float gDT() { return TTime::DT(); }
inline float gStep() { return TTime::Step(); }
      
#endif

