#if __GNUG__ >= 2
#  pragma implementation
#endif

#include "SMMLParser.h"

inline int scmp( const xmlChar * a, const char* b ) {
  int diff = 0;
  while ((diff = *a - *b++) == 0 && *a++ != 0);
  return diff;
}

#define SAME( a, b ) (scmp(a,b) == 0)

int SMMLparse(void);
void SMMLinitParse( int debug_level, CString& doc_name );
void SMMLSetParseBuffer( CString& s );
static int parse_debug = 0;

// ************* SAX Handler Functions

void StartDocument(void *ctx);                       // startDocumentSAXFunc
void EndDocument(void *ctx);                         // endDocumentSAXFunc
void StartElement(void *ctx, const xmlChar *fullname, const xmlChar **atts) ;  // startElementSAXFunc 
void EndElement(void *ctx, const xmlChar *name);             // endElementSAXFunc
void Characters(void *ctx, const xmlChar *ch, int len);      // charactersSAXFunc 
xmlEntityPtr GetEntity(void *ctx, const xmlChar *name);      // getEntitySAXFunc 
void SetDocumentLocator(void *ctx, xmlSAXLocatorPtr loc);    // setDocumentLocatorSAXFunc

// ***************** Utility Functions 

void AddChildNode( TCommandNode* parent, TNode* child );
TNode* ParsePCData( void *ctx, CString& att_name, CString& s );
TAttributeNode*  ProcessAttribute( void* ctx, TCommandNode* cn, const xmlChar *fullname, const xmlChar *value );
TAttributeNode*  CreateAttribute( const char*  name, TNode *val_node);

SMMLParser::SMMLParser( TCommandNode* root, const char* doc_name, int debug ) {
	parse_debug = debug;
	_smml_parse_data = new smmlParseData(root,doc_name);
	InitHandler();
}
SMMLParser::~SMMLParser( ) { delete _smml_parse_data; }

void SMMLParser::InitHandler() {

    _smml_handler = (smmlSAXHandler *) xmlMalloc(sizeof(smmlSAXHandler));
    if (_smml_handler == NULL) {
        fprintf(stderr, "InitParserCtxt: out of memory\n");
    }
	memcpy(_smml_handler, &xmlDefaultSAXHandler, sizeof(xmlSAXHandler));

    _smml_handler->internalSubset = NULL;
    _smml_handler->isStandalone = NULL;
    _smml_handler->hasInternalSubset = NULL;
    _smml_handler->hasExternalSubset = NULL;
    _smml_handler->resolveEntity = NULL;
    _smml_handler->getEntity = GetEntity;
    _smml_handler->getParameterEntity = NULL;
    _smml_handler->entityDecl = NULL;
    _smml_handler->attributeDecl = NULL;
    _smml_handler->elementDecl = NULL;
    _smml_handler->notationDecl = NULL;
    _smml_handler->unparsedEntityDecl = NULL;
    _smml_handler->setDocumentLocator = SetDocumentLocator;
    _smml_handler->startDocument = StartDocument;
    _smml_handler->endDocument = EndDocument;
    _smml_handler->startElement = StartElement;
    _smml_handler->endElement = EndElement;
    _smml_handler->reference = NULL;
    _smml_handler->characters = Characters;
    _smml_handler->cdataBlock = NULL;
    _smml_handler->processingInstruction = NULL;
    _smml_handler->warning = xmlParserWarning;
    _smml_handler->error = xmlParserError;
    _smml_handler->fatalError = xmlParserError;
}

int SMMLParser::parseFile ( const CString& path, const CString& file, int recovery ) {
    xmlParserCtxtPtr ctxt;
    char *directory = NULL;
    _smml_parse_data->_input_path = path;
    CString filename( path );  (filename += "/") += file;

	gPrintScreen( " parsing smml file: " + filename );    
	
    ctxt = xmlCreateFileParserCtxt(filename.chars());
    if (ctxt == NULL) {
		if( parse_debug ) {
			fprintf(stderr, "SAX.error: Unable to read input file %s\n", filename.chars() );
		}     
		return 1;
	}
    if (_smml_handler != NULL) {
		if (ctxt->sax != NULL) {
			xmlFree(ctxt->sax);
		}
		ctxt->sax = _smml_handler;
		ctxt->userData = _smml_parse_data;
    }

    if ((ctxt->directory == NULL) && (directory == NULL))
        directory = xmlParserGetDirectory(filename);
    if ((ctxt->directory == NULL) && (directory != NULL))
        ctxt->directory = (char *) xmlStrdup((xmlChar *) directory); /* !!!!!!! */

    xmlParseDocument(ctxt);
	ctxt->sax = NULL;
    xmlFreeParserCtxt(ctxt);
    return 0;
}

  
int SMMLParser::parseMemory (char *buffer, int size, int recovery ) {
    xmlParserCtxtPtr ctxt;
    char *directory = NULL;

	ctxt = xmlCreateMemoryParserCtxt(buffer, size);
    if (ctxt == NULL) return 1;
    if (_smml_handler != NULL) {
		if (ctxt->sax != NULL) {
			xmlFree(ctxt->sax);
		}
		ctxt->sax = _smml_handler;
		ctxt->userData = _smml_parse_data;
    }

    xmlParseDocument(ctxt);
	ctxt->sax = NULL;
    xmlFreeParserCtxt(ctxt);
    return 0;
}

void AddChildNode( TCommandNode* parent, TNode* child ) {  
	if( child == NULL ) return;
	TListNode* ln = parent->StatementList();
	if( ln == NULL ) { ln = ExprBuilder::CreateListNode( child ); parent->SetStatements( ln ); }
	else { ln->AddNode(child); }
	
	if( parse_debug ) {
		TDeclarationNode* dn = parent->Declaration(); 
		fprintf(stderr, "SAX.AddChildNode( parent: %s %s (%x) -> child: %x )\n", 
						dn->Command().chars(), dn->Name()->Top().chars(), parent, child );
	}     
}

	
TAttributeNode*  ProcessAttribute( void* ctx, TCommandNode* cn, const xmlChar *fullname, const xmlChar *value ) {
	smmlParseDataPtr pd = (smmlParseDataPtr) ctx;
	TDeclarationNode* dn = cn->Declaration(); 
	TAttributeNode* an = NULL;
	
	if( parse_debug ) {
		fprintf(stderr, "SAX.ProcessAttribute( %s = %s )\n", fullname, value );
	}     
	
	if( SAME(fullname,"name") ) {
		TStringListNode* args = (TStringListNode*) ExprBuilder::CreateStringListNode( (const char*) value );
		dn->SetName( args );
	} else 	if( SAME(fullname,"location") ) {
		const char* doc_name = ( dn->Name() == NULL ) ? "NULL" :  dn->Name()->Top().chars();
		SMMLParser* smml = new SMMLParser( cn, doc_name, parse_debug );
		smml->parseFile( pd->_input_path, (const char *) value );
		delete smml;
	} else if( SAME(fullname,"type") || SAME(fullname,"mode") || SAME(fullname,"event") ) {
		dn->AddQualifier( (const char*)value );
	} else { 
		TDeclarationNode* decl = (TDeclarationNode*) ExprBuilder::CreateDeclarationNode( (const char*)fullname, NULL );
		an = (TAttributeNode*) ExprBuilder::CreateAttrNode( decl );
		an->SetValue( ExprBuilder::CreateStringNode( (const char*)value ) ); 
	}
	return an;
}

TAttributeNode*  CreateAttribute( const char*  name, TNode *val_node) {  
	TAttributeNode* an = NULL;
	
	if( parse_debug ) {
		fprintf(stderr, "SAX.createAttribute( %s )\n", name );
	}
	
	if( val_node != NULL ) { 
		TDeclarationNode* decl = (TDeclarationNode*) ExprBuilder::CreateDeclarationNode( name, NULL );
		an = (TAttributeNode*) ExprBuilder::CreateAttrNode( decl );
		an->SetValue( val_node ); 
	}
	return an;
}


// AddQualifiers( const TDeclarationNode* dn, int isExtension )
void StartDocument(void *ctx) {

	smmlParseDataPtr pd = (smmlParseDataPtr) ctx;
	
	if( parse_debug ) {
		fprintf(stderr, "SAX.startDocument(%s)\n", pd->_doc_name.chars() 
		);
	}

/*
	if (ctxt->encoding != NULL)
	    _encoding = xmlStrdup(ctxt->encoding);
	else
	    _encoding = NULL;
	_standalone = ctxt->standalone;
*/

}

/**
 * endDocument:
 * @ctx: the user data (XML parser context)
 *
 * called when the document end has been detected.
 */
 
void EndDocument(void *ctx) {

	smmlParseDataPtr pd = (smmlParseDataPtr) ctx;
	
	if( parse_debug ) {
		fprintf(stderr, "SAX.endDocument( %s )\n", pd->_doc_name.chars() );
	}
//    validate = ctxt->validate ;
//    wellFormed = ctxt->wellFormed;
}


/**
 * startElement:
 * @ctx: the user data (XML parser context)
 * @name:  The element name
 * @atts:  An array of name/value attributes pairs, NULL terminated
 *
 * called when an opening tag has been processed.
 */
void StartElement(void *ctx, const xmlChar *fullname, const xmlChar **atts) {

	smmlParseDataPtr pd = (smmlParseDataPtr) ctx;
	
	if( parse_debug ) {
		fprintf(stderr, "SAX.startElement(%s)\n", fullname);
	}     

     // Split the full name into a namespace prefix and the tag name

    xmlChar *prefix;
    
#ifdef XML2
    xmlChar *name = xmlSplitQName( (xmlParserCtxtPtr)ctx, fullname, &prefix);
#else
    xmlChar *name = xmlSplitQName( fullname, &prefix );
#endif

	TDeclarationNode* dn;
	TCommandNode* cn;
	
	if( ( pd->_first_element > 0 ) && ( pd->_root != NULL ) ) {
	
		cn = pd->_root;
		dn = cn->Declaration();	
		
	} else {
	
		dn = (TDeclarationNode*) ExprBuilder::CreateDeclarationNode( (const char*) name, NULL );
		cn = (TCommandNode*) ExprBuilder::CreateCommandNode( dn );
		
		if( pd->_first_element > 0 ) { dn->AddQualifier( "root" ); }
		
		if( pd->_current != NULL ) {
			AddChildNode( pd->_current, cn ); 
			cn->SetSuperNode( pd->_current );
		}
	} 
	
	pd->_current = cn;	

	if( parse_debug ) {
		fprintf(stderr, "SAX.Current Element(  %s %s (%x) )\n",  dn->Command().chars(), dn->Name()->Top().chars(), cn );
	}     
	
     // process the attributes
    if (atts != NULL) {
        int i = 0;
		const xmlChar *att = atts[i++];
		const xmlChar *value = atts[i++];
        while ((att != NULL) && (value != NULL)) {
			TNode* child = ProcessAttribute(ctx,cn,att,value);
			if( child != NULL ) {
				AddChildNode( pd->_current, child);
			}
			att = atts[i++];
			value = atts[i++];
		}
    }	

    if ( pd->_root == NULL ) {
		if( parse_debug ) {
			TStringListNode* sln = dn->Name(); 
			fprintf(stderr, "Setting %s (%s) as root\n", name, ((sln==NULL) ? "NULL" : sln->Top().chars()) );
		}
		pd->_root = cn;
    }
    pd->_first_element  = 0;
}



void Characters(void *ctx, const xmlChar *ch, int len) {
	smmlParseDataPtr pd = (smmlParseDataPtr) ctx;
	CString buff;
	int parse_buff = 0;
		
	for( int i=0; i<len; i++ ) {
		xmlChar c = ch[i];
		if( iscntrl(c) || isspace(c) ) { buff += ' '; }
		else {
			buff += (char)c;
			parse_buff = 1;
		}
	}

	if( parse_buff ) { 
		if( parse_debug ) { fprintf(stderr, "SAX.characters:%s\n", buff.chars()  ); }
		pd->_char_buffer += buff;
	}
}

TNode* ParsePCData( void *ctx, CString& att_name, CString& s ) {
  smmlParseDataPtr pd = (smmlParseDataPtr) ctx;
  char b_open, b_close;
  if( (att_name == "code") ||  (att_name == "default") ) {	
	  b_open = '{'; b_close = '}';
  } else if( att_name == "data" ) {	
	  b_open = '('; b_close = ')';
  } else {
	  return ExprBuilder::CreateStringNode( s.chars() );
  }
  CString parse_buff(b_open); parse_buff += s; parse_buff += b_close; parse_buff += '\0';
  
  if( parse_debug ) {
	fprintf(stderr, "SAX.ParsePCData:%s\n", parse_buff.chars() );
  }	
  
  SMMLSetParseBuffer( parse_buff);
  ExprBuilder::ClearNodes();
  SMMLinitParse( parse_debug, pd->_doc_name );
  int rv = SMMLparse();
  
  if( parse_debug ) {
	fprintf(stderr, "SMML.parse returned %d\n", rv );
  }	
  return ExprBuilder::GetResult();
}

/**
 * endElement:
 * @ctx: the user data (XML parser context)
 * @name:  The element name
 *
 * called when the end of an element has been detected.
 */

void EndElement(void *ctx, const xmlChar *name) {
	smmlParseDataPtr pd = (smmlParseDataPtr) ctx;
	
	if( parse_debug ) {
		if (name == NULL) {
			fprintf(stderr, "SAX.endElement(NULL)\n");
		} else {
			TStringListNode* sln = ( pd->_current != NULL ) ? pd->_current->Declaration()->Name() : NULL; 
			fprintf(stderr, "SAX.endElement(%s:%s)\n", name, ((sln==NULL) ? "NULL" : sln->Top().chars()) );
		}
	}
 
	TAttributeNode*	an = NULL;
	if( pd->_char_buffer.length() > 0 ) {
		CString& att_name = pd->_current->Declaration()->Command();
		an = CreateAttribute( att_name.chars(), ParsePCData( ctx, att_name, pd->_char_buffer.trim('{','}') ) );
		pd->_char_buffer.clear();
	}   
	
	pd->_current = (TCommandNode*) pd->_current->SuperNode(); 
	
	if( (an != NULL) && ( pd->_current != NULL ) ) {   
		AddChildNode( pd->_current, an ); 
	}
}

void SetDocumentLocator(void *ctx, xmlSAXLocatorPtr loc) {
	smmlParseDataPtr pd = (smmlParseDataPtr) ctx;
	if( parse_debug ) {
		fprintf(stderr, "\nSAX.setDocumentLocator()\n");
	}
}

xmlEntityPtr GetEntity(void *ctx, const xmlChar *name)
{
	smmlParseDataPtr pd = (smmlParseDataPtr) ctx;
	if( parse_debug ) {
	  fprintf(stdout, "SAX.getEntity(%s)\n", name);
	}
    return xmlGetPredefinedEntity(name);
}


