#include "XObject2.h"

#ifndef _included_Array1XObject2_h
#define _included_Array1XObject2_h

// #include <generic.h>
#include "Point1.h"
#include "Region1.h"
#include "IndexArray1.h"

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif
#ifndef NULL
#define NULL ((void *) 0)
#endif

typedef class XObject2 XObject2;

/****************************************************************
* class Array1							*
*								*
* Create an array of the specified TYPE.  This is intended to 	*
* be asimple array class with few frills.			*
*****************************************************************/

#ifndef Array1
#define Array1(XObject2) name2(Array1,XObject2)
#endif


class Array1(XObject2)
{
   Region1 _region;
   Point1 _extents;
   int _bottom;
   int _delete_data;
   int _size;
   XObject2 *_array;

   /*
     Define the constructor and destructor functions for class Array1
   */

public:
   Array1(XObject2)();
   Array1(XObject2)(const Region1& region);
   Array1(XObject2)(const int i);
   Array1(XObject2)(const Region1& region, XObject2 *data, const int release = TRUE);
   Array1(XObject2)(const int i, XObject2 *data, const int release = TRUE);
   void resize(const Region1& region);
   void resize(const int i);
   inline ~Array1(XObject2)()
     { if (_delete_data && _array) delete [] _array; }

   /*
     Define some inline functions for getting at region extents
   */

   inline const Point1& lower() const { return(_region.lower()); }
   inline const Point1& upper() const { return(_region.upper()); }
   inline const Point1& extents() const { return(_extents); }
   inline Point1 lower() { return(_region.lower()); }
   inline Point1 upper() { return(_region.upper()); }
   inline Point1 extents() { return(_extents); }
   inline int bottom() const { return(_bottom); }
   inline int lower(const int i) const { return(_region.lower(i)); }
   inline int upper(const int i) const { return(_region.upper(i)); }
   inline int extents(const int i) const { return(_extents(i)); }
   inline const Region1& region() const { return(_region); }
   inline int size() const { return(_size); }
   inline int size(const int i) const { return(_array[_bottom+i].size()); }

   /*
     Define the inline functions for indexing the Array1 object
   */

   inline XObject2& operator () (const int i) const
     { return(_array[_bottom+i]); }
   inline XObject2& operator () (const int i)
     { return(_array[_bottom+i]); }
   inline const XObject2 *ptr(const int i) const
     { return(&_array[_bottom+i]); }
   inline XObject2 *ptr(const int i)
     { return(&_array[_bottom+i]); }
   inline const XObject2& operator () (const Point1& p) const
     { return(_array[_bottom+p(0)]); }
   inline XObject2& operator () (const Point1& p)
     { return(_array[_bottom+p(0)]); }
   inline const XObject2 *ptr(const Point1& p) const
     { return(&_array[_bottom+p(0)]); }
   inline XObject2 *ptr(const Point1& p)
     { return(&_array[_bottom+p(0)]); }
   inline const XObject2 *data() const { return(_array); }
   inline XObject2 *data() { return(_array); }
   void fill(const XObject2& t);
};

#endif
