#include "Array.h"

#ifndef _included_Array1int_h
#define _included_Array1int_h

// #include <generic.h>
#include "IndexArray1.h"

#ifndef TRUE
#define TRUE (1)
#endif
#ifndef FALSE
#define FALSE (0)
#endif
#ifndef NULL
#define NULL ((void *) 0)
#endif

/****************************************************************
* class Array1							*
*								*
* Create an array of the specified TYPE.  This is intended to 	*
* be asimple array class with few frills.			*
*****************************************************************/

#ifndef Array1
#define Array1(int) name2(Array1,int)
#endif


class Array1(int)
{
   Region1 _region;
   Point1 _marker;
   int _bottom;
   int _delete_data;
   int _size;
   int *_array;

   /*
     Define the constructor and destructor functions for class Array1
   */

public:
   Array1(int)();
   Array1(int)(const Region1& region);
   Array1(int)(const int i);
   Array1(int)(const Region1& region, int *data, const int release = TRUE);
   Array1(int)(const int i, int *data, const int release = TRUE);
   void resize(const Region1& region);
   void resize(const int i);
   void resize(const int index, const int buff);

   inline ~Array1(int)()
     { if (_delete_data && _array) delete [] _array; }

   /*
     Define some inline functions for getting at region extents
   */

   inline const Point1& lower() const { return(_region.lower()); }
   inline const Point1& upper() const { return(_region.upper()); }
   inline const Point1& marker() const { return(_marker); }
   inline const int mark() const { return( _marker(0) ); }
   inline const Point1&  movemark(int i) { return( _marker += i ); }
   inline Point1 lower() { return(_region.lower()); }
   inline Point1 upper() { return(_region.upper()); }
   inline Point1 marker() { return(_marker); }
   inline int bottom() const { return(_bottom); }
   inline const Region1& region() const { return(_region); }
   inline int size() const { return(_size); }
   inline int extents() const { return(_size); }
   inline int setvalue( int ivalue, int index ) { resize(index,20); return _array[_bottom+index] = ivalue; }
   inline int setvalue( int ivalue ) { resize(_marker(0),20); return _array[_bottom+_marker(0)] = ivalue; }
   inline int incr_value( int ivalue, int index ) { resize(index,20); return _array[_bottom+index] += ivalue; }
   inline int incr_value( int ivalue ) { resize(_marker(0),20); return _array[_bottom+_marker(0)] += ivalue; }

   /*
     Define the inline functions for indexing the Array1 object
   */

   inline const int& operator () (const int i) const
     { return(_array[_bottom+i]); }
   inline int& operator () (const int i)
     { return(_array[_bottom+i]); }
   inline int& operator () ()
     { return(_array[_bottom+_marker(0)]); }
   inline const int *ptr(const int i) const
     { return(&_array[_bottom+i]); }
   inline int *ptr(const int i)
     { return(&_array[_bottom+i]); }
   inline const int& operator () (const Point1& p) const
     { return(_array[_bottom+p(0)]); }
   inline int& operator () (const Point1& p)
     { return(_array[_bottom+p(0)]); }
   inline const int *ptr(const Point1& p) const
     { return(&_array[_bottom+p(0)]); }
   inline int *ptr(const Point1& p)
     { return(&_array[_bottom+p(0)]); }
   inline const int *data() const { return(_array); }
   inline int *data() { return(_array); }
   void fill(const int& t);
};

#endif
