//-*-Mode: C++;-*-
#ifndef _CellRecord_h_
#define _CellRecord_h_

#if __GNUG__ >= 2
#  pragma interface
#endif

#include "Globals.h"

#define NCellRecordInts 4
#define NCellRecordFloats 3

//---- CellRecord -----------------------------------------------------------

struct CellRecord {
	int _index[NCellRecordInts];
	float _value[NCellRecordFloats];
	
	inline void setValues( int* idata, float* fdata ) {
		int i;
		if( idata ) { for( i=0; i<NCellRecordInts; i++ ) _index[i] = idata[i]; }
		if( fdata ) { for( i=0; i<NCellRecordFloats; i++ ) _value[i] = fdata[i]; }
	}
	
	inline int idata(int index) { return _index[index]; }
	inline float fdata(int index) { return _value[index]; }

};

//---- CellRecordArray -----------------------------------------------------------

#ifdef USE_MPI

class CellRecordArray {

 CellRecord* _CellRecords;
 int _nCellRecords;
 int _nAllocated;
 int _sizeIncrement;
 
 void realloc( int newsize ) ;
 	
public:
    CellRecordArray( int size=0, int size_incr = 10 ) ;
    ~CellRecordArray() { _nCellRecords = _nAllocated = 0; delete[] _CellRecords; _CellRecords = NULL; }
    
    inline int addCellRecord( int* idata, float* fdata ) {
			if( _nCellRecords >= _nAllocated ) { realloc( _nAllocated + _sizeIncrement ); }
			_CellRecords[_nCellRecords].setValues( idata, fdata);
			return _nCellRecords++;
    }
    
    inline CellRecord* CellRecordData( int offset = 0 ) { return  _CellRecords + offset; }
    inline CellRecord& operator[] ( int index ) { return  _CellRecords[index]; }
    inline int nCellRecords() { return _nCellRecords; }
    inline void clear() { _nCellRecords = 0; }
    inline void setDataSize( int size ) { 
			if( size > _nAllocated ) { realloc( size ); } 
			_nCellRecords = size;
		}

};

//---- CellRecordDistributedArray -----------------------------------------------------------

const int CellRecordDistributedArrayTag = 4357;
 
class CellRecordDistributedArray {

	CellRecordArray* _CellRecordOutArrays;
	CellRecordArray _CellRecordInArray;
	static MPI_Datatype _CellRecordType;
	void generateCellRecordType();
	int* _dataBuff;
	MPI_Request* _com_request;
	MPI_Status* _com_status;
	
public:

	CellRecordDistributedArray() { 
		generateCellRecordType();
		_CellRecordOutArrays = new CellRecordArray[gNProcs()];
		_dataBuff = new int[gNProcs()];
		_com_status = new  MPI_Status[gNProcs()];
		_com_request = new  MPI_Request[gNProcs()];
	}
	~CellRecordDistributedArray() { 
		delete[] _CellRecordOutArrays; 
		delete[] _dataBuff; 
		delete[] _com_status; 
		delete[] _com_request; 
	}
	
	inline int addCellRecord( int iproc, int* idata, float* fdata=NULL ) {
		return _CellRecordOutArrays[iproc].addCellRecord( idata, fdata );
	}
	
	inline void clear() {
		for( int i=0; i< gNProcs(); i++ ) { _CellRecordOutArrays[i].clear(); }
		_CellRecordInArray.clear();
	}
	
	int generateInArray();
	inline CellRecordArray& CellRecordInArray() { return _CellRecordInArray; }

};

#endif
#endif
