#include "FloatGrid.h"

//----------------------------------------------------------------------------------------
//						FloatGrid
//----------------------------------------------------------------------------------------

float FloatGrid::fGarbage = 0;

FloatGrid::FloatGrid(int r0, int c0, int r1, int c1, int r_inc, int c_inc) 
  : Region2( r0, c0, r1, c1, r_inc, c_inc ) 
{ 
  fData = NULL; 
  ReAlloc(r0,c0,r1,c1,r_inc,c_inc);
}

FloatGrid::FloatGrid(const FloatGrid& md)  : Region2(md) { 
  fData = NULL; 
  ReAlloc(md); 
}

void FloatGrid::CopyDataTo( float* data, const Region2& r) {   
                                                          // Copies from fData to data in region r.
                                                          // data should be of size r.nelem().
  if( r == (*this) ) {
    memcpy( data, fData, r.nelem()*sizeof(float) );      
  } else {
    Region2 ri(r); ri *= (*this);                                   
    for(int ir = ri.lower(0); ir<= ri.upper(0); ir+=ri.increment(0) ) {
      for(int ic = ri.lower(1); ic<= ri.upper(1); ic+=ri.increment(1) ) {
	data[ r.bindex(ir,ic) ] =  fData [ bindex(ir,ic) ];      
      }
    }
  }
}

void FloatGrid::CopyDataFrom( float* data, const Region2& r ) {   
                                                              // Copies from data to fData in region r.
                                                             // data should be of size r.nelem().
  if( r == (*this) ) {
    memcpy( fData, data, r.nelem()*sizeof(float));      
  } else {
    Region2 ri(r); ri *= (*this);                                   
    for(int ir = ri.lower(0); ir<= ri.upper(0); ir+=ri.increment(0) ) {
      for(int ic = ri.lower(1); ic<= ri.upper(1); ic+=ri.increment(1) ) {
	fData [ bindex(ir,ic) ] =  data [ r.bindex(ir,ic) ];      
      }
    }
  }
}

void FloatGrid::ReAlloc( int r0, int c0, int r1, int c1, int r_inc, int c_inc ) {
  if(r_inc<0) r_inc = inc(0);   if(c_inc<0) c_inc = inc(1);
  Region2 r( r0, c0, r1, c1, r_inc, c_inc );
  float* data = new float[ r.nelem() ];
  if(fData) {
    CopyDataTo(data,r);
    delete[] fData;
  }
  setregion(r);
  fData = data;
}

void FloatGrid::ReAlloc( const Region2& r ) {
  float* data = new float[r.nelem()];
  if(fData) {
    CopyDataTo(data,r);
    delete[] fData;
  }
  setregion(r);
  fData = data;
}

