#ifndef _included_FloorPlan_h
#define _included_FloorPlan_h

/****************************************************************
*   Author: Stephen Fink					*
*								*
*   Class FloorPlan represents a regular or irregular block	*
*   data decomposition						*
*****************************************************************/

#include "Array1XObject2.h"

class FloorPlan: private Array1(XObject2)
{
public:
   /* constructors and destructors 				*/
   inline FloorPlan(){}
   inline FloorPlan(const int n): Array1(XObject2)(n) { }
   inline FloorPlan(const FloorPlan &F) {
       resize(F.size());      
       for_1(i,F) 
	 setregion(i,F(i));
       setowner(i,F(i).owner()); 
       end_for
   }
   inline ~FloorPlan() {}

   /* inline access members					*/
   inline int size() const{return Array1(XObject2)::size();	}
   inline int size(int i) const{return Array1(XObject2)::size(i);	}
   inline void resize(const int n) 
   {	
	Array1(XObject2)::resize(n);
   }
   
   void scale(const FloorPlan &F, int scale);
   
   inline XObject2& operator () (const int i) const
	{ return (Array1(XObject2)::operator()(i)); }
   inline const int lower(const int dim=0) const 
   {  return Array1(XObject2)::lower(dim);			}
   inline const int upper(const int dim=0) const 
   {  return Array1(XObject2)::upper(dim);			}
   inline const int extents(const int dim=0) const 
   {  return Array1(XObject2)::extents(dim);			}
   
   inline void setowner(const int i, const int proc) 
   {
	Array1(XObject2)::ptr(i)->setowner(proc);
   }
   inline void setlower(const int i, const Point2& P) 
   {
	Array1(XObject2)::ptr(i)->setlower(P);
   }
   inline void setlower(const int i, const int dim, const int val) 
   {
	Array1(XObject2)::ptr(i)->get_lower(dim) = val;
   }
   inline void setempty(const int i)
   {
	Array1(XObject2)::ptr(i)->setempty();
   }
   inline void setupper(const int i, const Point2& P)
   {
	Array1(XObject2)::ptr(i)->setupper(P);
   }
   inline void setupper(const int i, const int dim, const int val)
   {
	Array1(XObject2)::ptr(i)->get_upper(dim) = val;
   }
   inline void setregion(const int i, const Region2& R)
   {
	Array1(XObject2)::ptr(i)->setregion(R);
   }
   inline void grow(const int i, const Point2& P)
   {
	Array1(XObject2)::ptr(i)->grow(P);
   }
   inline int getowner(const Point2& P) const
     { 
       for(int i=0; i<size(); i++) if( Array1(XObject2)::ptr(i)->inside(P) ) return i;
       return -1;
     }
};

#endif
